;   _______________________________________________________________
;  |                                                               |
;  |            CopyRight (c) 1989,1990  Steven Lutrov             |
;  |_______________________________________________________________|____
;  |                                                               |    |
;  |  program title : fastbit.asm                                  |    | ___
;  |  author        : Steven Lutrov                                |    |    |
;  |  revision      : 4.00                                         |    |    |
;  |  date          : 1991-11-01                                   |    |    |
;  |  language      : turbo  assembler                             |    |    |
;  |                                                               |    |    |
;  |  description   : assembly functions for bit mannipulation.    |    |    |
;  |                : tested with turbo pascal ver 5.0 5.5         |    |    |
;  |                                                               |    |    |
;  |_______________________________________________________________|    |    |
;      |                                                                |    |
;      |________________________________________________________________|    |
;          |                                                                 |
;          |_________________________________________________________________|
;


code    segment word  public

assume  cs:code


public  bytetohex,rotatebyteleft,rotatewordleft,rotatebyteright
public  rotatewordright,wordtohex


;-------------------------------------------------------------------------------
;function bytetohex(num :byte;): stype;
;-------------------------------------------------------------------------------
;
bytetohex proc far
                push bp                         ;save bp
                mov  bp,sp                      ;set stack frame
                les  di,dword ptr[bp+8]         ;es:di pts to return string
                sub  si,si                      ;si counts chars
                mov  bl,[bp+6]                  ;get the value to convert
                mov  cl,2                       ;string length
                mov  es:[di],cl                 ;set string descriptor
                shl  cl,1                       ;cl=4 bits=one-half byte
bytetohex1:     sub  bh,bh                      ;clear bh
                shl  bx,cl                      ;shift in one-half byte
                cmp  bh,10                      ;is it '0' - '9'?
                jl   bytetohex2                 ;if not, jump ahead
                add  bh,55                      ;10+55 = 'a', etc...
                jmp  short bytetohex3           ;jmp ahead
bytetohex2:     add  bh,48                      ;0+48 = '0', etc...
bytetohex3:     inc  di                         ;pt to next byte of strx
                mov  es:[di],bh                 ;place char in the strx
                inc  si                         ;test char counter
                cmp  si,2                       ;end of string?
                jne  bytetohex1                 ;jump if not
                pop  bp                         ;restore bp
                ret  2
bytetohex endp



;-------------------------------------------------------------------------------
;function rotatewordleft(num: word; nbits :byte;): word;
;-------------------------------------------------------------------------------
;
rotatewordleft proc far
                mov  bx,sp                      ;set stack frame
                mov  cl,ss:[bx+4]               ;number of bits to rotate
                mov  ax,ss:[bx+6]               ;get the integer
                rol  ax,cl                      ;make the rotation
                ret  4
rotatewordleft endp


;-------------------------------------------------------------------------------
;function rotatebyteright(num,nbits :byte;) :byte;;
;-------------------------------------------------------------------------------
;
rotatebyteright proc far
                mov  bx,sp                      ;set stack frame
                mov  cl,ss:[bx+4]               ;number of bits to rotate
                mov  al,ss:[bx+6]               ;get the byte
                ror  al,cl                      ;make the rotation
                ret  4
rotatebyteright endp

;-------------------------------------------------------------------------------
;function rotatebyteleft(num,nbits :byte) :byte;;
;-------------------------------------------------------------------------------
;
rotatebyteleft proc far
                mov  bx,sp                      ;set stack frame
                mov  cx,ss:[bx+4]               ;number of bits to rotate
                mov  al,ss:[bx+6]               ;get the byte
                rol  al,cl                      ;make the rotation
                ret  4
rotatebyteleft endp


;-------------------------------------------------------------------------------
;function rotatewordright(num: word; nbits :byte;): word;
;-------------------------------------------------------------------------------
;
rotatewordright proc far
                mov  bx,sp                      ;set stack frame
                mov  cl,ss:[bx+4]               ;number of bits to rotate
                mov  ax,ss:[bx+6]               ;get the integer
                ror  ax,cl                      ;make the rotation
                ret  4
rotatewordright endp



;-------------------------------------------------------------------------------
;function wordtohex(num: word): stype;
;-------------------------------------------------------------------------------
;
wordtohex proc far
                push bp                         ;save bp
                mov  bp,sp                      ;set stack frame
                les  di,dword ptr[bp+8]         ;es:di pts to return string
                sub  si,si                      ;si counts chars
                mov  ax,[bp+6]                  ;get the value to convert
                mov  cl,4                       ;shifts one-half byte
                mov  es:[di],cl                 ;set string descriptor
                mov  bl,ah                      ;start with high byte
wordtohex1:     sub  bh,bh                      ;clear bh
                shl  bx,cl                      ;shift in one-half byte
                cmp  bh,10                      ;is it '0' - '9'?
                jl   wordtohex2                 ;if not, jump ahead
                add  bh,55                      ;10+55 = 'a', etc...
                jmp  short wordtohex3           ;jmp ahead
wordtohex2:     add  bh,48                      ;0+48 = '0', etc...
wordtohex3:     inc  di                         ;pt to next byte of strx
                mov  es:[di],bh                 ;place char in the strx

                inc  si                         ;test char counter
                test si,1                       ;is strx ctr odd or even?
                jnz  wordtohex1                 ;do 2nd half char if odd
                cmp  si,2                       ;another byte to do?
                jne  wordtohex4                 ;jump if not
                mov  bl,al                      ;fetch low byte
                jmp  short wordtohex1           ;start over on 2nd byte
wordtohex4:     pop  bp                         ;restore bp
                ret  2
wordtohex endp


code    ends
        end

