;   _______________________________________________________________
;  |                                                               |
;  |            CopyRight (c) 1990,1991  Steven Lutrov             |
;  |_______________________________________________________________|____
;  |                                                               |    |
;  |  program title : fastscr.asm                                  |    | ___
;  |  author        : Steven Lutrov                                |    |    |
;  |  revision      : 4.00                                         |    |    |
;  |  date          : 1991-11-01                                   |    |    |
;  |  language      : turbo assembler                              |    |    |
;  |                                                               |    |    |
;  |  description   : assembly functions for primitive screen      |    |    |
;  |                : manipulation .                               |    |    |
;  |                : tested with turbo pascal 6.0                 |    |    |
;  |                                                               |    |    |
;  |_______________________________________________________________|    |    |
;      |                                                                |    |
;      |________________________________________________________________|    |
;          |                                                                 |
;          |_________________________________________________________________|
;


code    segment word  public

assume  cs:code,ds:data


public background,blinkoff,blinkon,clearpage,colourx
public cursordown,cursorleft,cursorright,cursoroff,cursoron,cursorup
public dsp,dspat,dspcolour,dspend,dspjust,dsplncolour,dspln,dsppart
public dspvert,foreground,formatleft,formatright,getcolour,getpage
public intenseoff,intenseon,normal,reverse,rowcolour,setcolour,setpage
public screencolour,swappage


;-------------------------------------------------------------------------------
;                       local subroutine called by dspend
;-------------------------------------------------------------------------------
writeit proc
                push dx                 ;save dx
                mov  dx,es              ;get video buffer address
                cmp  byte ptr[bp+10],0  ;protect against snow?
                je   writeitc9          ;jump ahead if not
                mov  dx,3dah            ;status byte address
                mov  bx,ax              ;save char-attri in bx
writeitc8:      in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  writeitc8          ;loop untill 0
                cli                     ;disable interrupts
writeitc9:      in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   writeitc9          ;loop untill 1
                mov  ax,bx              ;return char-attri to ax
writeitc0:      stosw                   ;write the char and attri
                pop  dx                 ;restore dx and return
                ret
writeit endp


;-------------------------------------------------------------------------------
;procedure background(code :char);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  textattr :byte
data    ends
;
;
background proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  al,textattr        ;get textattr
                and  al,1111b           ;turn off four high bits
                mov  bl,[bp+6]          ;get the code
                cmp  bl,97              ;lower case?
                jae  background1        ;jump ahead if so
                or   al,10000000b       ;set intensity bit
                add  bl,32              ;make it lower case
background1:    sub  bh,bh              ;use bh as mask
                cmp  bl,107             ;black?
                je   background2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,98              ;blue?
                je   background2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,103             ;green?
                je   background2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,99              ;cyan?
                je   background2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,114             ;red?
                je   background2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,109             ;magenta?
                je   background2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,121             ;yellow?
                je   background2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,119             ;white?
                je   background2        ;jump if so
                jmp  short background3  ;else don't change colour
background2:    mov  cl,4               ;shift left by four bits
                shl  bh,cl              ;make the shift
                or   al,bh              ;set the bits
                mov  textattr,al        ;change textattr
                pop  bp                 ;restore bp
background3:    ret  2
background endp


;-------------------------------------------------------------------------------
;procedure blinkoff;
;-------------------------------------------------------------------------------
;
data    segment
        extrn  textattr :byte
data    ends
;
;
blinkoff proc far
                mov  al,textattr        ;get the current colour
                and  al,01111111b       ;clear the relevant bit
                mov  textattr,al        ;set the value
                ret
blinkoff endp


;-------------------------------------------------------------------------------
;procedure blinkon;
;-------------------------------------------------------------------------------
;
data    segment
        extrn  textattr :byte
data    ends
;
;
blinkon proc far
                mov  al,textattr        ;get the current colour
                or   al,10000000b       ;set the relevant bit
                mov  textattr,al        ;set the value
                ret
blinkon endp


;-------------------------------------------------------------------------------
;procedure screencolour(x,y,xx,yy,colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  snow_check :byte
data    ends
;
;
screencolour proc far
                cld                     ;direction flag forward
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  ax,video_buff      ;fetch video_buff
                mov  es,ax              ;place in es
                sub  ax,ax              ;
                mov  al,[bp+12]         ;get y
                dec  ax                 ;count from 0
                mov  dl,160             ;bytes per y
                mul  dl                 ;times y
                sub  dx,dx              ;
                mov  dl,[bp+14]         ;get column
                dec  dx                 ;count from 0
                shl  dx,1               ;double for attributes
                add  ax,dx              ;add to y offset
                mov  si,ax              ;es:di pts to first char
                inc  si                 ;shift to first attribute
                sub  bx,bx              ;
                mov  bl,[bp+10]         ;xx in bx
                or   bx,bx              ;test for zero
                jz   screencol6         ;quit if zero
                sub  dx,dx              ;
                mov  dl,[bp+8]          ;y in dx
                or   dx,dx              ;test for zero
                jz   screencol6         ;quit if zero
                mov  al,[bp+6]          ;attribute in al
screencol1:     mov  cx,bx              ;xx to cx as counter
                mov  di,si              ;move ptr to di
                push dx                 ;save y counter
screencol2:     mov  dx,es              ;get video buffer address
                cmp  snow_check,0       ;protect against snow?
                je   screencol5         ;jump if not
                mov  dx,3dah            ;status byte address
                mov  bp,ax              ;save ax contents
screencol3:     in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  screencol3         ;loop untill 0
                cli                     ;disable interrupts
screencol4:     in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   screencol4         ;loop untill 1
                mov  ax,bp              ;restore ax contents
screencol5:     stosb                   ;write an attribute byte
                inc  di                 ;pt to next attri byte
                loop screencol2         ;go do next attri in line
                pop  dx                 ;restore dx
                dec  dx                 ;dec y counter
                jz   screencol6         ;quit if finished
                add  si,160             ;move ptr forward 1 y
                jmp  short screencol1   ;go do next y
screencol6:     pop  bp                 ;restore bp and quit
                sti                     ;reenable interrupts
                ret  10
screencolour endp

;-------------------------------------------------------------------------------
;procedure colourx(x,y,yy,colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  snow_check :byte
data    ends
;
;
colourx proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  ax,video_buff      ;fetch video_buff segment
                mov  es,ax              ;es pts to buffer
                sub  ax,ax              ;
                mov  al,[bp+12]         ;get x value
                mov  di,ax              ;
                dec  di                 ;count from 0
                shl  di,1               ;double for attri bytes
                mov  al,[bp+10]         ;get y value
                dec  ax                 ;count from 0
                mov  dl,160             ;bytes per y
                mul  dl                 ;times columns
                add  di,ax              ;add y offset
                inc  di                 ;es:di pts to 1st attri
                sub  cx,cx              ;
                mov  cl,[bp+8]          ;line length in cx
                jcxz colourx5           ;quit if null
                mov  al,[bp+6]          ;attribute in al
                cld                     ;direction flag forward
colourx1:       mov  dx,es              ;get video buffer address
                cmp  snow_check,0       ;protect against snow?
                je   colourx4           ;jump if not
                mov  dx,3dah            ;status byte address
                mov  bx,ax              ;save ax contents
colourx2:       in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  colourx2           ;loop untill 0
                cli                     ;disable interrupts
colourx3:       in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   colourx3           ;loop untill 1
                mov  ax,bx              ;restore ax contents
colourx4:       stosb                   ;change attri of 1 char
                add  di,159             ;move pointer to next y
                loop colourx1           ;go change next attribute
colourx5:       sti                     ;enable interrupts
                pop  bp                 ;restore bp
                ret  8
colourx endp

;-------------------------------------------------------------------------------
;procedure cursordown(y :integer);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_page :byte
data    ends
;
;
cursordown proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  bh,video_page       ;get page number
                mov  ah,3               ;func to get cursor pos
                int  10h                ;y in dh, x in dl
                mov  ah,2               ;func to set cursor
                add  dh,[bp+6]          ;add offset
                cmp  dh,24              ;in range?
                jna  cursordown1        ;jump ahead if so
                mov  dh,24              ;else bottom y
cursordown1:    int  10h                ;reset cursor
                pop  bp                 ;restore bp
                ret  2
cursordown endp


;-------------------------------------------------------------------------------
;procedure cursorleft(columns :integer);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_page :byte
data    ends
;
;
cursorleft proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  bh,video_page      ;get page number
                mov  ah,3               ;func to get cursor pos
                int  10h                ;y in dh, x in dl
                mov  ah,2               ;func to set cursor
                sub  dl,[bp+6]          ;subtract offset
                cmp  dl,79              ;in range?
                jna  cursorleft1        ;jump ahead if so
                mov  dl,0               ;else left column
cursorleft1:    int  10h                ;reset cursor
                pop  bp                 ;restore bp
                ret  2
cursorleft endp


;-------------------------------------------------------------------------------
;procedure cursoroff;
;-------------------------------------------------------------------------------
data    segment
        extrn  startline :byte
        extrn  stopline :byte
data    ends
;
;
cursoroff proc far
                mov  ah,3               ;func to get cursor lines
                mov  bh,0               ;page 0
                int  10h                ;ch=start, cl=stop
                mov  startline,ch       ;save startline
                mov  stopline,cl        ;save stopline
                mov  cl,0               ;make stopline 0
                mov  ch,20              ;use too-high number for startline
                mov  ah,1               ;func to set cursor lines
                int  10h                ;make cursor invisible
                ret
cursoroff endp


;-------------------------------------------------------------------------------
;procedure cursoron;
;-------------------------------------------------------------------------------
data    segment
        extrn  startline :byte
        extrn  stopline :byte
data    ends
;
;
cursoron proc far
                mov  ch,startline       ;fetch former startline
                mov  cl,stopline        ;...and stopline
                mov  ah,1               ;func to set cursor lines
                int  10h                ;make cursor invisible
                ret
cursoron endp


;-------------------------------------------------------------------------------
;procedure cursorright(columns :integer);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_page :byte
data    ends
;
;
cursorright proc  far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  bh,video_page      ;get page number
                mov  ah,3               ;func to get cursor pos
                int  10h                ;y in dh, x in dl
                mov  ah,2               ;func to set cursor
                add  dl,[bp+6]          ;add offset
                cmp  dl,79              ;in range?
                jna  cursoron1          ;jump ahead if so
                mov  dl,79              ;else right column
cursoron1:      int  10h                ;reset cursor
                pop  bp                 ;restore bp
                ret  2
cursorright endp


;-------------------------------------------------------------------------------
;procedure cursorup(y :integer);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_page :byte
data    ends
;
;
cursorup proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  bh,video_page      ;get page number
                mov  ah,3               ;func to get cursor pos
                int  10h                ;y in dh, x in dl
                mov  ah,2               ;func to set cursor
                sub  dh,[bp+6]          ;subtract offset
                cmp  dh,24              ;in range?
                jna  cursorup1          ;jump ahead if so
                mov  dh,0               ;else top y
cursorup1:      int  10h                ;reset cursor
                pop  bp                 ;restore bp
                ret  2
cursorup endp


;-------------------------------------------------------------------------------
;procedure dspat(strx: stype; x,y,colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  video_page :byte
        extrn  snow_check :byte
data    ends
;
;
dspat proc far
                cld                     ;direction flag forward
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                push ds                 ;save turbo's ds
                mov  ax,video_buff      ;fetch video_buff
                mov  es,ax              ;place in es
                mov  bl,snow_check      ;fetch snow_check
                mov  bh,video_page      ;fetch video_page
                lds  si,dword ptr[bp+12] ;ds:si pts to strx
                mov  [bp+14],bx         ;save video_page and snow_check
                sub  cx,cx              ;clear cx
                mov  cl,[si]            ;string len counted in cx
                inc  si                 ;pt ds:si to first char
                sub  ax,ax              ;
                mov  al,[bp+10]         ;get x value
                mov  di,ax              ;
                mov  al,[bp+8]          ;get y value
                dec  ax                 ;count from 0
                mov  dl,160             ;bytes per y
                mul  dl                 ;times y
                dec  di                 ;count cols from 0
                shl  di,1               ;double for attributes
                add  di,ax              ;es:di pts to lst pos
                jcxz display5           ;if null, set cursor,quit
                mov  ah,[bp+6]          ;get attribute
display1:       lodsb                   ;get a character
                cmp  byte ptr[bp+14],0  ;protect against snow?
                je   display4           ;jump ahead if not
                mov  dx,3dah            ;status byte address
                mov  bx,ax              ;save ah contents
display2:       in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  display2           ;loop untill 0
                cli                     ;disable interrupts
display3:       in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   display3           ;loop untill 1
                mov  ax,bx              ;restore ah contents
display4:       stosw                   ;write it with attribute
                loop display1           ;go do next
                sti                     ;reenable interrupts
display5:       mov  bh,[bp+15]         ;video page to bh
                mov  ax,di              ;screen pointer
                shr  ax,1               ;div by 2 for attributes
                mov  cl,80              ;div by number cols
                div  cl                 ;make the division
                mov  dh,al              ;y number
                mov  dl,ah              ;x number
                mov  ah,2               ;function to set cursor
                int  10h                ;set curs to final pos
display6:       pop  ds                 ;restore ds and quit                    
                pop  bp                 ;restore bp
                ret  10
dspat endp


;-------------------------------------------------------------------------------
;procedure foreground(code :char);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  textattr :byte
data    ends
;
;
foreground proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  al,textattr        ;get textattr
                and  al,11110000b       ;turn off four low bits
                mov  bl,[bp+6]          ;get the code
                cmp  bl,97              ;lower case?
                jae  foreground1        ;jump ahead if so
                or   al,1000b           ;set intensity bit
                add  bl,32              ;make it lower case
foreground1:    sub  bh,bh              ;use bh as mask
                cmp  bl,107             ;black?
                je   foreground2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,98              ;blue?
                je   foreground2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,103             ;green?
                je   foreground2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,99              ;cyan?
                je   foreground2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,114             ;red?
                je   foreground2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,109             ;magenta?
                je   foreground2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,121             ;yellow?
                je   foreground2        ;jump if so
                inc  bh                 ;increase mask value
                cmp  bl,119             ;white?
                je   foreground2        ;jump if so
                jmp  short foreground3  ;else don't change colour
foreground2:    or   al,bh              ;set the bits
                mov  textattr,al        ;change textattr
                pop  bp                 ;restore bp
foreground3:    ret  2
foreground endp


;-------------------------------------------------------------------------------
;procedure formatleft(strx: stype; how_many :integer; colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  video_page :byte
        extrn  snow_check :byte
data    ends
;
;
formatleft proc far
                cld                     ;set direction flag
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  bh,video_page      ;get bios page
                mov  ax,video_buff      ;fetch video_buff
                mov  es,ax              ;move to es
                push ds                 ;save ds
                mov  ah,3               ;bios call for curs pos
                int  10h                ;dh-dl cursor y-x
                mov  ax,160             ;bytes per y
                mul  dh                 ;times y
                sub  cx,cx              ;clear cx
                mov  cl,dl              ;cols to cx
                shl  cl,1               ;double for attributes
                add  ax,cx              ;add to y offset
                mov  di,ax              ;place offset in di
                mov  bl,snow_check     ;fetch snow_check
                lds  si,dword ptr[bp+10] ;ds:si pts to strx
                mov  byte ptr[bp+10],bl ;keep snow_check
                mov  cl,[si]            ;get strx length
                jcxz formatleft5        ;jump if null
                push dx                 ;save cursor values
                push bx                 ;save video page
                mov  bh,[bp+6]          ;attribute to bh
                inc  si                 ;forword ptr to first byte
formatleft1:    mov  bl,[si]            ;get a char
                cmp  byte ptr[bp+10],0  ;protect against snow?
                je   formatleft4        ;jump if not
                mov  dx,3dah            ;status byte address
formatleft2:    in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  formatleft2        ;loop untill 0
                cli                     ;disable interrupts
formatleft3:    in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   formatleft3        ;loop untill 1
formatleft4:    mov  ax,bx              ;get char-attribute
                stosw                   ;write it
                inc  si                 ;inc strx ptr
                loop formatleft1        ;go do next char
                sti                     ;reenable interrupts
                pop  bx                 ;video page back to bh
                pop  dx                 ;restore cursor values
formatleft5:    mov  cx,[bp+8]          ;get new cursor offset
                test cx,8000h           ;negative?
                jz   formatleft6        ;jump if not
                neg  cx                 ;make positive
                add  dh,cl              ;add to y offset
                cmp  dh,24              ;bottom of screen?
                jb   formatleft7        ;jump if not
                mov  dh,24              ;else edge of screen
                jmp  short formatleft7  ;to set cursor
formatleft6:    add  dl,cl              ;add to x offset
                cmp  dl,79              ;off screen?
                jb   formatleft7        ;jump if not
                mov  dl,79              ;else edge of screen
formatleft7:    mov  ah,2               ;bios func to set curs
                int  10h                ;set new cursor pos
                pop  ds                 ;restore ds
                pop  bp                 ;restore bp and quit
                ret  8
formatleft endp


;-------------------------------------------------------------------------------
;procedure formatright(strx: stype; how_many :integer; colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  video_page :byte
        extrn  snow_check :byte
data    ends
;
;
formatright proc far
                cld                     ;set direction flag
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  bh,video_page      ;get bios page
                mov  ax,video_buff      ;fetch video_buff
                mov  es,ax              ;move to es
                push ds                 ;save ds
                mov  ah,3               ;bios call for curs pos
                int  10h                ;dh-dl cursor y-x
                mov  ax,160             ;bytes per y
                mul  dh                 ;times y
                sub  cx,cx              ;clear cx
                mov  cl,dl              ;cols to cx
                shl  cl,1               ;double for attributes
                add  ax,cx              ;add to y offset
                mov  di,ax              ;place offset in di
                mov  bl,snow_check      ;fetch snow_check
                lds  si,dword ptr[bp+10] ;ds:si pts to strx
                mov  byte ptr[bp+10],bl ;keep snow_check
                mov  cl,[si]            ;get strx length
                jcxz formatright5       ;jump if null
                push dx                 ;save cursor values
                push bx                 ;save video page
                mov  bh,[bp+6]          ;attribute to bh
                add  si,cx              ;pt to end of strx
formatright1:   mov  bl,[si]            ;get a char
                cmp  byte ptr[bp+10],0  ;protect against snow?
                je   formatright4       ;jump if not
                mov  dx,3dah            ;status byte address
formatright2:   in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  formatright2       ;loop untill 0
                cli                     ;disable interrupts
formatright3:   in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   formatright3       ;loop untill 1
formatright4:   mov  ax,bx              ;get char-attribute
                stosw                   ;write it
                sub  di,4               ;pull back scrn ptr
                dec  si                 ;dec strx ptr
                loop formatright1       ;go do next char
                sti                     ;reenable interrupts
                pop  bx                 ;video page back to bh
                pop  dx                 ;restore cursor values
formatright5:   mov  cx,[bp+8]          ;get new cursor offset
                test cx,8000h           ;negative?
                jz   formatright6       ;jump if not
                neg  cx                 ;make positive
                add  dh,cl              ;add to y offset
                cmp  dh,24              ;bottom of screen?
                jb   formatright7       ;jump if not
                mov  dh,24              ;else edge of screen
                jmp  short formatright7 ;to set cursor
formatright6:   add  dl,cl              ;add to x offset
                cmp  dl,79              ;off screen?
                jb   formatright7       ;jump if not
                mov  dl,79              ;else edge of screen
formatright7:   mov  ah,2               ;bios func to set curs
                int  10h                ;set new cursor pos
                pop  ds                 ;restore ds
                pop  bp                 ;restore bp and quit
                ret  8
formatright endp


;-------------------------------------------------------------------------------
;function getcolour(x,y :byte;) :byte;;
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_page :byte
data    ends
;
getcolour proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  bh,video_page      ;set the page
                mov  dh,[bp+6]          ;y to dh
                dec  dh                 ;count from 0
                mov  dl,[bp+8]          ;x to dl
                dec  dl                 ;count from 0
                mov  ah,2               ;function to set cursor
                int  10h                ;set the cursor
                mov  ah,8               ;func to read attribute
                int  10h                ;colour now in ah
                mov  al,ah              ;colour to al
                sub  ah,ah              ;clear high byte
                pop  bp                 ;restore bp and quit
                ret  4
getcolour endp


;-------------------------------------------------------------------------------
;procedure intenseoff;
;-------------------------------------------------------------------------------
;
data    segment
        extrn  textattr :byte
data    ends
;
;
intenseoff proc far
                mov  al,textattr        ;get the current colour
                and  al,11110111b       ;clear the relevant bit
                mov  textattr,al        ;set the value
                ret
intenseoff endp


;-------------------------------------------------------------------------------
;procedure intenseon;
;-------------------------------------------------------------------------------
;
data    segment
        extrn  textattr :byte
data    ends
;
;
intenseon proc far
                mov  al,textattr        ;get the current colour
                or   al,1000b           ;set the relevant bit
                mov  textattr,al        ;set the value
                ret
intenseon endp


;-------------------------------------------------------------------------------
;procedure normal;
;-------------------------------------------------------------------------------
;
data    segment
        extrn  textattr :byte
data    ends
;
;
normal proc far
                mov  al,textattr        ;get current setting
                and  al,10001000b       ;relevant bits off
                or   al,111b            ;relevant bits on
                mov  textattr,al        ;set new value
                ret
normal endp


;-------------------------------------------------------------------------------
;procedure reverse;
;-------------------------------------------------------------------------------
;
data    segment
        extrn  textattr :byte
data    ends
;
;
reverse proc far
                mov  al,textattr        ;get the current colour
                and  al,10001000b       ;relevant bits off
                or   al,1110000b        ;relevant bits on
                mov  textattr,al        ;set new value
                ret
reverse endp


;-------------------------------------------------------------------------------
;procedure rowcolour(x,y,xx,colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  snow_check :byte
data    ends
;
;
rowcolour proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  ax,video_buff      ;segment of video_buff
                mov  es,ax              ;move to es
                sub  ax,ax              ;
                mov  al,[bp+12]         ;get x value
                mov  di,ax              ;
                dec  di                 ;count from 0
                mov  al,[bp+10]         ;get y value
                dec  ax                 ;count from 0
                mov  dl,160             ;bytes per y
                mul  dl                 ;times number y
                shl  di,1               ;double for attri bytes
                add  di,ax              ;add y offset
                inc  di                 ;es:di pts to 1st attri
                sub  cx,cx              ;
                mov  cl,[bp+8]          ;line length in cx
                jcxz rowcolour5         ;quit if null
                mov  al,[bp+6]          ;attribute in al
                cld                     ;direction flag forward
rowcolour1:     cmp  snow_check,0       ;protect against snow?
                je   rowcolour4         ;jump if not
                mov  dx,3dah            ;status byte address
                mov  bx,ax              ;save ax contents
rowcolour2:     in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  rowcolour2         ;loop untill 0
                cli                     ;disable interrupts
rowcolour3:     in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   rowcolour3         ;loop untill 1
                mov  ax,bx              ;restore ax contents
rowcolour4:     stosb                   ;change attri of 1 char
                inc  di                 ;skip pointer over next
                loop rowcolour1         ;go change next attribute
rowcolour5:     sti                     ;reenable interrupts
                pop  bp                 ;restore bp
                ret  8
rowcolour endp



;-------------------------------------------------------------------------------
;procedure setcolour(x,y,colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_page :byte
data    ends
;
;
setcolour proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  bh,video_page      ;set the page
                mov  dh,[bp+8]          ;y to dh
                dec  dh                 ;count from 0
                mov  dl,[bp+10]         ;x to dl
                dec  dl                 ;count from 0
                mov  ah,2               ;function to set cursor
                int  10h                ;set the cursor
                mov  ah,8               ;func to read attribute
                int  10h                ;char now in al
                mov  ah,9               ;function to write char
                mov  cx,1               ;write at 1 pos only
                mov  bl,[bp+6]          ;new attribute
                int  10h                ;set the new attribute
                pop  bp                 ;restore bp
                ret  6
setcolour endp


;-------------------------------------------------------------------------------
;procedure setpage(pagenumber :integer);
;-------------------------------------------------------------------------------
setpage proc far
                mov  bx,sp              ;bx pts to stack
                mov  ah,5               ;function number
                mov  al,ss:[bx+4]       ;page number
                int  10h                ;set the current page
                ret  2
setpage endp


;-------------------------------------------------------------------------------
;procedure dspcolour(strx: stype; colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  video_page :byte
        extrn  snow_check :byte
data    ends
;
;
dspcolour proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                push ds                 ;ds changed
                cld                     ;direction flag forward
                mov  ax,video_buff      ;fetch video_buff
                mov  es,ax              ;place in es
                mov  bh,video_page      ;set the cursor page
                mov  bl,snow_check      ;get snow_check
                mov  ah,3               ;bios func for cursor pos
                int  10h                ;now dh-dl holds y-x
                lds  si,dword ptr[bp+8] ;ds:si pts to strx
                mov  [bp+8],bx          ;save page number and snow_check
                sub  cx,cx              ;clear cx
                mov  cl,[si]            ;string len counted in cx
                jcxz dspc8              ;quit if null
                inc  si                 ;pt ds:si to first char
                mov  ax,160             ;byte per row
                mul  dh                 ;multiply by num rows
                sub  dh,dh              ;now dx holds num cols
                shl  dx,1               ;double for attri bytes
                add  ax,dx              ;cursor offset in buffer
                mov  di,ax              ;now es:di pts to pos
                mov  bx,3998            ;scroll if won't fit...
                sub  bx,di              ;space left
                mov  ax,cx              ;chars to be printed
                shl  ax,1               ;double for attributes
                cmp  bx,ax              ;enough room?
                jge  dspc3              ;jump ahead if so
                sub  ax,bx              ;amount space required
                mov  bl,160             ;byte per y
                div  bl                 ;divide
                cmp  ah,0               ;any remainder?
                je   dspc1              ;if not, jump ahead
                inc  al                 ;else, scroll 1 more line
dspc1:          push cx                 ;save string length
                push bp                 ;scrolling changes bp
                push ax                 ;save num lines scrolled
                mov  bh,[bp+6]          ;attribute of new lines
                mov  cx,0000h           ;top left y-x
                mov  dx,184fh           ;bottom right y-x
                mov  ah,6               ;upwards scroll function
                int  10h                ;make the scroll
                pop  cx                 ;num lines scrolled in cl
                sub  ch,ch              ;clear ch, use cx counter
dspc2:          sub  di,160             ;screen ptr back 1 line
                loop dspc2              ;repeat for ea ln of scrl
                pop  bp                 ;restore bp
                pop  cx                 ;restore string length
dspc3:          mov  ah,[bp+6]          ;get attribute
dspc4:          lodsb                   ;get a character
                mov  dx,es              ;get video buffer address
                cmp  byte ptr[bp+8],0   ;protect against show?
                je   dspc7              ;jump ahead if not
                mov  dx,3dah            ;status byte address
                mov  bx,ax              ;save ax contents
dspc5:          in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  dspc5              ;loop untill 0
                cli                     ;disable interrupts
dspc6:          in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   dspc6              ;loop untill 1
                mov  ax,bx              ;restore ax contents
dspc7:          stosw                   ;write char and attri
                loop dspc4              ;go do next
                sti                     ;reenable interrupts
                mov  ax,di              ;now set new cursor pos
                mov  dl,160             ;chars in a y
                div  dl                 ;divide scrn ptr
                shr  ah,1               ;div remainder by 2
                mov  dl,ah              ;bios: x in dl
                mov  dh,al              ;y in dh
                mov  bh,[bp+9]          ;page number
                mov  ah,2               ;function number
                int  10h                ;set the cursor
dspc8:          pop  ds                 ;restore ds and quit
                pop  bp                 ;restore bp
                ret  6
dspcolour endp


;-------------------------------------------------------------------------------
;procedure dsp(strx: stype);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  video_page :byte
        extrn  snow_check :byte
        extrn  textattr :byte
data    ends
;
;
dsp    proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                push ds                 ;ds changed
                cld                     ;direction flag forward
                mov  ax,video_buff      ;get video buffer address
                mov  es,ax              ;place it in es
                mov  al,textattr        ;get colour
                mov  ah,snow_check      ;get snow_check
                mov  bh,video_page      ;set the cursor page
                lds  si,dword ptr[bp+6] ;ds:si pts to strx
                mov  [bp+6],ax          ;save colour and snow_check
                mov  [bp+8],bh          ;save video_page
                mov  ah,3               ;bios func for cursor pos
                int  10h                ;now dh-dl holds y-x
                sub  cx,cx              ;clear cx
                mov  cl,[si]            ;string len counted in cx
                cmp  cl,0               ;null string?
                je   dspll8             ;quit if so
                inc  si                 ;now ds:si pts to strx
                mov  ax,160             ;cursor pos :byte;s in y
                mul  dh                 ;multiply by num y
                sub  dh,dh              ;now dx holds num cols
                shl  dx,1               ;double for attri bytes
                add  ax,dx              ;cursor offset in buffer
                mov  di,ax              ;now es:di pts to pos
                mov  bx,3998            ;scroll if won't fit...
                sub  bx,di              ;space left
                mov  ax,cx              ;chars to be printed
                shl  ax,1               ;double for attributes
                cmp  bx,ax              ;enough room?
                jge  dspll3             ;jump ahead if so
                sub  ax,bx              ;amount space required
                mov  bl,160             ;bytes in a y
                div  bl                 ;divide
                cmp  ah,0               ;any remainder?
                je   dspll1             ;if not, jump ahead
                inc  al                 ;else, scroll 1 more line
dspll1:         push cx                 ;save string length
                push bp                 ;scrolling changes bp
                push ax                 ;save num lines scrolled
                mov  bh,7               ;attribute of new lines
                mov  cx,0000h           ;top left y-x
                mov  dx,184fh           ;bottom right y-x
                mov  ah,6               ;upwards scroll function
                int  10h                ;make the scroll
                pop  cx                 ;num lines scrolled in cl
                sub  ch,ch              ;clear ch, use cx counter
dspll2:         sub  di,160             ;screen ptr back 1 line
                loop dspll2             ;repeat for ea ln of scrl
                pop  bp                 ;restore bp
                pop  cx                 ;restore string length
dspll3:         mov  ah,[bp+6]          ;get attribute
dspll4:         lodsb                   ;get a character
                cmp  byte ptr[bp+7],0   ;protect against snow?
                je   dspll7             ;jump ahead if not
                mov  dx,3dah            ;status byte address
                mov  bx,ax              ;save char/attri in bx
dspll5:         in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  dspll5             ;loop untill 0
                cli                     ;disable interrupts
dspll6:         in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   dspll6             ;loop untill 1
                mov  ax,bx              ;restore char to ax
dspll7:         stosw                   ;write it with attribute
                loop dspll4             ;go do next
                sti                     ;reenable interrupts
                mov  ax,di              ;now set new cursor pos
                mov  dl,160             ;chars in a y
                div  dl                 ;divide scrn ptr
                shr  ah,1               ;div remainder by 2
                mov  dl,ah              ;bios: x in dl
                mov  dh,al              ;y in dh
                mov  bh,[bp+8]          ;page number
                mov  ah,2               ;function number
                int  10h                ;set the cursor
dspll8:         pop  ds                 ;restore ds and quit
                pop  bp                 ;restore bp
                ret  4
dsp    endp


;-------------------------------------------------------------------------------
;procedure dspln(strx: stype);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  video_page :byte
        extrn  snow_check :byte
        extrn  textattr :byte
data    ends
;
;
dspln  proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                push ds                 ;ds changed
                cld                     ;direction flag forward
                mov  ax,video_buff      ;get video buffer address
                mov  es,ax              ;place in es
                mov  al,textattr        ;get colour value
                mov  ah,snow_check      ;get snow_check
                mov  bh,video_page      ;set the cursor page
                lds  si,dword ptr[bp+6] ;ds:si pts to strx
                mov  [bp+8],bh          ;save page numberzz
                mov  [bp+6],ax          ;save colour and snow_check
                mov  ah,3               ;bios func for cursor pos
                int  10h                ;now dh-dl holds y-x
                sub  cx,cx              ;clear cx
                mov  cl,[si]            ;string len counted in cx
                inc  si                 ;now ds:si pts to strx
                mov  ax,160             ;cursor pos :byte;s in y
                mul  dh                 ;multiply by num y
                sub  dh,dh              ;now dx holds num cols
                shl  dx,1               ;double for attri bytes
                add  ax,dx              ;cursor offset in buffer
                mov  di,ax              ;now es:di pts to pos
                mov  bx,3840            ;scrl if won't fit y 24
                sub  bx,di              ;space left
                mov  ax,cx              ;chars to be printed
                shl  ax,1               ;double for attributes
                or   cx,cx              ;test for null string
                jnz  dspline1           ;jump if not null
                cmp  di,3840            ;last y?
                jnge dspline1           ;jump if not
                mov  al,1               ;scroll if null on y 25
                jmp  short dspline2     ;jump ahead
dspline1:       cmp  bx,ax              ;enough room?
                jge  dspline4           ;jump ahead if so
                sub  ax,bx              ;amount space required
                mov  bl,160             ;bytes in a y
                div  bl                 ;divide
                cmp  ah,0               ;any remainder?
                je   dspline2           ;if not, jump ahead
                inc  al                 ;else, scroll 1 more line
dspline2:       push cx                 ;save string length
                push bp                 ;scrolling changes bp
                push ax                 ;save num lines scrolled
                mov  bh,7               ;attribute of new lines
                mov  cx,0000h           ;top left y-x
                mov  dx,184fh           ;bottom right y-x
                mov  ah,6               ;upwards scroll function
                int  10h                ;make the scroll
                pop  cx                 ;num lines scrolled in cl
                sub  ch,ch              ;clear ch, use cx counter
dspline3:       sub  di,160             ;screen ptr back 1 line
                loop dspline3           ;repeat for ea ln of scrl
                pop  bp                 ;restore bp
                pop  cx                 ;restore string length
dspline4:       or   cx,cx              ;test for null string
                jnz  dspline5           ;jump if not null
                add  di,160             ;increase screen ptr
                jmp  dspline9           ;jump and set cursor
dspline5:       mov  ah,[bp+6]          ;get attribute
                lodsb                   ;get a character
                cmp  byte ptr[bp+7],0   ;protect against snow?
                je   dspline8           ;jump ahead if not
                mov  dx,3dah            ;status byte address
                mov  bx,ax              ;save char-attri in bx
dspline6:       in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  dspline6           ;loop untill 0
                cli                     ;disable interrupts
dspline7:       in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   dspline7           ;loop untill 1
                mov  ax,bx              ;char-attri back to ax
dspline8:       stosw                   ;write it with attribute
                loop dspline5           ;go do next
                sti                     ;reenable interrupts
dspline9:       mov  ax,di              ;now set new cursor pos
                mov  dl,160             ;chars in a y
                div  dl                 ;divide scrn ptr
                shr  ah,1               ;div remainder by 2
                mov  dh,al              ;bios: y in dh
                mov  dl,ah              ;x in dl
                cmp  dl,0               ;already at new line?
                je   dspline10          ;if so, jump ahead
                inc  dh                 ;else add 1 more line
                mov  dl,0               ;set cursor to x 0
dspline10:      mov  bh,[bp+8]          ;page number
                mov  ah,2               ;function number
                int  10h                ;set the cursor
                pop  ds                 ;restore ds
                pop  bp                 ;restore bp
                ret  4
dspln  endp


;-------------------------------------------------------------------------------
;procedure dspend(strx: stype; x,y,length,colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  snow_check :byte
        extrn  TPFError :byte
data    ends
;
;
dspend proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                push ds                 ;ds changed
                cld                     ;set direction flag
                mov  ax,video_buff      ;fetch video_buff
                mov  es,ax              ;es pts to buffer
                mov  bl,snow_check      ;get snow_check before change ds
                lds  si,dword ptr[bp+14] ;ds:si pts to strx
                sub  cx,cx              ;clear cx
                mov  cl,[si]            ;string len counted in cx
                inc  si                 ;pt si to 1st chr of strx
                sub  ax,ax              ;
                mov  al,[bp+10]         ;get y value
                mov  byte ptr[bp+10],bl ;save snow_check
                mov  byte ptr[bp+11],1  ;TPFError 1 = len(strx) > length
                dec  ax                 ;count from zero
                mov  dl,160             ;160 bytes per line
                mul  dl                 ;times number y
                sub  dx,dx              ;
                mov  dl,[bp+8]          ;move line length to dx
                or   dx,dx              ;null?
                jz   dspendll1          ;quit if so
                mov  byte ptr[bp+11],0  ;else 0 = no error
dspendll1:      cmp  dx,cx              ;strx shorter?
                jnae dspendll2          ;jump ahead if so
                sub  dx,cx              ;num chars at end of line
                jmp  short dspendll3    ;jump ahead
dspendll2:      mov  dx,0               ;else draw no extra chars
dspendll3:      sub  bx,bx              ;
                mov  bl,[bp+12]         ;get x value
                mov  di,bx              ;
                dec  di                 ;count from zero
                shl  di,1               ;double for attri bytes
                add  di,ax              ;now es:di pts to lst pos
                mov  ah,[bp+6]          ;get attribute
                jcxz dspendll5          ;jump ahead if strx null
dspendll4:      lodsb                   ;get a character
                call writeit            ;write char and attri
                loop dspendll4          ;go do next
dspendll5:      mov  cx,dx              ;num chars at end of line
                mov  al,32              ;space character
                jcxz dspendll7          ;jump if none to write
dspendll6:      call writeit            ;write char and attribute
                loop dspendll6          ;go do next
dspendll7:      pop  ds                 ;restore ds
                mov  al,[bp+11]         ;fetch TPFError
                mov  TPFError,al       ;set it
                pop  bp                 ;restore bp
                sti                     ;reenable interrupts
                ret  12                 ;return to caller
dspend endp



;-------------------------------------------------------------------------------
;procedure dsplncolour(strx: stype; colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  video_page :byte
        extrn  snow_check :byte
data    ends
;
;
dsplncolour   proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                push ds                 ;ds changed
                cld                     ;direction flag forward
                mov  ax,video_buff      ;get video buffer address
                mov  es,ax              ;place in es
                mov  bh,video_page      ;set the cursor page
                mov  bl,snow_check      ;fetch snow_check
                mov  ah,3               ;bios func for cursor pos
                int  10h                ;now dh-dl holds y-x
                lds  si,dword ptr[bp+8] ;ds:si pts to strx
                mov  [bp+8],bx          ;save video_page and snow_check
                sub  cx,cx              ;clear cx
                mov  cl,[si]            ;string len counted in cx
                inc  si                 ;now ds:si pts to strx
                mov  ax,160             ;cursor pos :byte;s in y
                mul  dh                 ;multiply by num y
                sub  dh,dh              ;now dx holds num cols
                shl  dx,1               ;double for attri bytes
                add  ax,dx              ;cursor offset in buffer
                mov  di,ax              ;now es:di pts to pos
                mov  bx,3840            ;scrl if won't fit y 24
                sub  bx,di              ;space left
                mov  ax,cx              ;chars to be printed
                shl  ax,1               ;double for attributes
                or   cx,cx              ;test for null string
                jnz  dsplnc1            ;jump if not null
                cmp  di,3840            ;last y?
                jnge dsplnc1            ;jump if not
                mov  al,1               ;scroll if null on y 25
                jmp  short dsplnc2      ;jump ahead
dsplnc1:        cmp  bx,ax              ;enough room?
                jge  dsplnc4            ;jump ahead if so
                sub  ax,bx              ;amount space required
                mov  bl,160             ;bytes in a y
                div  bl                 ;divide
                cmp  ah,0               ;any remainder?
                je   dsplnc2            ;if not, jump ahead
                inc  al                 ;else, scroll 1 more line
dsplnc2:        push cx                 ;save string length
                push bp                 ;scrolling changes bp
                push ax                 ;save num lines scrolled
                mov  bh,[bp+6]          ;attribute of new lines
                mov  cx,0000h           ;top left y-x
                mov  dx,184fh           ;bottom right y-x
                mov  ah,6               ;upwards scroll function
                int  10h                ;make the scroll
                pop  cx                 ;num lines scrolled in cl
                sub  ch,ch              ;clear ch, use cx counter
dsplnc3:        sub  di,160             ;screen ptr back 1 line
                loop dsplnc3            ;repeat for ea ln of scrl
                pop  bp                 ;restore bp
                pop  cx                 ;restore string length
dsplnc4:        or   cx,cx              ;test for null string
                jnz  dsplnc5            ;jump if not null
                add  di,160             ;increase screen ptr
                jmp  dsplnc10           ;jump and set cursor
dsplnc5:        mov  ah,[bp+6]          ;get attribute
dsplnc6:        lodsb                   ;get a character
                mov  dx,es              ;get video buffer address
                cmp  byte ptr[bp+8],0   ;protect against snow?
                je   dsplnc9            ;jump ahead if not
                mov  dx,3dah            ;status byte address
                mov  bx,ax              ;save ax contents
dsplnc7:        in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  dsplnc7            ;loop untill 0
                cli                     ;disable interrupts
dsplnc8:        in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   dsplnc8            ;loop untill 1
                mov  ax,bx              ;char/attri back to ax
dsplnc9:        stosw                   ;write it with attribute
                loop dsplnc6            ;go do next
                sti                     ;reenable interrupts
dsplnc10:       mov  ax,di              ;now set new cursor pos
                mov  dl,160             ;chars in a y
                div  dl                 ;divide scrn ptr
                shr  ah,1               ;div remainder by 2
                mov  dh,al              ;bios: y in dh
                mov  dl,ah              ;x in dl
                cmp  dl,0               ;already at new line?
                je   dsplnc11           ;if so, jump ahead
                inc  dh                 ;else add 1 more line
                mov  dl,0               ;set cursor to x 0
dsplnc11:       mov  bh,[bp+9]          ;page number
                mov  ah,2               ;function number
                int  10h                ;set the cursor
                pop  ds                 ;restore ds
                pop  bp                 ;restore bp
                ret  6
dsplncolour   endp


;-------------------------------------------------------------------------------
;procedure dsppart(strx: stype; start,numch,x,y,colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  snow_check :byte
        extrn  TPFError :byte
data    ends
;
;
;
dsppart proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  cl,snow_check      ;get snow_check
                push ds                 ;save turbo's ds
                mov  ax,video_buff      ;fetch video_buff
                mov  es,ax              ;es pts to buffer
                sub  bx,bx              ;
                mov  bl,[bp+8]          ;y
                dec  bx                 ;count from zero
                mov  [bp+8],cl          ;save snow_check
                sub  cx,cx              ;
                mov  cl,[bp+10]         ;x
                dec  cx                 ;count from zero
                mov  ax,160             ;bytes per y
                mul  bl                 ;y offset
                shl  cx,1               ;dble cols for attributes
                add  ax,cx              ;offset to start position
                mov  di,ax              ;es:di pts to start
                lds  si,dword ptr[bp+16] ;ds:si pts to strx
                sub  cx,cx              ;clear cx
                mov  cl,[si]            ;get string descriptor
                mov  bh,1               ;error code 1 = null strx
                jcxz displaypartl7      ;quit if null
                mov  al,[bp+14]         ;startpoint
                inc  bh                 ;2 = start outside of string
                cmp  al,cl              ;start point in range?
                jnbe displaypartl7      ;quit if not
                or   al,al              ;test for zero
                jz   displaypartl7      ;
                inc  bh                 ;3 = not enough room for numch
                cmp  byte ptr[bp+12],0  ;check for numch nonzero
                jz   displaypartl7      ;quit if zero
                mov  ah,al              ;copy startpoint
                add  ah,[bp+12]         ;add number chars
                dec  ah                 ;adjust
                cmp  ah,cl              ;in range?
                jna  displaypartl1      ;jump ahead if ok
                sub  cl,[bp+14]         ;number chars to write
                inc  cl                 ;adjust
                jmp  short displaypartl2 ;
displaypartl1:  mov  cl,[bp+12]         ;num chars to write
                sub  bh,bh              ;0 = no error
displaypartl2:  sub  ah,ah              ;extend byte value
                add  si,ax              ;offset string ptr
                cld                     ;forward direction
                mov  ah,[bp+6]          ;get screen attribute
displaypartl3:  lodsb                   ;get a char from strx
                cmp  byte ptr[bp+8],0   ;protect against snow?
                je   displaypartl6      ;jump if not
                push ax                 ;save char-attri
                mov  dx,3dah            ;status byte address
displaypartl4:  in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  displaypartl4      ;loop untill 0
                cli                     ;disable interrupts
displaypartl5:  in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   displaypartl5      ;loop untill 1, then write
                pop  ax                 ;restore char-attri
displaypartl6:  stosw                   ;write the char and colour
                loop displaypartl3      ;loop untill finished
displaypartl7:  sti                     ;reenable interrupts
                pop  ds                 ;restore ds and quit
                mov  TPFError,bh       ;set TPFError
                pop  bp                 ;restore bp
                ret  14
dsppart endp


;-------------------------------------------------------------------------------
;procedure dspjust(strx: stype; x,y,colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  snow_check :byte
data    ends
;
;
dspjust proc far
                push bp                 ;save bp
                mov  bp,sp              ;set stack frame
                mov  cl,snow_check      ;get snow_check
                push ds                 ;save turbo's ds
                mov  ax,video_buff      ;fetch video_buff
                mov  es,ax              ;es pts to buffer
                sub  bx,bx              ;
                mov  bl,[bp+8]          ;y
                dec  bx                 ;count from zero
                mov  byte ptr[bp+8],cl  ;save snow_check
                sub  cx,cx              ;
                mov  cl,[bp+10]         ;x
                dec  cx                 ;count from zero
                mov  ax,160             ;bytes per y
                mul  bl                 ;y offset
                shl  cx,1               ;dble cols for attributes
                add  ax,cx              ;offset to start position
                mov  di,ax              ;es:di pts to start
                lds  si,dword ptr[bp+12] ;ds:si pts to strx
                sub  cx,cx              ;clear cx
                mov  cl,[si]            ;get string descriptor
                jcxz dspjust5           ;quit if null
                add  si,cx              ;pt to end of strx
                std                     ;reverse direction
                mov  ah,[bp+6]          ;get screen attribute
dspjust1:       lodsb                   ;get a char from strx
                cmp  byte ptr[bp+8],0   ;protect against snow?
                je   dspjust4           ;jump if not
                mov  bx,ax              ;save char-attri in bx
                mov  dx,3dah            ;status byte address
dspjust2:       in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  dspjust2           ;loop untill 0
                cli                     ;disable interrupts
dspjust3:       in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   dspjust3           ;loop untill 1, then write
                mov  ax,bx              ;return char/attri to ax
dspjust4:       stosw                   ;write the char and colour
                loop dspjust1           ;loop untill finished
dspjust5:       sti                     ;reenable interrupts
                pop  ds                 ;restore ds and quit
                pop  bp                 ;restore bp
                ret  10
dspjust endp


;-------------------------------------------------------------------------------
;procedure dspvert(strx: stype; x,y,colour :byte;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  video_buff:word
        extrn  snow_check :byte
data    ends
;
;
dspvert proc far
                cld                     ;direction flag forward
                push bp                 ;bp altered
                mov  bp,sp              ;set stack frame
                push ds                 ;save ds
                mov  ax,video_buff      ;fetch video_buff
                mov  es,ax              ;es points to buffer
                mov  bl,snow_check      ;fetch snow_check before ds change
                lds  si,dword ptr[bp+12] ;ds:si pts to strx
                mov  [bp+12],bl         ;save snow_check
                sub  ax,ax              ;
                mov  al,[bp+8]          ;y to ax
                dec  ax                 ;count from 0
                mov  dl,160             ;bytes per y
                mul  dl                 ;times y
                sub  dx,dx              ;
                mov  dl,[bp+10]         ;column to dx
                dec  dx                 ;count from 0
                shl  dx,1               ;double for attributes
                add  ax,dx              ;add to y offset
                mov  di,ax              ;es:di pts to screen
                mov  ah,[bp+6]          ;attribute to ah
                sub  cx,cx              ;clear cx
                mov  cl,[si]            ;string length to cx
                jcxz dspvertical5       ;quit if null
dspvertical1:   inc  si                 ;inc string pointer
                mov  al,[si]            ;char to al
                cmp  byte ptr[bp+12],0  ;protect against snow?
                je   dspvertical4       ;jump ahead if not
                mov  dx,3dah            ;status byte address
                mov  bx,ax              ;save char-attri in bx
dspvertical2:   in   al,dx              ;get status byte
                test al,1               ;test bit
                jnz  dspvertical2       ;loop untill 0
                cli                     ;disable interrupts
dspvertical3:   in   al,dx              ;get status byte
                test al,1               ;test bit
                jz   dspvertical3       ;loop untill 1
                mov  ax,bx              ;return char-attri to ax
dspvertical4:   stosw                   ;write the char & attri
                add  di,158             ;ptr to next y
                loop dspvertical1       ;go write next char
dspvertical5:   sti                     ;reenable interrupts
                pop  ds                 ;restore ds
                pop  bp                 ;restore bp and quit
                ret  10
dspvert endp



;-------------------------------------------------------------------------------
;function getpage :integer;
;-------------------------------------------------------------------------------
;
getpage proc far
                mov  ah,0fh             ;function number
                int  10h                ;get the current page
                mov  al,bh              ;shift page num to al
                sub  ah,ah              ;clear ah
                ret
getpage endp

;-------------------------------------------------------------------------------
;procedure swappage(box :pointer; pagenumber :byte;);
;-------------------------------------------------------------------------------
;
swappage proc far
                push bp                         ;save bp
                mov  bp,sp                      ;set stack frame
                push ds                         ;save ds
                mov  bl,snow_check              ;fetch snow_check
                cld                             ;set direction flag
                mov  cx,video_buff              ;get video buffer addr
                mov  dl,[bp+6]                  ;get page number
                mov  ax,1000h                   ;page size
                mul  dl                         ;times number pages
                add  ax,cx                      ;add to buffer offset
                mov  es,ax                      ;es pts to page
                lds  si,dword ptr[bp+8]         ;ds:si pts to byte array
                mov  cx,2000                    ;number words to exchange
                sub  di,di                      ;point di to 0 offset
                cmp  bl,0                       ;snow_check?
                je   swappagel1                 ;jump if not
                mov  dx,3d8h                    ;cga mode select register
                mov  al,25h                     ;shuts off screen
                out  dx,al                      ;disable video
swappagel1:     mov  ax,es:[di]                 ;get video word
                xchg ax,[si]                    ;xchg with word in box
                stosw                           ;move box word to screen
                add  si,2                       ;forward box ptr
                loop swappagel1                 ;go do next word
                cmp  bl,0                       ;snow protect?
                je   swappagel2                 ;jump ahead if not
                mov  dx,3d8h                    ;cga mode select register
                mov  al,41                      ;80x25, blink enabled
                out  dx,al                      ;reenable video
swappagel2:     pop  ds                         ;restore ds
                pop  bp                         ;restore bp
                ret  6
swappage endp

;-------------------------------------------------------------------------------
;procedure clearpage(pagenumber,colour :byte;);
;-------------------------------------------------------------------------------
;
clearpage proc far
                push bp                         ;save bp
                mov  bp,sp                      ;set stack frame
                mov  bh,[bp+8]                  ;page number to bh
                mov  ah,2                       ;bios func to set cursor
                sub  dx,dx                      ;y and column are 0,0
                int  10h                        ;set the cursor
                mov  ah,9                       ;bios write function
                mov  al,32                      ;clear with space char
                mov  bl,[bp+6]                  ;attribute to bl
                mov  cx,2000                    ;chars to write
                int  10h                        ;clear the page
                pop  bp                         ;restore bp
                ret  4
clearpage endp

code    ends
        end

