{***************************************}
{  ISVGA256 BGI driver  unit interface  }
{       Thomas Design                   }
{       Nov.  28,  1989                 }
{***************************************}

unit ISVGADET;
interface

const
     ATI320x200   = $00;               { ATI VGA graphics modes }
     ATI640x400   = $01;
     ATI640x480   = $02;
     ATI800x600   = $03;

     DVGA320x200  = $04;               { Tseng Labs VGA graphics modes }
     DVGA640x350  = $05;
     DVGA640x480  = $06;
     DVGA800x600  = $07;

     PAR320x200   = $08;               { Paradise 256 color VGA modes }
     PAR640x400   = $09;
     PAR640x480   = $0a;

     TEC320x200   = $0b;               { Tecmar VGA graphics modes }
     TEC640x350   = $0c;
     TEC640x400   = $0d;
     TEC640x480   = $0e;
     TEC800x600   = $0f;

     VID320x200   = $10;               { Video 7 VGA graphics modes }
     VID640x400   = $11;
     VID640x480   = $12;
     VID720x540   = $13;
     VID800x600   = $14;
  TRID320x200   =       $15;          
  TRID640x400   =       $16;
  TRID640x480   =       $17;
  TRID800x600   =       $18;

  CHIP320x200   =       $19;          
  CHIP640x400   =       $1a;
  CHIP640x480   =       $1b;
  CHIP800x600   =       $1c;

  AHDA320x200   =       $1d;          
  AHDA640x400   =       $1e;
  AHDA640x480   =       $1f;
  AHDA800x600   =       $20;

  AHDB320x200   =       $21;          
  AHDB640x400   =       $22;
  AHDB640x480   =       $23;
  AHDB800x600   =       $24;
  AHDB1024x768  =       $25;

  EVRX320x200   =       $26;     
  EVRX640x400   =       $27;
  EVRX640x480   =       $28;
  EVRX800x600   =       $29;

  OAK320x200    =       $2A;     
  OAK640x480    =       $2B;
  OAK800x600    =       $2C;

  TSG320x200    =       $2D;     
  TSG640x400    =       $2E;
  TSG640x800    =       $2F;
  TSG800x600    =       $30;
  TSG1024x768   =       $31;

  GEN320x200    =       $32;     
  GEN640x400    =       $33;
  GEN640x480    =       $34;
  GEN800x600    =       $35;


procedure _ISVGADriverProc;
function  _DetectISVGA256:integer;

implementation
procedure _ISVGADRIVERPROC; external;
{$L ISVGA256.OBJ }
function  _DetectISVGA256;  external;
{$L ISVGADET.OBJ }
end.
