UNIT POPASCII;
INTERFACE
  USES IOSTUFF,CRT;
  PROCEDURE SetChooseASCII(X,Y:Integer);
  FUNCTION ChooseASCII:Char;
IMPLEMENTATION
 VAR
      ChNow      : Integer;
      TopLeft    : Integer;
      XPos       : Integer;   { These constants control the location }
      YPos       : Integer;   { of the ASCII box on the Screen       }

{======================================================================}
PROCEDURE SetChooseASCII(X,Y:Integer);       { Set location of ASCII box }
BEGIN
  If X < 1 then X := 1;                      { make sure X,Y in bounds }
  If Y < 1 then Y := 1;
  If X < 63 then XPos := X else XPos := 62;
  If Y < 8 then YPos := Y else YPos := 7;
END;
{======================================================================}
FUNCTION ChooseASCII:Char;

CONST

      UpArrow    = #72; { keys used to move the selector box }
      LeftArrow  = #75;
      RightArrow = #77;
      DownArrow  = #80;
      PageUp     = #73;
      PageDown   = #81;
      HomeKey    = #71;
      EndKey     = #79;
      EnterKey   = #13; { Enter selects a character }
      EscKey     = #27; { Escape aborts by returning #0       }

      ColorF1    = LightGray;    { Foreground color - ASCII characters }
      ColorB1    = Black;        { Background color - ASCII characters }
      ColorF2    = Magenta;      { Foreground color - Border           }
      ColorB2    = Black;        { Background color - Border           }
      ColorF3    = Yellow;       { Foreground color - Selector Box     }
      ColorB3    = Black;        { Background color - Selector Box     }

VAR
      CCh        : Char;         { used to read in cursor pad keys }
      ASCIIExit  : Boolean;      { set to true when ready to exit }
      FunctKey   : Boolean;      { set to true when a function key read in }
      R,C,LR,LC  : Integer;      { row, column position of selector box }
      SaveAttr   : Byte;
{===================================================}
PROCEDURE ShowASCII;

{ This procedure displays 64 ASCII characters on the screen    }
{ depending on the current setting of TopLeft.  TopLeft is the }
{ number of the current character in the top left position.    }

VAR
   II,XI,YI : Integer;

BEGIN
  SetColor(ColorF1,ColorB1);
  For II := 1 to 64 do Begin
     XI:=((II-1) mod 8)*2+XPos+2;     { Column on screen }
     YI:=((II+7) div 8)*2+YPos;       { Row on screen    }
     WriteCh(Chr(TopLeft+II-1),XI,YI);
  End;
 END;
{===================================================}
BEGIN

       { Miscellaneous initialization.  Note that ChNow is only     }
       { initialized at startup so that the last character selected }
       { may be remembered }

   SaveAttr := TextAttr;
   ASCIIExit := False;
   Hidecursor;

   SetColor(ColorF1,ColorB1);
   Window(XPos,YPos,XPos+18,YPos+18);
   ClrScr;
   Window(1,1,80,25);
   SetColor(ColorF2,ColorB2);
   Border(XPos,YPos,XPos+18,YPos+18,'ASCII Table');

   ShowASCII;
   LC := ChNow Mod 8 + 1;
   LR := (ChNow-Topleft)div 8 + 1;

        { start of big cursor pad reading loop }
  Repeat
         C := ChNow Mod 8 + 1;                { figure the current column }
         R := (ChNow-Topleft)div 8 + 1;       { and row to put the box.   }
         SetColor(ColorF3,ColorB3);
         WriteSt('   ',XPos-1+LC*2,LR*2+YPos-1); { erase the last box }
         WriteCh(' '  ,XPos+1+LC*2,LR*2+YPos);
         WriteCh(' '  ,XPos-1+LC*2,LR*2+YPos);
         WriteSt('   ',XPos-1+LC*2,LR*2+YPos+1);
         WriteSt('Ŀ',XPos-1+C*2,R*2+YPos-1);   { write a box around the }
         WriteCh(''  ,XPos+1+C*2,R*2+YPos);     { current selected char. }
         WriteCh(''  ,XPos-1+C*2,R*2+YPos);
         WriteSt('',XPos-1+C*2,R*2+YPos+1);

         SetColor(ColorF1,ColorB1);
         LC := C; LR := R;            { remember the last box location }

               { read a keystroke }
        CCh := ReadKey;
         If CCh <> #0 then FunctKey := False else
         Begin
          CCh := ReadKey;
          FunctKey := True;
         End;
               { handle non function keys }
        If not FunctKey then Case CCh of
          EnterKey : ASCIIExit := True;      { prepare to exit }
          EscKey   : Begin                   { abort }
                      ChooseASCII := #0;     { #0 returned if escape hit }
                      TextAttr := SaveAttr;
                      Exit;
                     End;
          Else Beep;
        End; {case CCh}

              { handle function keys }
       If FunctKey then Case CCh of
  DownArrow : Begin
               If ChNow+8 < 255 then ChNow := ChNow+8
               else Beep;
               If ChNow > TopLeft+63 then Begin
                 TopLeft := TopLeft+8;
                 ShowASCII;
               End;
              End;

    UpArrow : Begin
               If ChNow-8 >= 0 then ChNow := ChNow-8
               else Beep;
               If ChNow < TopLeft then Begin
                 TopLeft := TopLeft-8;
                 ShowASCII;
               End;
              End;

 RightArrow : Begin
               If ChNow < 255 then ChNow := Succ(ChNow) else Beep;
               If ChNow > TopLeft+63 then Begin
                 TopLeft := TopLeft+8;
                 ShowASCII;
               End;
              End;

  LeftArrow : Begin
               If ChNow > 0 then ChNow := Pred(ChNow) else Beep;
               If ChNow < TopLeft then Begin
                 TopLeft := TopLeft-8;
                 ShowASCII;
               End;
              End;

     PageUp : Begin
               If TopLeft = 0 then Beep;
               If TopLeft >= 64 then Begin
                 TopLeft := TopLeft-64;
                 ChNow := ChNow-64;
                 ShowASCII;
               End
               else Begin
                 ChNow := ChNow-TopLeft;
                 TopLeft := 0;
                 ShowASCII;
               End;
              End;

   PageDown : Begin
               If TopLeft = 192 then Beep;
               If TopLeft <= 128 then Begin
                 TopLeft := TopLeft+64;
                 ChNow := ChNow + 64;
                 ShowASCII;
               End
               else Begin
                 ChNow := ChNow + 192-TopLeft;
                 TopLeft := 192;
                 ShowASCII;
               End;
              End;

    HomeKey : Begin
                TopLeft := 0;
                ChNow := 0;
                ShowASCII;
              End;

    EndKey  : Begin
                TopLeft := 192;
                ChNow := 255;
                ShowASCII;
              End;

         Else Beep;
         End; {case CCh}
  Until ASCIIExit;          { bottom of keystroke loop }

  ChooseASCII := Chr(ChNow);  { return the chosen character }

  ShowCursor;
  TextAttr := SaveAttr;
END;

{INITIALIZATION}
BEGIN
   TopLeft := 0;
   ChNow   := 0;
   XPos    := 20;
   YPos    := 5;
END.  {UNIT}