UNIT DIR;
INTERFACE
 USES IOSTUFF,GETLINE,DOS,CRT;
 PROCEDURE ShowDir;             {Shows the path and file directory}
 PROCEDURE ChangePath;          {Lets user change path. Used with PickFile}
 FUNCTION  PickFile:AnyStr;     {Pick a file with point and shoot bar cursor}

IMPLEMENTATION

CONST
   MaxNoFiles = 120;             {Max files that can be displayed }

   Color1F    = Magenta;         { Foreground color - Border }
   Color1B    = Black;           { Background color - Border }
   Color2F    = Cyan;            { Foreground color - Files }
   Color2B    = Black;           { Background color - Files }
   Color3F    = Black;           { Foreground color - Bar cursor }
   Color3B    = LightGray;       { Background color - Bar cursor }

TYPE
   FileName = String [12];

VAR
   DirFile  : Array[1..MaxNoFiles] of FileName;  {File names stored here}
   NoFiles  : Integer;   {Number of files in directory}
   PathNm   : AnyStr;    {Current path name e.g. c:\tp4}

{================================================================}
PROCEDURE WriteFile(FN:Integer);
{                                                                }
{ Utility routine to write a file name at the proper row,column. }
{                                                                }
VAR
   R,C  : Integer;
BEGIN
   R := (FN + 5) div 6 + 3;
   C := ((FN - 1) mod 6) * 13 + 3;
   WriteSt(DirFile[FN],C,R);
END;

{======================================================================}
PROCEDURE ShowDir;
{                                                                }
{ This procedure displays a directory of the current drive.      }
{                                                                }
VAR
  Regs                 : Registers;
  DirInfo              : SearchRec;
  SaveAttr             : Byte;
LABEL  GetOut;
BEGIN
  SaveAttr := TextAttr;
  SetColor(Color1F,Color1B);         { Set Border Colors }
  ClrScr;                            { Clear the display window }
  Border(1,3,80,24,'');              { Draw Border }
  SetColor(Color2F,Color2B);         { Set File Display Colors }
  GetDir(0,Pathnm);                  { Get the current path }
  GoToXY(2,2);Write(' Path: ',Pathnm);    { Write it }
  FindFirst('*.*',Archive,DirInfo);  { Get the first file name }
  NoFiles := 1;
  While DosError = 0 do
  Begin
    DirFile[NoFiles] := DirInfo.Name;   { Get the rest of the file names}
    WriteFile(NoFiles);                 { Store em and write em out }
    FindNext(DirInfo);
    NoFiles := NoFiles+1;
    If NoFiles = MaxNoFiles+1 then GoTo GetOut; { Don't increment past array }
  End;
GetOut:
  NoFiles := NoFiles-1;
  TextAttr := SaveAttr;
END;

{======================================================================}
PROCEDURE ChangePath;
{                                                                }
{ This procedure lets the user enter a new path name then        }
{ displays a directory of that path.  Used by Pickfile.          }
{ Can be called directly from a program but it must be proceded  }
{ by a call to SHOWDIR to display the files in the current path. }

VAR
      TempPathnm : AnyStr;
      NoError    : Boolean;
      Dummy      : Char;
      SaveAttr   : Byte;
BEGIN
   SaveAttr := TextAttr;
   SetColor(Color2F,Color2B);
   Repeat                   { Repeat until we get a good path }
      NoError := True;
      TempPathnm := GetStr(9,2,40,Pathnm);  { User enters the new Path }
      If (TempPathnm <> '') and (TempPathnm <> Pathnm) then
       Begin
            Pathnm := TempPathnm;
           {$I-}ChDir(Pathnm){$I+};        { Try to change directories }
           If IOresult <> 0 Then Begin     { Whoops. Bad Path }
              WriteSt('Path Error.  Hit any key to continue',1,25);
              Dummy := ReadKey;
              GoToXY(1,25);Clreol;
              NoError := False;
            End;
       End;
  Until NoError;
  GetDir(0,Pathnm);                        { Got a good Path }
  WriteSt(' Path: '+Pathnm,2,2);           { Write it out }
  ShowDir;                                 { display the files }
  TextAttr := SaveAttr;
  END;

{======================================================================}
FUNCTION PickFile:AnyStr;
{                                                                }
{ This Function allows you to pick a file from the current       }
{ directory using a point and shoot (lotus 123) bar cursor.      }
{ You can also change the path or logged drive in the function.  }
{ If you hit the Esc. key a nul file name ('') is returned.      }
{ Only the first 120 files in the directory are displayed.       }
{ The function could handle more files if the array were         }
{ increased and scrolling logic were added.  This would be lots  }
{ more code for not much more utility.                           }
{                                                                }
CONST
   LeftArrow  = #75;      { Keys recognized }
   RightArrow = #77;
   UpArrow    = #72;
   DownArrow  = #80;
   HomeKey    = #71;      { Jumps to first file }
   EndKey     = #79;      { Jumps to last file }
   EnterKey   = #13;      { Selects file under cursor }
   EscKey     = #27;      { Aborts with nul file name }
   F2         = #60;      { Allows user to change path }

VAR
   ExitPickFile : Boolean;    { Exit switch }
   FunctKey     : Boolean;    { true if key is a function key }
   PCh          : Char;       { Key read in }
   FN,LFN       : Integer;    { Current File number, Last File Number }
   SaveAttr     : Byte;
BEGIN
   SaveAttr := TextAttr;
   ExitPickFile := False;
   SetColor(Color1F,Color1B);
   ClrScr;
   ShowDir;                   { Display the file names }

   SetColor(Color2F,Color2B);
   WriteSt('Hit enter to select, Esc to abort',1,25);
   WriteSt('F2 to change path',63,2);
   FN := 1;                   { Set the current file number }
   LFN := 1;
   HideCursor;
                              { Big keystroke loop until enter or esc. }
Repeat
   SetColor(Color2F,Color2B);
   WriteFile(LFN);            { Repair the last reverse video file name }
   SetColor(Color3F,Color3B);
   WriteFile(FN);             { Write the new file name in reverse video }
   SetColor(Color2F,Color2B);
   LFN := FN;                 { Set Last file number to current file number }
                     { Read a keystroke }
   PCh := Readkey;
   If PCh <> #0 then FunctKey := False else
   Begin
     FunctKey := True;
     PCh := ReadKey;
   End;
                     { Handle function keys }
   If FunctKey then Case PCh of

   UpArrow    : If FN > 6 then FN := FN-6 else Beep;
   DownArrow  : If FN+6 <= NoFiles then FN := FN+6 else Beep;
   RightArrow : If FN < NoFiles then FN := FN+1 else Beep;
   LeftArrow  : If FN > 1 then FN := FN-1 else Beep;
   HomeKey    : FN := 1;
   EndKey     : FN := NoFiles;
   F2         : Begin
                  ChangePath;           { Change Path }
                  HideCursor;           { Repair and reset }
                  SetColor(Color2F,Color2B);
                  WriteSt('F2 to change path',63,2);
                  WriteSt('Hit enter to select, Esc to abort',1,25);
                  FN := 1;              { Go back to first file }
                End;
   End; {function keys}
                     { Handle non function keys }
   If not FunctKey then Case PCh of

   EnterKey : ExitPickFile := true;    { normal exit }
   EscKey   : Begin                    { abort exit  }
               PickFile := '';
               TextAttr := SaveAttr;
               Exit;
              End;
   End; {non function keys}

Until ExitPickFile;

 PickFile := DirFile[FN];           { Set the function to the selected file }
 TextAttr := SaveAttr;
End;

END.