
(*
 * Copyright 1987, 1989 Samuel H. Smith;  All rights reserved
 *
 * This is a component of the ProDoor System.
 * Do not distribute modified versions without my permission.
 * Do not remove or alter this notice or any other copyright notice.
 * If you use this in your own program you must distribute source code.
 * Do not use any of this in a commercial product.
 *
 *)

(*
 * Top level unit for the Tool Shop Tools Library
 *
 *)

{$i prodef.inc}
{$d+,l+}

unit Tools;

interface

   uses Dos, MDosIO, debugs;

   {$I M:\tinc\anystring.inc}  (* general string declaration *)
   {$I M:\tinc\givetime.int}   (* give up time under doubledos *)
   {$I M:\tinc\ftoa.int}       (* float to ascii conversion *)
   {$I M:\tinc\atof.int}       (* ascii to float conversion *)
   {$I M:\tinc\atoi.int}       (* ascii to integer conversion *)
   {$I M:\tinc\itoa1.int}      (* integer to ascii conversion *)
   {$I M:\tinc\stof.int}       (* basic single to floating conversion *)
   {$I M:\tinc\dtof.int}       (* basic double to floating conversion *)
   {$I M:\tinc\stoa.int}       (* single to ascii conversion *)
   {$I M:\tinc\itoh.int}       (* integer to hex conversion *)
   {$I M:\tinc\itou.int}       (* integer to unsigned-real conversion *)
   {$I M:\tinc\ltor.int}       (* long-integer to real conversion *)
   {$I M:\tinc\rempath.int}    (* remove/manipulate filename paths *)
   {$I M:\tinc\iswild.int}     (* is a filename a wildcard? *)
   {$I M:\tinc\stoupper.int}   (* map string to upper case *)
   {$I M:\tinc\stolower.int}   (* map string to lower case *)
   {$I M:\tinc\capstr.int}     (* make string into 'Caps Format' *)
   {$I M:\tinc\filesize.int}   (* get size of a file *)
   {$I M:\tinc\pattern.int}    (* wildcard filename pattern comparison *)
   {$I M:\tinc\sysdate2.int}   (* get system time string formats, mm-dd-yy & hh:mm *)
   {$I M:\tinc\gettime.int}    (* get system time in seconds *)
   {$I M:\tinc\delay.int}      (* delay function based on give-up-time and gettime *)
   {$I M:\tinc\delspace.int}   (* delete all spaces from a string *)
   {$I M:\tinc\replstr.int}    (* perform string replacements *)
   {$I M:\tinc\getenv.int}     (* get environment variables *)
   {$I M:\tinc\varstr.int}     (* variable allocation string library *)
   {$I M:\tinc\getfile3.int}   (* expand wildcard file lists *)
   {$I M:\tinc\ljust.int}      (* left justify strings *)
   {$I M:\tinc\bitmap.int}     (* manipulate bit maps *)
   {$I M:\tinc\flags.int}      (* manipulate bit flags *)
   {$I M:\tinc\appendc.int}    (* append character to string *)
   {$I M:\tinc\diskspac.int}   (* get disk free space; allows >32meg *)
   {$I M:\tinc\qwrite.int}     (* quick screen write *)
   {$I M:\tinc\bakfile.int}    (* rename file to .BAK *)
   {$I M:\tinc\bline.int}      (* fast string compares *)
   {$I M:\tinc\cpos.int}       (* character position in string *)
   {$I M:\tinc\jday.int}       (* convert m/d/y to julian date *)


implementation
   uses OpenShare;

   {$I M:\tinc\givetime.inc}   (* give up time under doubledos *)
   {$I M:\tinc\ftoa.inc}       (* float to ascii conversion *)
   {$I M:\tinc\atof.inc}       (* ascii to float conversion *)
   {$I M:\tinc\atoi.inc}       (* ascii to integer conversion *)
   {$I M:\tinc\itoa1.inc}      (* integer to ascii conversion *)
   {$I M:\tinc\stof.inc}       (* basic single to floating conversion *)
   {$I M:\tinc\stoa.inc}       (* single to ascii conversion *)
   {$I M:\tinc\dtof.inc}       (* basic double to floating conversion *)
   {$I M:\tinc\itoh.inc}       (* integer to hex conversion *)
   {$I M:\tinc\itou.inc}       (* integer to unsigned-real conversion *)
   {$I M:\tinc\ltor.inc}       (* long-integer to real conversion *)
   {$I M:\tinc\rempath.inc}    (* remove/manipulate filename paths *)
   {$I M:\tinc\iswild.inc}     (* is a filename a wildcard? *)
   {$I M:\tinc\stoupper.inc}   (* map string to upper case *)
   {$I M:\tinc\stolower.inc}   (* map string to lower case *)
   {$I M:\tinc\capstr.inc}     (* make string into 'Caps Format' *)
   {$I M:\tinc\filesize.inc}   (* get size of a file *)
   {$I M:\tinc\pattern.inc}    (* wildcard filename pattern comparison *)
   {$I M:\tinc\getfile3.inc}   (* expand wildcard file lists *)
   {$I M:\tinc\sysdate2.inc}   (* get system time string formats, mm-dd-yy & hh:mm *)
   {$I M:\tinc\gettime.inc}    (* get system time in seconds *)
   {$I M:\tinc\delay.inc}      (* delay function based on give-up-time and gettime *)
   {$I M:\tinc\delspace.inc}   (* delete all spaces from a string *)
   {$I M:\tinc\replstr.inc}    (* perform string replacements *)
   {$I M:\tinc\getenv.inc}     (* get environment variables *)
   {$I M:\tinc\varstr.inc}     (* variable allocation string library *)
   {$I M:\tinc\ljust.inc}      (* left justify strings *)
   {$I M:\tinc\bitmap.inc}     (* manipulate bit maps *)
   {$I M:\tinc\flags.inc}      (* manipulate bit flags *)
   {$I M:\tinc\appendc.inc}    (* append character to string *)
   {$I M:\tinc\diskspac.inc}   (* get disk free space; allows >32meg *)
   {$I M:\tinc\qwrite.inc}     (* quick screen write *)
   {$I M:\tinc\bakfile.inc}    (* rename file to .BAK *)
   {$I M:\tinc\bline.inc}      (* fast string compares *)
   {$I M:\tinc\cpos.inc}       (* character position in string *)
   {$I M:\tinc\jday.inc}       (* convert m/d/y to julian date *)

begin
   fillchar(filetable,sizeof(filetable),0);
end.

