{************************************************}
{                                                }
{   ToolDemo.pas                                 }
{                                                }
{************************************************}

program ToolDemo;

{$R TOOLDEMO.RES}

uses WObjects, WinTypes, WinProcs, Strings, ToolBox;

const
  cm_Test = 1010;

type

  { Define a TApplication descendant }
  TToolDemoApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PToolChild = ^TToolChild;
  TToolChild = object(TToolBox)
     constructor Init(AParent : PWindowsObject; ATitle : PChar);
     procedure TBButtonHit(var Msg : TMessage); virtual wm_First + tb_buttonhit;
  end;

  PToolParent = ^TToolParent;
  TToolParent = object(TWindow)
    ToolChild : PToolChild;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure SetupWindow; virtual;
  end;

  PMainMDIWindow = ^TMainMDIWindow;
  TMainMDIWindow = object(TMDIWindow)
    ToolParent : PToolParent;
    constructor Init(ATitle: PChar;  AMenu: HMenu);
    procedure   CMTest(var Msg:tMessage); virtual cm_First+cm_Test;
    function    CreateChild: PWindowsObject; virtual;
  end;

constructor TToolChild.Init(AParent: PWindowsObject; ATitle: PChar);
begin
   ToolCollection := New(PCollection,Init(8,0));
   with ToolCollection^ do
   begin
      Insert(New(PToolButton,Init('ToolBut_1_Up','ToolBut_1_Down')));
      Insert(New(PToolButton,Init('ToolBut_2_Up','ToolBut_2_Down')));
      Insert(New(PToolButton,Init('ToolBut_3_Up','ToolBut_3_Down')));
      Insert(New(PToolButton,Init('ToolBut_4_Up','ToolBut_4_Down')));
      Insert(New(PToolButton,Init('ToolBut_5_Up','ToolBut_5_Down')));
      Insert(New(PToolButton,Init('ToolBut_6_Up','ToolBut_6_Down')));
      Insert(New(PToolButton,Init('ToolBut_7_Up','ToolBut_7_Down')));
      Insert(New(PToolButton,Init('ToolBut_8_Up','ToolBut_8_Down')));
   end;
   TToolBox.Init(AParent,ATitle,4,2,0,5,5);
end;

procedure TToolChild.TBButtonHit(var Msg : TMessage);
begin
   MessageBeep(0);
end;

constructor TToolParent.Init(AParent : PWindowsObject; ATitle : PChar);
begin
  TWindow.Init(AParent, ATitle);
  with Attr do
  begin
    W := 200;
    H := 200;
  end;
end;

procedure TToolParent.SetupWindow;
begin
  TWindow.SetupWindow;
  ToolChild := PToolChild(Application^.MakeWindow(new(PToolChild, Init(@Self, 'Tools'))));
  SendMessage(ToolChild^.HWindow,WM_NCActivate,1,0);
end;

constructor TMainMDIWindow.Init(ATitle: PChar;  AMenu: HMenu);
begin
  TMDIWindow.Init(ATitle, AMenu);
end;

function TMainMDIWindow.CreateChild: PWindowsObject;
begin
   ToolParent := PToolParent(Application^.MakeWindow(new(PToolParent, Init(@Self, 'ToolBox Parent'))));
end;

procedure TMainMDIWindow.CMTest(var Msg:tMessage);
begin
   CreateChild;
end;

procedure TToolDemoApp.InitMainWindow;
begin
  MainWindow := New(PMainMDIWindow, Init('ToolDemo',LoadMenu(HInstance, 'ToolMenu_1')));
end;

{ Declare a variable of type TToolDemo}
var
  ToolDemoApp: TToolDemoApp;

{ Run the ToolDemoApp }
begin
  ToolDemoApp.Init('ToolDemoApp');
  ToolDemoApp.Run;
  ToolDemoApp.Done;
end.
