{**************************************************************************}
{*                    SoftWeyr LAN library. Version 1.3                   *}
{*                                RELOG.PAS                               *}
{*                    Demo program for SoftWeyr LANLIB                    *}
{*                   for Turbo Pascal (tm) 6.0 or higher                  *}
{*                     Copyright (c) by SoftWeyr,1994                     *}
{**************************************************************************}
Uses Dos,NetCall,Objects;
Type TDevice=record
               LocalName:String[4];
               CurDir:DirStr;
               NetName:PathStr;
               Kind:Byte;
             end;
var DevList:Array[1..16] of TDevice;
    Machine,Server,User,Name,Path,s,StartDir:String;
    Typ,i,n:Integer;
    Valid:Boolean;
    UserInf:TUserEntry;
Procedure Help;
begin
 Writeln(^M'This program allows you to log in to server, where you are '^M^J+
         'already logged, under another user name, and keep all redirections'^M^J^M^J+
         'Usage:'^J'Relog \\server username password'^M^J);
 Halt;
end;
Procedure Login;
begin
 NetLogin(Server,User,PAramStr(3));
 if DosError<>0 then Writeln(GetError(DosError));
end;
Function XServer(NetPath:STring):String;
{Extracts server name from network path}
var i:Integer;
begin
 i:=3;
 While NetPath[i]<>'\' do
  inc(i);
 XServer:=Copy(NetPath,1,i-1);
end;
begin
 if ParamCount<2 then Help;
 Server:=ParamStr(1);
 For i:=3 to length(Server) do Server[i]:=Upcase(Server[i]);
 {Check: are we already logged}
 i:=0;
 Repeat
   GetLogins(i,S)
 Until (DosError<>0)or (S<>Copy(Server,3,1));
 if DosError<>0 then
  begin
   i:=0;
   Repeat
     GetServer(i,S)
   Until (DosError<>0)or (S<>Copy(Server,3,1));
   if DosError<>0 then
    begin
     Writeln('Server not found '+Server);
     Halt(1);
    end
   else

    Login;
  end
 else
  begin
   {Check user name we are logged under}
   User:=ParamStr(2);
   For i:=1 to length(User) do User[i]:=Upcase(User[i]);
   i:=0;
   Machine:=GetMachineName;
   Repeat
    GetUserInfo(i,Server,UserInf);
    While Userinf.Machine[Length(UserInf.MAchine)]=' ' do
    dec(UserInf.Machine[0]);
   Until UserInf.Machine=Machine;
   if UserInf.Name=User then
    begin
     Writeln('You are already logged on ',Server,' under name ',User);
     Halt;
    end;
   {Make a resource list}
   i:=0;n:=0;
   GetDir(0,StartDir);
   Repeat
    GetDevice(i,Name,Path,typ,Valid);
    inc(i);
    if (DosError=0)and(XServer(Path)=Server) then
     begin
      inc(N);
      With DevList[n] do
       begin
         LocalName:=Name;
         NetName:=Path;
         Kind:=Typ;
         if Typ=dtDisk then
          begin
           GetDir(Ord(Name[1])-Ord('@'),CurDir);
           {If current drive is network, change it}
           if CurDir=StartDir then
            ChDir('C:\');
          end;
       end;
     end;
   Until DosError<>0;
   NetLogOut(Server);
   Login;
   if N<>0 then
   begin
    Writeln('           Opening devices');
    Writeln('Name Network path        Type   Current directory ');
    Writeln('------------------------------------------------');
   end;
   For i:=1 to N do
   With DevList[i] do
    begin
     NetUse(LocalName,NetName,Kind);
     Write(LocalName,'':6-Length(LocalName),NetName);
     if Kind=dtDisk then
       begin
         ChDir(CurDir);
         Writeln('Disk   ':27 -Length(NetName),CurDir);
       end
      else
       Writeln('Printer':27-Length(NetName));
    end;
   ChDir(StartDir);
  end;
end.





