{****************************************************************************}
{*                    SoftWeyr LAN library. Version 1.3                     *}
{*                                NETBIOS.PAS                               *}
{*                       NetBios procedural interface                       *}
{*                      for Turbo Pascal 4.0 or higher                      *}
{*                      Copyright (c) by SoftWeyr,1994                      *}
{****************************************************************************}
Unit NetBios;
Interface
const
          {NetBIOS return codes }
          nbSuccess=0;
          nbBadBuffer=1;{Datagramm is longer then 512 bytes}
          nbBadCommand=3;{Invalid command code}
          nbTimeOut=5;
          nbMessageNotComplete=6;{Data cannot fit in specified buffer}
          nbInvalidSeance=8;
          nbResoureNotAvail=9;
          nbSeanceClosed = 10;
          nbCommandCancelled=11;
          nbDuplicatedName=13;
          nbTooManyNames=14;
          nbNameHasSeance=15;{Attempt to delete name, which is in use}
          nbTooManySeances=17;
          nbCannotOpenSeance=18;{Call command issued for name, which is not
                                 listening}
          nbInvalidNameNumber = 19;
          nbNameNotListening=20;{Name not found or no answer}
          nbInvalidName=21;{This command does not allow #0 or'*' in first
                            position of name}
          nbNameDeleted=23;
          nbSeanceAborted=24;
          nbNameConflict=25;
          nbIncompatibleRemote=26;
          nbInterfaceBusy=33;
          nbQueueFull=34;
          nbInvalidAdapterNum=35;
          nbCommandAlredyComplete=36;
          nbCannotCancel=38;
{Codes from $40 to $4F (64-79) - unusial conditions in network}
{Codes larger then 80 ($50) - hardware fault}

Type NETNameBuf=array[0..15] of char;
{NetWork Control Block - as basic term for NetBios as file for disk I/O}
 {Adapter and Post usially must be filled by 0 and  nil}
 {even Post can contain address of command completion handler, which
  must be declared as Interrupt and recieve in AL NetBIOS return code
 (see above) and  ES:BX address of NCB }
         NCB = Record
                        Command:Byte;{NetBIOS  Command}
                        RetCode:Byte;
                        LSN:Byte;{Local Seance Name?}
                        Num:Byte;{Name number}
                        Buffer:Pointer;{Data buffer pointer}
                        Length:Word;{Buffer length}
                        Case integer of
                        0:(
                        CallName:NetNameBuf;{Name to call }
                        Name:NetNameBuf;
                        RTO:Byte;{Recieve timeout}
                        STO:Byte;{Send time out}
                        Post:Pointer;{Completion handler}
                        Adapter:Byte;
                        CmdComplete:Byte;
                        Reserved:Array[1..14] of byte);
                        1:(
                        Length2:Word;{Length of secondary buffer }
                        Buf2:Pointer{Pointer to secondary buffer}
                        )
                        end;
        NetNameStr=String[16];
var NetError:Integer;
{********************** Check if NETBIOS installed ********************}
Function isNetBios:Boolean;
{******************* Low level *********************************}
function CallNetBios(var N:NCB):Byte;
inline($5B        {POP BX}
          /$07        {POP ES}
          /$B0/$00    {MOV AL,0}
          /$CD/$5C    {INT 5CH});
{---  TurboPascal string to NetBIOS name  ----}
Procedure SetName(var NameBuf:NetNameBuf;Name:NetNameStr);

{--- Check if command complete}
function CheckComplete(var N:NCB):boolean;
{******************* NetBIOS commands *******************************}
{---- Cancel no-wait command for given NCB ----}

Procedure Cancel(var N:NCB);

{ ================ Name supporg ================================}
{------ add name to local name table ----}

Procedure AddName(var N:NCB;Name:NetNameStr);

function AddNameWait(Name:NetNameStr):Byte;
{----- add group name -----}

Procedure AddGroupName(var N:NCB;Name:NetNameStr);

Function AddGroupNameWait(Name:NetNameStr):Byte;

{------ return name code, for name added in no-wait mode -----}

Function GetNameCode(N:NCB):Byte;

{-------- Deleting name --------}

Procedure DeleteName(var N:NCB;Name:NetNameStr);

Procedure DeleteNameWait(Name:NetNameStr);

Procedure DeleteNCBName(var N:NCB;wait:Boolean);

{================== Establish/terminate seance ===============}

Procedure StartSeance(var N:NCB;Parthner:NetNameStr;RTO,STO:Byte;
                                           Call:Boolean;Wait:Boolean);

Procedure CopyNCB(var Src,Dest:NCB);

Procedure EndSeance(var N:NCB);

Procedure EndSeanceWait(var N:NCB);
{==================== Data transfer ========================}

Procedure Send(var N:NCB;Var Buffer;BufSize:Integer);
Procedure SendWait(var N:NCB;var Buffer;BufSize:Integer);
Procedure ChainSend(var N:NCB;Var Buf1,Buf2;Size1,Size2:Integer);
Procedure Recieve(var N:NCB;var Buffer;BufSize:Integer);
Function RecieveWait(var N:NCB;var Buffer;BufSize:Integer):Integer;

{==================== Datagrams ===============================}
Procedure SendDatagram(var N:NCB;var Buffer;BufSize:integer;Adresat:NetNameStr);
Procedure RecieveDatagram(var N:NCB;Var Buffer;BufSize:Integer);

implementation
Procedure Cancel(var N:NCB);
var Own:NCB;
begin
 Own.Buffer:=@N;
 Own.Post:=nil;
 Own.Command:=$35;
 NetError:=CallNetBios(Own);
end;
Procedure SetName(var NameBuf:NetNameBuf;Name:NetNameStr);
begin
 Move(Name[1],NameBuf[0],Length(Name));
 FillChar(NameBuf[Length(Name)],16-Length(Name),' ');
end;
function CheckComplete(var N:NCB):Boolean;
begin
 CheckComplete:=N.CmdComplete<>$FF;
end;
Procedure AddName(var N:NCB;Name:NetNameStr);
begin
 SetName(N.Name,Name);
 N.Command:=$B0;
 NetError:=CallNetBios(N);
end;
function AddNameWait(Name:NetNameStr):Byte;
var N:NCB;
begin
 N.Post:=nil;
 SetName(N.Name,Name);
 N.Command:=$30;
 NetError:=CallNetBios(N);
 if N.RetCode=0 then AddNameWait:=N.Num else
  begin
   AddNameWait:=0;
   NetError:=N.RetCode;
  end;
end;
Procedure AddGroupName(var N:NCB;Name:NetNameStr);
begin
 SetName(N.Name,Name);
 N.Command:=$B6;
 NetError:=CallNetBios(N);
end;
Function AddGroupNameWait(Name:NetNameStr):Byte;
var N:NCB;
begin
 N.Post:=nil;
 SetName(N.Name,Name);
 N.Command:=$36;
 NetError:=CallNetBios(N);
 if N.RetCode=0 then AddGroupNameWait:=N.Num else
  begin
   AddGroupNameWait:=0;
   NetError:=N.RetCode;
  end;
end;
Function GetNameCode(N:NCB):Byte;
begin
 if (N.CmdComplete<>$FF)and(N.RetCode=0) then
   GetNameCode:=N.Num;
 NetError:=N.RetCode;
end;
Procedure DeleteName(var N:NCB;Name:NetNameStr);
begin
 SetName(N.Name,Name);
 N.Command:=$B1;
 NetError:=CallNetBios(N);
end;
Procedure DeleteNameWait(Name:NetNameStr);
var N:NCB;
begin
 N.Post:=nil;
 N.Command:=$31;
 NetError:=CallNetBios(N);
 NetError:=N.RetCode;
end;
Procedure DeleteNCBName(var N:NCB;wait:Boolean);
begin
 N.Command:=$31;
 if not wait then N.Command:=N.Command or $80;
 NetError:=CallNetBios(N);
end;
Procedure StartSeance(var N:NCB;Parthner:NetNameStr;RTO,STO:Byte;
                                           Call:Boolean;Wait:Boolean);
begin
  SetName(N.CallName,Parthner);
  N.RTO:=RTO;
  N.STO:=STO;
  N.Command:=$11;
  if Call then Dec(N.Command);
  if Not wait then N.Command:=N.Command or $80;
  NetError:=CallNetBios(N);
end;
Procedure CopyNCB(var Src,Dest:NCB);
begin
 Dest.Name:=Src.Name;
 Dest.Num:=Src.Num;
 Dest.LSN:=Src.Lsn;
 Dest.Post:=Src.Post;
 Dest.RTO:=Src.RTO;
 Dest.STO:=Src.Sto;
 Dest.CMDComplete:=0;
 Dest.RetCode:=0;
 Dest.Adapter:=Src.Adapter;
end;
Procedure EndSeance(var N:NCB);
begin
 if n.CmdComplete=$FF then begin NetError:=$FF;exit end;
 N.Command:=$92;
 NetError:=CallNetBios(N);
end;
Procedure EndSeanceWait(var N:NCB);
begin
 if n.CmdComplete=$FF then begin NetError:=$FF;exit end;
 N.Command:=$12;
 NetError:=CallNetBios(N);
 NetError:=N.RetCode;
end;
Procedure Send(var N:NCB;Var Buffer;BufSize:Integer);
begin
 if n.CmdComplete=$FF then begin NetError:=$FF;exit end;
 N.Command:=$94;
 N.Buffer:=@Buffer;
 N.Length:=BufSize;
 NetError:=CallNetBios(N);
end;
Procedure SendWait(var N:NCB;var Buffer;BufSize:Integer);
begin
 if n.CmdComplete=$FF then begin NetError:=$FF;exit end;
 N.Command:=$14;
 N.Buffer:=@Buffer;
 N.Length:=BufSize;
 NetError:=CallNetBios(N);
 NetError:=N.RetCode;
end;
Procedure ChainSend(var N:NCB;Var Buf1,Buf2;Size1,Size2:Integer);
begin
 if n.CmdComplete=$FF then begin NetError:=$FF;exit end;
 N.Command:=$97;
 N.Buffer:=@Buf1;
 N.Length:=Size1;
 N.Length2:=Size2;
 N.Buf2:=@Buf2;
 NetError:=CallNetBios(N);
end;

Procedure Recieve(var N:NCB;var Buffer;BufSize:Integer);
begin
 if n.CmdComplete=$FF then begin NetError:=$FF;exit end;
 N.Command:=$95;
 N.Buffer:=@Buffer;
 N.Length:=BufSize;
 NetError:=CallNetBios(N);
end;
Function RecieveWait(var N:NCB;var Buffer;BufSize:Integer):Integer;
begin
 if n.CmdComplete=$FF then begin NetError:=$FF;exit end;
 N.Command:=$15;
 N.Buffer:=@Buffer;
 N.Length:=BufSize;
 NetError:=CallNetBios(N);
 NetError:=N.RetCode;
 if NetError<>0 then RecieveWait:=0 else RecieveWait:=N.Length;
end;
Procedure SendDatagram(var N:NCB;var Buffer;BufSize:integer;Adresat:NetNameStr);
begin
 N.Command:=$A0;
 N.Buffer:=@Buffer;
 N.Length:=BufSize;
 SetName(N.CallName,Adresat);
 NetError:=CallNetBios(N);
end;
Procedure RecieveDatagram(var N:NCB;Var Buffer;BufSize:Integer);
begin
 N.Command:=$A1;
 N.Buffer:=@Buffer;
 N.Length:=BufSize;
 NetError:=CallNetBios(N);
end;
Function GetVector5C:Pointer;inline(
$B8/$5C/$35  {MOV AX,355CH}
/$CD/$21     {INT 21H}
/$8C/$C2     {MOV DX,ES}
/$89/$D8     {MOV AX,BX});
function isNetBios:Boolean;
var N:NCB;
begin
  if GetVector5C<>nil then
  begin
   FillChar(N,SizeOf(N),0);
   N.Command:=$7F;{Prepare NCB with incorrect command}
   isNetBios:=CallNetBios(N)<>0
  end else isNetBios:=false;
end;

end.

