{**************************************************************************}
{*                    SoftWeyr LAN library. Version 1.3                   *}
{*                                 LAN.PAS                                *}
{*                       Generic LAN interface unit                       *}
{*                   for Turbo Pascal (tm) 4.0 or higher                  *}
{*                     Copyright (c) by SoftWeyr,1994                     *}
{**************************************************************************}
unit LAN;
interface
uses DOS;
 {File access mode constants}
 {Rights}
const
 amReadOnly = 0;
 amWriteOnly = 1;
 amReadWrite = 2;
 {Deny}
 amExclusive = $10;
 amDenyAll = amExclusive;
 amDenyWrite = $20;
 amDenyRead = $30;
 amDenyNone = $40;
 {Inheritance}
 amPrivate = $80;
 {Combination of this constats may be assigned to FileMode variable in
  System unit before Resetting or Rewriting file
  You can combine one rigths+one deny and also can add amPrivate
  Constants can be combined by + or by logical or}
{ Access DOS network functions}
{Get network name of this computer}
Function GetMachineName:String;

{Lock part of file}
Function Lock (var F;Offset,Length:LongInt):Boolean;
{Lock part of file}
{F may have type of File, Text or be a Handle field of TDosStream}
Procedure UnLock(var F;Offset,Length:LongInt);
{Unlock part of file}
{F may have type of File, Text or be a Handle field of TDosStream}

{lock/unlock records of typed/untyped file}
Function LockRec(var F;StartRec,EndRec:LongInt):Boolean;
Procedure UnLockRec(var F;StartRec,EndRec:LongInt);


{Queue mode control}
Type TQueueMode=(qmCombined,qmSeparated);
Function GetQueueMode:TQueueMode;
Procedure SetQueueMode(Mode:TQueueMode);
Procedure FlushCurrentJob;


implementation
Function Lock (var F;Offset,Length:LongInt):boolean;external;
Procedure UnLock(var F;Offset,Length:LongInt);external;
{$L LOCK.OBJ}
Function GetMachineName:String;External;
{$L GETNAME.OBJ}
Function GetQueueMode:TQueueMode;external;
Procedure SetQueueMode(Mode:TQueueMode);external;
Procedure FlushCurrentJob;external;
{$L LANQUEUE.OBJ}

Function LockRec(var F;StartRec,EndRec:LongInt):Boolean;
begin
 LockRec:=Lock(F,FileRec(F).RecSize*StartRec,FileRec(F).RecSize*Succ(EndRec-StartRec));
end;
Procedure UnLockRec(var F;StartRec,EndRec:LongInt);
begin
 UnLock(F,FileRec(F).RecSize*StartRec,FileRec(F).RecSize*Succ(EndRec-StartRec));
end;


end.
