{**************************************************************************}
{*                    SoftWeyr LAN library. Version 1.3                   *}
{*                                CHAT.PAS                                *}
{*                    Demo program for SoftWeyr LANLIB                    *}
{*                   for Turbo Pascal (tm) 4.0 or higher                  *}
{*                     Copyright (c) by SoftWeyr,1994                     *}
{**************************************************************************}

{Example for NetBIOS seances }

uses NetBios,CRT;
Const Esc=#27;
var N,     {NCB for recieving}
    N2:NCB;{NCB for sending}
    Key:Char;
    S:String;
Const SeanceOn:Boolean=False;

Procedure ShutDown;far;
{Exit procedure - closes seance and deletes name upon program termination,
 including runtime errors.
 Never forget to delete NetBIOS names, otherwise you can overrun name table}\

begin
 TextAttr:=$0C;
 if SeanceOn then
  begin
   Write('Ending seance');
   EndSeance(N);
   While not CheckComplete(N) do
    begin
     Delay(100);
     Write('.');
    end;
   Writeln;
  end;
 Write('Deleting Name');
 DeleteNCBName(N,False);
 While not CheckComplete(N) do
 begin
  Delay(100);
  Write('.');
 end;
end;

Procedure CheckRecieve;
{Character recieving }
begin
 if CheckComplete(N) then
   {is recieve command completed? }
  begin
   {if so then }
   if N.RetCode=nbTimeout then
    begin
     {ignore timeout. Our correspondent is simply silent }
     N.RetCode:=0;
    end
  else
  if N.RetCode=0 then
   begin
    {Something recieved. Print it }
    S[0]:=Chr(N.Length);
    TextAttr:=$0B;
    Write(S);
    Key:=S[N.Length];
    if Key=#27 then SeanceOn:=False;
   end else
   begin
     {otherwice error }
     TextAttr:=$0c;
     Writeln('Seance aborted. Error code = ',N.Retcode);
     SeanceOn:=not N.RetCode=nbSeanceClosed;
     Halt;
    end;
    {Issue next recieve command, and do something else , while it works}
    Recieve(N,S[1],128);
  end;
end;
Procedure SendKey;
{Symbol send procedure }
const  CrLf:Word=$0A0D;
begin
 Key:=ReadKey;
 {Get symbol from keyboard and display it }
 TextAttr:=$0E; {yellow color}
 if Key=#13 then Writeln else Write(Key);
 {Now wait for completion of prevoius send command and
  NCB would available. We can instead create new NCB and destroy it upon
 completions, but to boring for me}
 While not CheckComplete(N2) do delay (10);
 if N2.RetCode<>0 then
  begin
   {if there was an error, halt }
    TextAttr:=$0C;
    Writeln('Sending error.Error code = ',N2.RetCode);
    SeanceOn:=not N.RetCode=nbSeanceClosed;
    Halt
  end;
  {Sending new char at last}
  if Key=#13 then Send(N2,CrLf,2) else Send(N2,Key,1);
end;
begin
 if ParamCount<2 then
   begin
    Writeln('Usage: ');
    Writeln('CHAT localname remotename');
    Writeln('where  localname and remotename - unique names of two processes');
    writeln('which are chatting. They cannot be equial to each other or any other name');
    Writeln('defined in network i.e. workstantion name.');
    Halt;
   end;
 N.Adapter:=0;
 ExitProc:=@ShutDown;
 N.Post:=Nil;
 TextAttr:=$0C;
 AddName(N,ParamStr(1));
 {Create local name which is first in command line }
 Write('Adding name ',ParamStr(1));
 While not CheckComplete(N) do
 begin
  {Wait some time}
  Delay(100);
  Write('.');
 end;
 writeln;
{Try to call remote name }
 Writeln('Calling ',ParamStr(2));
 StartSeance(N,ParamStr(2),10,10,True,True);
 if (N.RetCode=nbNameNotListening)or(N.RetCode=nbCannotOpenSeance) then
  {if he is not listening, listen ourself }
  begin
    Write('Waiting for ',ParamStr(2),' call. Press ESC for interrupt');
    Repeat
       StartSeance(N,ParamStr(2),10,10,False,False);
       While not CheckComplete(N) do
        begin
         Delay(100);
         Write('.');
       if KeyPressed then
         if ReadKey=Esc then
          begin
           Writeln('User interrupt');
           halt;
          end;
        end;
       if (N.RetCode<>nbTimeOut)and(N.RetCode<>nbSuccess) then
         begin
          Writeln('Error Code=',N.RetCode);
          Halt;
         end;
    Until N.RetCode= nbSuccess;
    writeln;
  end else if N.RetCode<>nbSuccess then
         begin
          Writeln('Error Code=',N.RetCode);
          Halt;
         end;
 {Duplicate our NCB}
 CopyNcb(N,N2);
 {Issue recieve command }
 Recieve(N,S[1],128);
 {Main loop }
 TextAttr:=$0F;
 SeanceOn:=True;
 Writeln('CHAT: type any text ');
 Repeat
  if KeyPressed then
   SendKey else
    CheckRecieve;
 Until Key=Esc;
end.
