program restore;
{$V-,U+}
(*
This program is designed to strip from inline code
produced by Dave Baldwin's Inline.com program everything that Inline
added to the input file.  It does this by stripping all lines up
to and including the left brace, and truncating lines before the
right brace.  If you have added other things to the file,
it is not then ready for inputting to Inline.  If you did not
add anything, it is.

    C>restore infile outfile
*)

type longstring = string[255];

var
   filename:  string[36];
   infile, outfile: text[$2000];
   tline: longstring;

procedure get_files;

 begin
  assign(infile, ParamStr(1));
  reset(infile);
  assign(outfile, ParamStr(2));
  rewrite(outfile);
 end;

procedure close_files;

 begin
  close(infile);
  close(outfile);
 end;


begin
 get_files;
 while not eof(infile) do
  begin
   readln(infile, tline);
   if (tline <> 'Inline(') and (tline <>');') then
    begin
     delete (tline,1, pos('{',tline));
     if pos('}',tline)>0 then tline[0] := chr(pos('}',tline) - 1);
     writeln (outfile,tline);
   end;
  end;
close_files;
end.
