program comstrip;
{$V-,U+}
(*
This program is designed to strip comments from Inline code
produced by Dave Baldwin's Inline.com program.  It also puts the
Inline code itself into lines of somewhere around 78 characters
long.  It assumes that the word Inline begins in col.1 and that
the ending ); also begins in col.1.  Only lines between those
two signals are affected.  Everything else is passed from input
to output without change.   Because of the way Inline.com works,
there should be no multiline comments in the inline code it
produces.  This program assumes there are none.
To run,
   C>comstrip infile outfile

NOTE: This file specifies three include files.  These files are
not included here.  The routines, however, can be found in
Strnfst2.pas, and you can replace the three include files
specified here with that file.

*)

type longstring = string[255];

var
   filename:  string[36];
   infile, outfile: text[$2000];
   tline: longstring;

const
   InLineStart: string[7] = 'Inline(';
   InLineEnd:   string[2] = ');';

{$I stripr.inc}
{$I stripl.inc}
{$I equals.inc}

procedure get_files;

 begin
  assign(infile, ParamStr(1));
  reset(infile);
  assign(outfile, ParamStr(2));
  rewrite(outfile);
 end;

procedure close_files;

 begin
  close(infile);
  close(outfile);
 end;

procedure closeup(var tline:longstring);

 var
  outline:longstring;
  i,j : integer;

 const
  blank = ' ';
  CommentStart = '{';
  CommentEnd   = '}';

   (*-----------------------------*)
   procedure cleanit;
   begin
    stripl(tline,blank);
    i := pos(CommentStart,Tline);
    if i <> 0 then tline := copy (tline,1,i-1); {strips the comments}
    stripr(tline, blank);
    if (length(tline) > 0) and (pos('$',tline)>0) then
     begin
       outline := outline + tline;
       if length(outline) > 78 then
        begin
         j := 78;
         while (outline[j] <> '/') and (j >0) do j := pred(j);
         if j = 0 then
          begin
           writeln ('Error in input file');
           halt;
          end;
         writeln(outfile, blank, blank,copy(outline,1,j));
         delete(outline,1,j);
       end;
    end;
   readln(infile,tline);
   end; {the while}


 begin {closeup}
  writeln(outfile,tline);
  outline:='';
  readln (infile,tline);
  while not equal_structures (tline[1],InLineEnd[1],2) do cleanit;
  if length(outline)>0 then tline := blank + blank + outline + tline;
 end; {closeup}

begin
 get_files;
 while not eof(infile) do
  begin
   readln(infile, tline);
   if equal_structures (tline[1],InLineStart[1],7) then closeup(tline);
   writeln(outfile,tline);
  end;
close_files;
end.
