Unit StatLine;
{version 1.01}
{-------------------------------------------------------------------------}
{                                                                         }
{ purpose:  create and handle a status line with flexible mouse interface }
{                                                                         }
{ Author:   Giuseppe Maxia                                                }
{           Compuserve: 10015,212                                         }
{           BIX       : gmaxia                                            }
{                                                                         }
{           Released to public domain 1991                                }
{                                                                         }
{ Requirements: Turbo Pascal 5.5 / 6.0                                    }
{               Object professional 1.x                                   }
{                                                                         }
{ Usage:        see STATLINE.DOC for syntax                               }
{                   and SL_TEST*.PAS for sample                           }
{                                                                         }
{-------------------------------------------------------------------------}
{ revision history                                                        }
{ ver. 1.00 --  base version                                              }
{                                                                         }
{ ver. 1.01 - bug fixed in StatLine.Done. Now frees memory correctly.     }
{           - method IncRow added, to allow increment current Row when    }
{             constructing topics.  see SL_TEST4.PAS for sample           }
{           - maximum length of string per topic incremented to 80.       }
{-------------------------------------------------------------------------}

interface

uses
  OpCrt;

type
  ByteSet = set of byte;
  StatusTopicPtr = ^StatusTopic;
  StatusTopic = record              {--------------------------------}
    Prev,                           {                                }
    Next     : StatusTopicPtr;      {    record of Topic             }
    Key      : word;                {    informations                }
    TopX,                           {                                }
    TopY     : byte;                {                                }
    CmdSpace : ByteSet;             {--------------------------------}
    TopName  : string[80];          { do not modify field order !!!  } {1.1!!}
  end;                              {--------------------------------}

  StatusLine = object
     constructor Init( MinR,             {Minimum Row allowed}
                       MaxR : byte;      {Maximum Row Allowed : must be same of MinR if you use only a row}
                       FA : FlexAttrs);  {Colors to write status line contents}

     function AddTopic(Name : string;         {text for topic}
                       K   : word): boolean;  {Key value to return}
     procedure DrawTopic(T : StatusTopicPtr); virtual;
     procedure HideTopic(T : StatusTopicPtr); virtual;
     function IncRow : boolean;                                        {1.1!!}
     procedure Draw; virtual;
     Function GetKey( Row, Col : byte; Defkey : word) : word; virtual;
     procedure Hide; virtual;
     destructor Done; virtual;
     private
     FirstTop,
     CurTop   : StatusTopicPtr;
     ScreenP  : pointer;            {Store screen contents for Status Line}
     MinRow,                        {Minimum Row for Status Line}
     MaxRow,                        {Maximum Row for Status Line}
     CurRow,                        {Current Row while constructing Status Line}
     CurCol   : byte;               {Current Column while constructing Status Line}
     FlexColors : FlexAttrs;        {Colors to write status line contents}
  end;

implementation

uses
  OpString;

     constructor StatusLine.Init( MinR,
                                  MaxR : byte;
                                  FA: FlexAttrs);
     var
       xx : byte;
     begin
       FirstTop := nil;
       CurTop   := nil;
       ScreenP  := nil;
       MinRow := MinR;
       MaxRow := MaxR;
       CurRow := MinRow;
       FlexColors := FA;
       CurCol := 1;
       if not SaveWindow(1,MinRow,ScreenWidth,MaxRow, True,ScreenP) then
         fail;
       GetMem(FirstTop,SizeOf(StatusTopic));
       if FirstTop = nil then
         fail;
       FirstTop^.Next := nil;
       FirstTop^.Prev := nil;
       CurTop := FirstTop;
       for xx := MinRow To MaxRow do
         FastWrite(CharStr(' ',ScreenWidth),xx,1,FlexColors[0]);
     end;  {StatusLine.Init}

     function StatusLine.AddTopic( Name : string;
                                   K    : word): boolean;
     var xx,x1: byte;
     begin
       AddTopic := false;
       GetMem(CurTop^.Next,Sizeof(StatusTopic)-80+length(Name));
         if CurTop^.Next = nil then
           exit;
       CurTop^.Next^.Prev := CurTop;
       CurTop := CurTop^.Next;
       With CurTop^ do begin
         Next := nil;
         TopName := name;
         TopY := CurRow;
         TopX := CurCol;
         Key := K;
         CmdSpace := [];
         while Name[length(Name)] = ' ' do
           dec(byte(Name[0]));
         x1 := FlexLen(Name);
         if x1 = 1 then
           CmdSpace := [CurCol]
         else
           for xx := CurCol to (CurCol + x1-1) do
             CmdSpace := CmdSpace + [xx];
       CurCol := CurCol+FlexLen(TopName);
       end;
       if (CurCol > ScreenWidth) then
         if not IncRow then ;                                          {1.1!!}
       if FirstTop^.Next = nil then
         FirstTop := CurTop;
       AddTopic := true;
     end;  {StatusLine.AddTopic}

     procedure StatusLine.DrawTopic( T : StatusTopicPtr);
     begin
       with T^ do
         FLexWrite(TopName, TopY,TopX,FlexColors);
     end;  {StatusLine.DrawTopic}

     function StatusLine.IncRow;                                       {1.1!!}
     begin
       IncRow := false;
       if CurRow >= MaxRow then exit;
       inc(CurRow);
       CurCol := 1;
       IncRow := true
     end;  {StatusLine.IncRow}


     procedure StatusLine.Draw;
     var T : StatusTopicPtr;
     begin
       T := FirstTop;
       while T^.next <> nil do begin
         DrawTopic(T^.next);
         T := T^.next
       end;
     end;  {StatusLine.Draw}

     procedure StatusLine.HideTopic( T : StatusTopicPtr);
     begin
       with T^ do
         FastWrite(TopName, TopY,TopX,$11);
     end;  {StatusLine.HideTopic}


     procedure StatusLine.Hide;
     var T : StatusTopicPtr;
     begin
       T := FirstTop;
       while T^.next <> nil do begin
         HideTopic(T^.next);
         T := T^.next
       end;
     end;  {StatusLine.Hide}

     destructor StatusLine.Done;
     var
       T: StatusTopicPtr;
     begin
       T := FirstTop;
       while T^.Next <> nil do
         T := T^.next;
       while T^.Prev <> nil do begin
         T := T^.Prev;
         FreeMem(T^.Next,
                 SizeOf(StatusTopic)-80 + length(T^.Next^.TopName)); {1.1!!}
         T^.Next := nil;
       end;
       FreeMem(FirstTop,SizeOf(StatusTopic));
       FirstTop := nil;
       RestoreWindow(1,MinRow,ScreenWidth,MaxRow,True,ScreenP);
     end;  {StatusLine.Done}

     function StatusLine.GetKey( Row,Col:byte;DefKey:Word) : word;
     var
       T : StatusTopicPtr;
     begin
       GetKey := DefKey;
       T := FirstTop;
       while T^.next <> nil do begin
         T := T^.next;
         if (T^.TopY = Row) and (Col in T^.CmdSpace) then begin
           GetKey := T^.Key;
           exit
         end;
       end;
     end;  {StatusLine.GetKey}

end.
