program math_test;

uses
   crt,math;

const
     space = '               ';

var
    deg, radian_angle,x : single;

begin
    x := 1/3;
    clrscr;
    writeln(space,'        MATH TEST');
    writeln('            expected                 actual');
    writeln('            --------                 ------');
    deg := 45.0;
    radian_angle := deg_rad(deg);

{ trig functions }
    { tan answer should be 1.0}
    writeln('tan         1.000',space,tan(radian_angle):10:3);
    { secant answer should be 1.414}
    writeln('secant      1.414',space,secant(radian_angle):10:3);
    { cosecant answer should be 1.414}
    writeln('cosecant    1.414',space,cosecant(radian_angle):10:3);
    { cotan answer should be 1.000}
    writeln('cotan       1.000',space,cotan(radian_angle):10:3);

{ log functions }
    { power answer should be 3.737 }
    writeln('3.0**1.2    3.737',space,power(3.0,1.2):10:3);
    { log10 answer should be 3.000 }
    writeln('log10       3.000',space,log10(1000):10:3);
    { logxy answer should be 9.966 }
    writeln('logxy       9.966',space,logxy(1000,2):10:3);

{ useful functions }
    { dprod answer should be 0.333333333333333333 etc }
    writeln('dprod       0.333333333333333',dprod(1/3,1.0):28:20);
    { regular answer should be 0.333333343 etc }
    writeln('regular     0.333333343 etc  ',x:28:20 );
    { factorial answer should be 120 }
    writeln('factorial 120.000',space,factorial(5):10:3 );

{ some inverse functions }
    { arccos answer should be 45.0 }
    writeln('arccos     45.000',space,rad_deg(arccos(cos(radian_angle))):10:3 );
    { arcsin answer should be 45.0 }
    writeln('arcsin     45.000',space,rad_deg(arcsin(sin(radian_angle))):10:3 );
    { arctan2 answer should be 45.0 }
    writeln('arctan2    45.000',space,rad_deg(arctan2(tan(radian_angle),1.0)):10:3 );

{ some hyperbolic functions }
    { cosh answer should be 74.210 }
    writeln('cosh       74.210',space,cosh(5.0):10:3 );
    { sinh answer should be 74.203 }
    writeln('sinh       74.203',space,sinh(5.0):10:3 );
    { tanh answer should be 1.0 }
    writeln('tanh        1.000',space,tanh(5.0):10:3 );

end.