
{   This program demonstates the use of a        }
{   bitmap splash screen that appears upon       }
{   loading the program for a period of ten      }
{   seconds.                                     }
{   Copyright 1992, SJHDesign                    }


program ZWindow;

{$R zilch.res}

uses WObjects, WinTypes, WinProcs, Splash;

const
  menu_File = 0;
  id_menu =100;
  id_icon = 'ZILCHICON';
  cm_About = 101;
  cm_Quit = 103;

type

  { Declare TZilchApp, a TApplication descendant }
  ZilchApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  { Declare TZilchWindow, a TWindow descendant }
  PZilchWindow = ^TZilchWindow;
  TZilchWindow = object(TWindow)
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure CMAbout(var Msg: TMessage);
      virtual cm_First + cm_About;
    procedure GetWindowClass(var AWndClass: TWndClass); virtual;
    procedure CMQuit(var Msg: TMessage);
      virtual cm_First + cm_Quit;
  end;

{ Construct a TWindow object, loading its menu }
constructor TZilchWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  TWindow.Init(AParent, ATitle);
  Attr.Menu := LoadMenu(HInstance, PChar(id_menu));
end;

procedure TZilchWindow.GetWindowClass(var AWndClass: TWndClass);
begin
  TWindow.GetWindowClass(AWndClass);
  AWndClass.HIcon := LoadIcon(HInstance, 'APPICON')
end;

procedure TZilchWindow.CMQuit(var Msg: TMessage);
begin
   TWindow.CloseWindow;
end;

procedure TZilchWindow.CMAbout(var Msg: TMessage);
var
  Dialog:TDialog;
begin
  Dialog.Init(@Self, 'About');
  Dialog.Execute;
  Dialog.Done
end;

{ Construct the TZilchApp's MainWindow of type TWindow }
procedure ZilchApplication.InitMainWindow;
begin
  MainWindow := New(PZilchWindow, Init(nil, 'SplashScreen Demo'));
end;

  { Declare a variable of type TFileApp }
var
  ZilchApp : ZilchApplication;

{ Run the FileApp }
begin
  ZilchApp.Init('ZilchApp');
  Application^.MakeWindow(New(PPicWindow, Init(nil, ws_Popup or ws_visible
    and not ws_OverlappedWindow)));
  ZilchApp.Run;
  ZilchApp.Done;
end.
