{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}

Unit ScrEd40;

Interface

Uses Crt,Dos;
Const
S_LineSize     : Integer   = 160;
S_Zeros        : String[8] = '00000000';

Type
S_Cursors = (S_Bold,S_Off,S_Normal,S_GetCursor);
S_RecType = (S_Index,S_Data,S_Fields,S_FieldRanges);
S_Str16   = String[16];
S_Str80   = String[80];
S_Rec     = Record
   Case S_RecordType:S_RecType of
        S_Index:  {Total Bytes 3457}
          (S_Name         : Array[1..128] of String[16];
           S_Number       : Array[1..128] of Byte;
           S_RecordNumber : Array[1..128] of Integer;
           S_FieldsRecNo  : Array[1..128] of Integer;
           S_RangeRecNo   : Array[1..128] of Integer;
           S_First        : Array[1..128] of Byte;
           S_Count        : Array[1..128] of Byte;
           S_CompiledInd  : Array[1..128] of Byte;
           S_RangeRecNext : Integer;
           S_RangeLineNext: Integer;
           S_sFiled       : Integer;);
        S_Data:   {Total Bytes 3840 + 1}
          (S_Video        : Array[1..3840]of Char;
           S_WorkArray    : Array[1..80,1..2] of Char;);
           S_Fields: {Total Bytes 4225}
          (S_FieldName    : Array[1..128] of String[16];
           S_Row          : Array[1..128] of Byte;
           S_Col          : Array[1..128] of Byte;
           S_Len          : Array[1..128] of Byte;
           S_Type         : Array[1..128] of Byte;
           S_Prev         : Array[1..128] of Byte;
           S_Next         : Array[1..128] of Byte;
           S_DataLen      : Array[1..128] of Byte;
           S_NormalBG     : Array[1..128] of Byte;
           S_NormalFG     : Array[1..128] of Byte;
           S_PromptBG     : Array[1..128] of Byte;
           S_PromptFG     : Array[1..128] of Byte;
           S_DisplayBG    : Array[1..128] of Byte;
           S_DisplayFG    : Array[1..128] of Byte;
           S_RangeNextRec : Array[1..128] of Integer;
           S_RangeNextLine: Array[1..128] of Byte);
       S_FieldRanges: {Total Bytes 3608 + 1}
          (S_RangeList  : Array[1..51] of String[78];
           S_RangeRec   : Array[1..51] of Integer;
           S_RangeLine  : Array[1..51] of Byte);
       End;
    S_RecPointer  = ^S_Rec;
    WorkAreaType      = Array[1..4096] of byte;
    WorkAreaPtr       = ^WorkAreaType;
    FieldPointerType  = Array[1..128] of integer;
    FieldPointer      = ^FieldPointerType;
    BufferPointerType = Array[1..128] of Pointer;
    BufferPointer     = ^BufferPointerType;

Var
S_File     : File of S_Rec;
S_Indx     : S_RecPointer;
S_Record   : S_RecPointer;
S_Field    : S_RecPointer;
S_WorkArea : WorkAreaPtr;
S_FieldPtr : FieldPointer;
S_BuffPtr  : BufferPointer;
S_Cursor   : S_Cursors;
S_CursorOld: Integer;
S_Msg,
S_WorkStr,
S_EditStr     : S_Str80;
S_RecNo,
S_MessBg,
S_MessFg,
S_NormBg,
S_NormFg,
S_Num,
S_Count,
S_FirstField,
S_Direction,
S_PointHold,
S_Point,
S_RegCX : Integer;
S_Freq,
S_Dur,
S_Seg,
S_Ofs  : Word;
S_BW,
S_Sound_Hold,
S_Sound,
S_Mono,
S_Fkey,
S_ShowStatus,
S_LeftShift,
S_RightShift,
S_Shift,
S_Alt,
S_Ctrl,
S_ScrollLock,
S_NumLock,
S_Caps,
S_ESC,
S_F1,
S_F2,
S_F3,
S_F4,
S_F5,
S_F6,
S_F7,
S_F8,
S_F9,
S_F10,
S_F11,
S_F12,
S_Enter,
S_BkSp,
S_Home,
S_Up,
S_PgUp,
S_Left,
S_Right,
S_End,
S_Down,
S_PgDn,
S_Ins,
S_Del,
S_Tab,
S_Validate_Upcase,
S_Validate_Finished,
S_ScreenValid : Boolean;
S_Attrib,
S_Reverse     : Byte;
S_Ch          : Char;
S_Ch_Num      : Byte absolute S_Ch;
S_NumLockBit  : Integer absolute $40:$17;

{** Promgrammers General Purpose Calls **}

Procedure S_SetCursor(Switch:S_Cursors);
Procedure S_Beep(Freq,Dur:Word);
{
R = Row
C = Column
T = Type
L = Length
F = Forground Color
B = Background Color
DL = Length of Data in field
DF = Display ForGround
DB = Display Background
NF = Normal Forground;
NB = Normal Background;
HR = Help Record;
HL = Help Line;
S  = Var of type S_Str80
}
Function  S_UpShiftedStr(Target_String:S_Str80):S_Str80;
Procedure S_EditString (R,C,T,L,F,B,DF,DB,NF,NB,HR,HL:Integer;Var S:S_Str80);
Procedure S_DisplayScreenField(R,C,T,L,DL,DF,DB,NF,NB:Integer;Var S:S_Str80);


Procedure S_Init; {Performed automaticaly in S_OpenScreenFile}
Procedure S_OpenScreenFile(ScrFileName:S_Str80);
Procedure S_LoadScreen(ScrName:S_Str80);
Procedure S_CloseScreenFile;

Procedure S_ResetKeyFlags;
Procedure S_NextKey;
Procedure S_ReadKey;
Procedure S_ReadField;
Procedure S_ReadScreen;


{** Low Level Calls - Use with Caution **}

Procedure S_FillScreen;
Procedure S_DisplayMessage(BackG,ForG : Integer; Message: S_Str80);
Procedure S_PutScrMem(var Source, Dest; Len : integer);
Procedure S_GetScrMem(var Source, Dest; Len : integer);
Procedure S_Write(Row,Col,Lgth : Integer; Lines,Attribs : S_Str80);

{** Do Not Use - For use by Turbo ScrEdit only **}
Procedure S_ValidateScreen;
Procedure S_Validate_Location;
Procedure S_Store_Buf_Loc (ScrName:S_Str80;ScrBuf:WorkAreaPtr);

{==}
Implementation
{==}

Var
S_Wait,
S_ChangeScreen,
S_InsertMode,
S_LeftArrow,
S_RightArrow,
S_InsertKey,
S_DeleteKey,
S_BackSpace   : Boolean;
S_Ins_Str     : String[1];
S_NewStr,
S_Blanks,
S_Padding,
S_WorkAttrib,
S_NormAttrib,
S_EditAttrib  : String[80];
S_StAttrWork  : String[20];
S_StatusAttrib,
S_StatusLine  : String[40];
S_ValidateField,
S_ValidateRecNo,
S_ValidateLine,
S_Fg,
S_Bg,
S_Max_Dec,
S_Max_Dig,
S_Dec_Pos,
S_Str_Pos : Integer;

{Variables used in validation procedures}

S_UpCase,
S_Skip,
S_Matched,
S_Done,
S_EndLine,
S_InIf : Boolean;
S_CompMin,
S_CompMax,
S_CurStr  : S_Str80;
S_FieldCounter,
S_NextRec,
S_NextLine,
S_Result,
S_FieldNo,
S_Str_Ptr  : Integer;
S_Numeric,
S_CompMin_Numeric,
S_CompMax_Numeric  :Real;

S_VideoPort : Integer absolute $40:$63;

Procedure S_SetCursor(Switch:S_Cursors);
Const
IntNo  : Integer = $10;
Var
S_Regs : Registers;

Begin
FillChar(S_Regs,SizeOf(S_Regs),00);
S_Regs.AH := 1;
S_Regs.Bh := 0;

Case Switch of
    S_Normal    : S_Regs.Cx := S_CursorOld;
    S_Off       : S_Regs.CX := 4096;
    S_Bold      : S_Regs.CX := 15;
    S_GetCursor : S_Regs.AH := 3;
End;{Case}

Intr(IntNo,S_Regs);

If  Switch = S_GetCursor Then
    S_CursorOld := S_Regs.Cx;
End;



Procedure S_GetKey;
Begin
S_ResetKeyFlags;
S_Ch := #00;

If  S_Wait Then
    S_DisplayMessage(S_MessBg,S_MessFg,S_Msg);

While Not KeyPressed Do
    Begin
    S_Count          := 0;
    S_LeftShift  := False;
    S_RightShift := False;
    S_Shift      := False;
    S_Ctrl       := False;
    S_Alt        := False;
    S_ScrollLock := False;
    S_NumLock    := False;
    S_Caps       := False;
    S_InsertMode := False;
    If  ((S_NumLockBit and 2)=2) Then
        Begin
        S_Count     := S_Count + 1;
        S_LeftShift := True;
        S_Shift     := True;
        End;
    If  ((S_NumLockBit and 1)=1) Then
        Begin
        S_Count      := S_Count + 1;
        S_RightShift := True;
        S_Shift      := True;
        End;
    If  ((S_NumLockBit And 4)=4) Then
        Begin
        S_Count := S_Count + 1;
        S_Ctrl  := True;
        End;
    If  ((S_NumLockBit And 8)=8) Then
        Begin
        S_Count := S_Count + 1;
        S_Alt   := True;
        End;
    If  ((S_NumLockBit And 16)=16) Then
        S_ScrollLock := True;
    If  ((S_NumLockBit and 32)=32) then
        S_NumLock := True;
    If  ((S_NumLockBit And 64)=64) Then
        S_Caps := True;
    If  ((S_NumLockBit And 128)=128) Then
        S_InsertMode := True;
    If  S_ShowStatus Then
        Begin
        FillChar(S_StatusAttrib,41,02);
        S_StatusAttrib[0] := #40;
        If  S_InsertMode Then
            Move(S_StAttrWork[1],S_StatusAttrib[1],8);
        If  S_Caps Then
            Move(S_StAttrWork[1],S_StatusAttrib[10],6);
        If  S_NumLock Then
            Move(S_StAttrWork[1],S_StatusAttrib[17],10);
        If  S_ScrollLock Then
            Move(S_StAttrWork[1],S_StatusAttrib[28],13);
        If  S_Wait = False Then
            S_Write(25,21,40,S_StatusLine,S_StatusAttrib);
        End;
    If  S_Count > 1 Then
        Begin
        S_Fkey := True;
        Exit;
        End;
    End;

S_Wait := False;
S_Ch   := ReadKey;

If  S_Msg > '' Then
    Begin
    S_Msg := '';
    S_DisplayMessage(S_MessBg,S_MessFg,S_Msg);
    End;

S_Done := True;
Case S_Ch_Num of
     9 : S_Tab   := True;
    27 : Begin
         S_Esc   := True;
         S_Fkey  := True;
         Exit;
         End;
    13 : S_Enter := True;
     8 : Begin
         S_BkSp      := True;
         S_BackSpace := True;
         End;
Else
    S_Done := False;
End;

If  S_Done Then
    Begin
    S_Ch_Num := 0;
    Exit;
    End;

If  S_Ctrl Then
    If  S_Ch_Num In [1..26] Then
        Begin
        S_Fkey   := True;
        S_Ch_Num := S_Ch_Num + 64;
        Exit
        End;

If  S_Shift Then
    Begin
    S_Done := True;
    Case S_Ch of
      '8'    : S_Up    := True;
      '7'    : S_Home  := True;
      '9'    : S_PgUp  := True;
      '4'    : S_Left  := True;
      '6'    : S_Right := True;
      '1'    : S_End   := True;
      '2'    : S_Down  := True;
      '3'    : S_PgDn  := True;
      '0'    : S_Ins   := True;
      '.'    : S_Del   := True;
    Else
        S_Done := False;
    End;
    If  S_Done Then
        Begin
        S_Fkey   := True;
        S_Ch_Num := 0;
        Exit;
        End;
    End;
If  S_Ch_Num = 0 Then
    Begin
    S_Ch := ReadKey;
    Case S_Ch_Num Of
        84..93,135,136                                 : S_Shift := True;
        94..103,115..119,132,137,138                   : S_Ctrl  := True;
        16..25,30..38,44..50,104..113,120..121,139,140 : S_Alt   := True;
    End;
    If  S_Alt Then
        Begin
        S_Done := True;
        Case S_Ch_Num Of
            30  : S_Ch    := 'A';
            48  : S_Ch    := 'B';
            46  : S_Ch    := 'C';
            32  : S_Ch    := 'D';
            18  : S_Ch    := 'E';
            33  : S_Ch    := 'F';
            34  : S_Ch    := 'G';
            35  : S_Ch    := 'H';
            23  : S_Ch    := 'I';
            36  : S_Ch    := 'J';
            37  : S_Ch    := 'K';
            38  : S_Ch    := 'L';
            50  : S_Ch    := 'M';
            49  : S_Ch    := 'N';
            24  : S_Ch    := 'O';
            25  : S_Ch    := 'P';
            16  : S_Ch    := 'Q';
            19  : S_Ch    := 'R';
            31  : S_Ch    := 'S';
            20  : S_Ch    := 'T';
            22  : S_Ch    := 'U';
            47  : S_Ch    := 'V';
            17  : S_Ch    := 'W';
            45  : S_Ch    := 'X';
            21  : S_Ch    := 'Y';
            44  : S_Ch    := 'Z';
            114 : S_Ch    := '*';
            120 : S_Ch    := '1';
            121 : S_Ch    := '2';
            122 : S_Ch    := '3';
            123 : S_Ch    := '4';
            124 : S_Ch    := '5';
            125 : S_Ch    := '6';
            126 : S_Ch    := '7';
            127 : S_Ch    := '8';
            128 : S_Ch    := '9';
            129 : S_Ch    := '0';
            130 : S_Ch    := '-';
            131 : S_Ch    := '=';
        Else
            S_Done := False;
        End;
        If  S_Done Then
            Begin
            S_Fkey := True;
            Exit;
            End;
        End;
    S_Done := True;
    Case S_Ch_Num Of
        15 : S_Tab         := True;
        75 : Begin S_Left  := True;S_LeftArrow := True;End;
        77 : Begin S_Right := True;S_RightArrow:= True;End;
        82 : Begin S_Ins   := True;S_InsertKey := True;End;
        83 : Begin S_Del   := True;S_DeleteKey := True;End;
    Else
        S_Done := False;
    End;
    If  S_Done Then
        Begin
        S_Ch_Num := 0;
        Exit;
        End;
    S_Done := True;
    Case S_Ch_Num Of
        59,84,94,104  : S_F1     := True;
        60,85,95,105  : S_F2     := True;
        61,86,96,106  : S_F3     := True;
        62,87,97,107  : S_F4     := True;
        63,88,98,108  : S_F5     := True;
        64,89,99,109  : S_F6     := True;
        65,90,100,110 : S_F7     := True;
        66,91,101,111 : S_F8     := True;
        67,92,102,112 : S_F9     := True;
        68,93,103,113 : S_F10    := True;
        133,135,137,139 : S_F11    := True;
        134,136,138,140 : S_F12    := True;
        71,119        : S_Home   := True;
        79,117        : S_End    := True;
        72            : S_Up     := True;
        80            : S_Down   := True;
        73,132        : S_PgUp   := True;
        75,115        : S_Left   := True;
        77,116        : S_Right  := True;
        81,118        : S_PgDn   := True;
        82            : S_Ins    := True;
        83            : S_Del    := True;
    Else
        S_Done := False;
    End;
    If  S_Done Then
        Begin
        S_Fkey   := True;
        S_Ch_Num := 0;
        End;
    End;
End;

Procedure S_Write
    (Row,Col,Lgth : Integer; Lines,attribs : S_Str80);
Var Pointer:integer;
Begin
For Pointer := 1 to lgth do
    Begin
    S_Record^.S_WorkArray[Pointer,1] := Chr(Ord(Lines[Pointer]));
    S_Record^.S_WorkArray[Pointer,2] := Chr(Ord(Attribs[Pointer]));
    End;
S_PutScrMem(S_Record^.S_WorkArray[1,1],
    Mem[S_Seg:S_Ofs + ((Row-1)*S_LineSize) + ((Col-1)*2)],Lgth * 2);
End;



Procedure S_DisplayMessage(BackG,ForG : Integer; Message: S_Str80);
Begin
FillChar(S_WorkAttrib,81,02);
FillChar(S_Padding,81,32);
S_WorkAttrib[0] := #80;
S_Padding[0]    := #80;
Move(Message[1],S_Padding[(80-Length(Message)) Div 2],Length(Message));
FillChar(S_WorkAttrib[(80-Length(Message)) Div 2],Length(Message),(BackG * 16) + ForG);
If  Message > '' Then
    S_Beep(S_Freq,S_Dur);
S_Write(25,1,80,S_Padding,S_WorkAttrib);
End;


Procedure S_PutScrMem(var Source, Dest; Len : integer);
Begin
If  S_Mono Then
    Move(Source,Dest,Len)
Else
    Begin
    Len := Len shr 1;
    Inline($1E/$55/$BA/$DA/$03/$C5/$B6/Source/$C4/$BE/Dest/$8B/$8E/
         Len/$FC/$AD/$89/$C5/$B4/$09/$EC/$D0/$D8/$72/$FB/$FA/$EC/
         $20/$E0/$74/$FB/$89/$E8/$AB/$FB/$E2/$EA/$5D/$1F);
    End;
End;



Procedure S_GetScrMem(var Source, Dest; Len : integer);
Begin
If  S_Mono Then
    Move(Source,Dest,Len)
Else
    Begin
    Len := Len shr 1;
    Inline($1E/$55/$BA/$DA/$03/$C5/$B6/Source/$C4/$BE/Dest/$8B/$8E/
       Len/$FC/$EC/$D0/$D8/$72/$FB/$FA/$EC/$D0/$D8/$73/$FB/$AD/
       $FB/$AB/$E2/$F0/$5D/$1F);
    End;
End;

Procedure S_Beep(Freq,Dur:Word);
Begin
If  S_Sound = True Then
    Begin
    Sound(Freq);
    Delay(Dur);
    NoSound;
    End;
End;

Procedure S_AllocateMemory;
Begin
If  MaxAvail > 20000 Then
    Begin
    GetMem(S_Indx,SizeOf(S_Indx^));
    GetMem(S_Record,SizeOf(S_Indx^));
    GetMem(S_Field,SizeOf(S_Indx^));
    GetMem(S_FieldPtr,SizeOf(S_FieldPtr^));
    GetMem(S_BuffPtr,SizeOf(S_BuffPtr^));
    End
Else
    Begin
    S_Msg := 'Not enough free Memory!';
    S_DisplayMessage(S_MessBg,S_MessFg,S_Msg);
    Halt;
    End;
S_CursorOld    := 1543;
S_SetCursor(S_GetCursor);
End;
{$I ScrEd3&4.Pas}
End.{Unit}
