Function S_Length(Var S:S_Str80):Integer;
Begin
S_Length:=Pos(S_Blanks,S+S_Blanks) - 1;
End;


Function S_UpShiftedStr(Target_String:S_Str80):S_Str80;
Var
Point : integer;
Begin
Point := 1;
While Point <= Length(Target_String) do
    Begin
    Target_String[Point] := UpCase(Target_String[Point]);
    Point := Point + 1;
    End;
S_UpShiftedStr := Target_String;
End;




Function S_FindScreen(ScrName:S_Str80):Integer;
Var S_Count:Integer;
Begin
S_Count := 0;
Repeat
    S_Count := S_Count + 1;
Until ((S_UpShiftedStr(ScrName)=S_UpShiftedStr(S_Indx^.S_Name[S_Count])) or
       (S_Count > S_Indx^.S_sFiled));
If  S_Count > S_Indx^.S_sFiled Then
    S_Msg := ' Is not in file.'
Else
    If  S_Indx^.S_CompiledInd[S_Count] = 0 Then
        S_Msg := ' has not been compiled..';

If  (S_ChangeScreen = True) And
    (S_Msg > '') then
    Begin
    S_DisplayMessage(S_MessBg,S_MessFg,'<'+ScrName+'>'+S_Msg);
    S_CloseScreenFile;
    Halt;
    End;
S_FindScreen := S_Count;
End;



Procedure S_CloseScreenFile;
Begin
{$I-}
Close(S_File);
{$I+}
S_SetCursor(S_Normal);
End;




Procedure S_ResetKeyFlags;
Begin
S_Fkey    := False;
S_Tab     := False;
S_Ctrl    := False;
S_Esc     := False;
S_Alt     := False;
S_Shift   := False;
S_F1      := False;
S_F2      := False;
S_F3      := False;
S_F4      := False;
S_F5      := False;
S_F6      := False;
S_F7      := False;
S_F8      := False;
S_F9      := False;
S_F10     := False;
S_Enter   := False;
S_BkSp    := False;
S_Home    := False;
S_Up      := False;
S_PgUp    := False;
S_Left    := False;
S_Right   := False;
S_End     := False;
S_Down    := False;
S_PgDn    := False;
S_Ins     := False;
S_Del     := False;
S_NumLock := False;
S_InsertKey := False;
S_DeleteKey := False;
S_BackSpace := False;
S_LeftArrow := False;
S_RightArrow:= False;
End;



Procedure S_Init;
Begin
FillChar (S_Msg,81,00);
FillChar (S_Blanks,81,32);
S_Blanks[0]     := Chr(80);
FillChar(S_NormAttrib,81,00);
S_StatusLine    := '[Insert] [Caps] [Num Lock] [Scroll Lock]';
FillChar(S_StAttrWork,21,32);
S_StAttrWork[0] := #20;

S_MessBg        := 4;
S_MessFg        := 15;
S_NormBg        := 0;
S_NormFg        := 2;
S_Cursor        := S_Normal;
S_Sound         := True;
S_Freq          := 300;
S_Dur           := 100;

S_ChangeScreen  := True;
S_Ch            := Chr(00);
S_Point         := 0;
S_Direction     := 1;
S_NewStr        := '';
S_Padding       := '';
S_RecNo         := 0;
S_ValidateLine  := 0;

S_ResetKeyFlags;

S_Seg := $B000;
If  S_VideoPort = $3B4 Then
    Begin
    S_MessBg  := 7;
    S_MessFg  := 8;
    S_NormBg  := 0;
    S_NormFg  := 10;
    S_Ofs     := $0000;
    S_Mono    := True;
    End
Else
    Begin
    S_Mono := False;
    S_Ofs  := $8000;
    End;

S_BW := False;
For S_Count := 1 to ParamCount Do
    Begin
    S_WorkStr := ParamStr(S_Count);
    If  S_UpShiftedStr(S_WorkStr) = '/BW' Then
        S_BW := True;
    End;
If  S_BW Then
    Begin
    S_MessBg := 0;
    S_MessFg := 15;
    S_NormBg := 0;
    S_NormFg := 15;
    End;

S_AllocateMemory;
S_SetCursor(S_Off);
End;



Procedure S_OpenScreenFile(ScrFileName:S_Str80);
Var
IOerr : Integer;
Begin
Assign(S_File,ScrFileName);
{$I-}
Reset(S_FILE);
IOerr := IOResult;
{$I+}
If  IOerr > 0 then
    Begin
    Str(IoErr:4,S_Msg);
    S_Msg := 'IO error <' + S_Msg + '> reading ';
    End;
If  SizeOf(S_File) = 0 Then
    S_Msg := 'Empty screen file ';
If  S_Msg > '' Then
    Begin
    S_DisplayMessage(S_MessBg,S_MessFg,S_Msg+'<'+ScrFileName+'>');
    S_CloseScreenFile;
    Halt;
    End;
Seek(S_File,0);
Read(S_File,S_Indx^);
End;



Procedure S_Store_Buf_Loc (ScrName:S_Str80;ScrBuf:WorkAreaPtr);
Begin
S_Count := S_FindScreen(ScrName);
S_BuffPtr^[S_Count] := ScrBuf;
End;



Procedure S_LoadScreen(ScrName:S_Str80);
Var
X,Y,Z : Integer;

Begin
S_Msg := '';
S_Num := S_FindScreen(ScrName);

S_WorkArea := S_BuffPtr^[S_Num];
Seek(S_File,S_Indx^.S_RecordNumber[S_Num]);
Read(S_File,S_Record^);
If  S_BW Then
    Begin
    X := 2;
    While X < 4000 Do
        Begin
        S_Record^.S_Video[X] := #15;
        X := X + 2;
        End;
    End;
S_FirstField := 0;
If  S_Indx^.S_FieldsRecNo[S_Num] > 0 then
    Begin
    Seek(S_File,S_Indx^.S_FieldsRecNo[S_Num]);
    Read(S_File,S_Field^);
    S_FirstField := S_Indx^.S_First[S_Num];
    S_Point := 1;
    For X := 1 to S_Indx^.S_Count[S_Num] do
        Begin
        If  S_BW Then
            Begin
            S_Field^.S_DisplayBg[X] := 0;
            S_Field^.S_DisplayFg[X] := 15;
            S_Field^.S_NormalBg [X] := 0;
            S_Field^.S_NormalFg [X] := 15;
            S_Field^.S_PromptBg [X] := 0;
            S_Field^.S_PromptFg [X] := 15;
            End;
        S_FieldPtr^[X] := S_Point;
        If  S_Field^.S_Type[X] In [8,9,98,99] Then
            S_Point := S_Point + S_Field^.S_Len[X]+1
        Else
            S_Point := S_Point + 6;
        For Z := S_Field^.S_Col[X] to
            (S_Field^.S_Col[X] +
            S_Field^.S_Len[X] + 1) do
            Begin
            S_Record^.S_Video
                [((S_Field^.S_Row[X]-1)*S_LineSize)+((Z-1)*2)+1]:= #32;
            End;
        End;
    End;
If  S_ChangeScreen = True Then
    Begin
    S_PutScrMem(S_Record^.S_Video[1],
                       Mem[S_Seg:S_Ofs],3840);
    S_Point := S_FirstField;
    End
Else
    S_ChangeScreen := True;
End;



Procedure S_DisplayScreenField(R,C,T,L,DL,DF,DB,NF,NB:Integer;Var S:S_Str80);
Var
RealWork   : Real;
S_Result   : Integer;
BackColor,
ForColor   : Integer;

Begin
If  T in [1..7,91..97] Then
    Begin
    If  Pos(S,'-0.000000') = 1 then
        Begin
        DL := DL - 2;
        Delete(S,1,2);
        End;
    If  Pos(S,'-0.000000') = 2 then
        Begin
        DL := DL - 1;
        Delete(S,1,1);
        End;
    If  Pos('-0',S) > 1 then
        Begin
        Delete(S,2,1);
        DL := DL -1;
        End;
    End;

S_Padding := Copy(S_Blanks,1,(L-DL));

If  Dl > 0 Then
    S_Result := (DB * 16) + DF
Else
    S_Result := (NB * 16) + NF;

FillChar(S_NormAttrib,81,S_Result);
S_NormAttrib[0] := Chr(80);


If  T in [0..7,90..97] Then
    Begin
    S_Padding := ' ' + S_Padding + S + ' ';
    If  Pos('-.',S) = 1 Then
        Begin
        S_Ins_Str := '0';
        Insert(S_Ins_Str,S,2);
        End;
    If  S[1] <> '-' Then
        S := '0' + S;
    If  Pos('.',S) = 0 Then
        S:= S + '.0'
    Else
        S := S + '0';
    End
Else
    S_Padding := ' ' + S + S_Padding + ' ';

S_Write(R,C,L+2,S_Padding,S_NormAttrib);
End;



Procedure S_FillScreen;
VAR
S_PointHold   : Integer;
RealWork          : Real;

Begin
S_PointHold := S_Point;
S_Point     := 0;
While S_Point < S_Indx^.S_Count[S_Num] Do
    With S_Field^ Do
        Begin
        S_Point := S_Point + 1;
        If  S_Type[S_Point] In [8,9,98,99] Then
            Begin
            Move(S_WorkArea^[S_FieldPtr^[S_Point]],S_EditStr,
                 S_Len[S_Point] + 1);
            S_DataLen[S_Point] := Ord(S_EditStr[0]);
            End
        Else
            Begin
            Move(S_WorkArea^[S_FieldPtr^[S_Point]],RealWork,6);
            If  S_Type[S_Point] In [0,90] Then
                Begin
                Str(RealWork:1:0,S_EditStr);
                S_DataLen[S_Point] := Ord(S_EditStr[0]);
                End
            Else
                Begin
                If  S_Type[S_Point] In [2..7] Then
                    Str(RealWork:1:S_Type[S_Point]-1,S_EditStr)
                ELSE
                    Str(RealWork:1:S_Type[S_Point]-91,S_EditStr);
                S_DataLen[S_Point] := Ord(S_EditStr[0]);
                END;
            End;
        S_DisplayScreenField(
            S_Field^.S_Row[S_Point],
            S_Field^.S_Col[S_Point],
            S_Field^.S_Type[S_Point],
            S_Field^.S_Len[S_Point],
            S_Field^.S_DataLen[S_Point],
            S_Field^.S_DisplayFg[S_Point],
            S_Field^.S_DisplayBg[S_Point],
            S_Field^.S_NormalFg[S_Point],
            S_Field^.S_NormalBg[S_Point],
            S_EditStr);
        S_Field^.S_DataLen[S_Point] := S_Length(S_EditStr);
        END;
S_Point := S_PointHold;
End;



Procedure S_Get_Field_Value(X:Integer);
Var
RealWork : Real;
S_Result   : Integer;

Begin
S_EditStr := '';
With S_Field^ Do
    Begin
    If  S_Type[X] IN [8,9,98,99] Then
        Move(S_WorkArea^[S_FieldPtr^[X]],S_EditStr,S_DataLen[X]+1)
    Else
        Begin
        Move(S_WorkArea^[S_FieldPtr^[X]],RealWork,6);
        IF  S_Type[X] In [0,90] Then
            Str(RealWork:1:0,S_EditStr)
        Else
            IF  S_Type[X] In [2..7] Then
                Str(RealWork:1:S_Type[X]-1,S_EditStr)
            ELSE
                Str(RealWork:1:S_Type[X]-1,S_EditStr);
        S_DataLen[X] := Ord(S_EditStr[0]);
        End;
    End;
End;



Procedure S_EditString (R,C,T,L,F,B,DF,DB,NF,NB,HR,HL:Integer;Var S:S_Str80);
Var
WorkNum  : Real;
S_Result : Integer;

Begin
S_Fg        := 2;
S_Bg        := 0;
S_Str_Pos   := 1;
S_Ins_Str   := ' ';

S_Attrib := Trunc((B*16) + F);

If  S_Attrib > 15 Then
    Begin
    If  F = 0 then
        S_Reverse := 15
    Else
        S_Reverse := F;
    End
Else
    S_Reverse := (7*16) + F;

FillChar(S_EditAttrib,81,S_Attrib);

S_EditAttrib[0] := Chr(L+2);

If  T < 8 Then
    Begin
    If  Pos(S,'0.000000') > 0 then
        S := '';
    If  Pos('0.',S) = 1 Then
        Delete(S,1,1);
    If  Pos('-0.',S) = 1 Then
        Delete(S,2,1);
    End;

S_WorkStr    := S + S_Blanks;
S_WorkStr[0] := Chr(L);
S_Max_Dig    := L - T;

If  S_LeftArrow Then
    Begin
    S_Str_Pos := S_Length(S_WorkStr);
    If  S_Str_Pos < L Then
        S_Str_Pos := S_Str_Pos + 1;
    End;

S_Setcursor(S_Cursor);
Repeat
    If  (T<8) And (S_Str_Pos > S_Length(S_WorkStr)) then
        S_Str_Pos := S_Length(S_WorkStr)+1;

    S_EditAttrib[S_Str_Pos+1] := Chr(S_Reverse);
    S_Write(R,C,L+2,' '+S_WorkStr+' ',S_EditAttrib);
    GoToXY(C+S_Str_Pos,R);
    S_GetKey;
    S_EditAttrib[S_Str_Pos+1] := Chr(S_Attrib);
    S_Write(R,C,L+2,' '+S_WorkStr+' ',S_EditAttrib);

    If  ((S_LeftArrow) Or (S_BackSpace)) Then
        Begin
        If  S_Str_Pos > 1 Then
            Begin
            S_Str_Pos := S_Str_Pos - 1;
            If  S_BackSpace Then
                S_DeleteKey := True;
            End
        Else
            Begin
            If  S_LeftArrow Then
                Begin
                S_Shift := True;
                S_Tab   := True;
                End;
            End;
        End;
    If  S_RightArrow Then
        If  S_Str_Pos < L Then
            Begin
            If  (T < 8) And
                (S_Str_Pos > S_Length(S_WorkStr)) Then
                S_Tab := True
            Else
                S_Str_Pos := S_Str_Pos + 1;
            End
        Else
            S_Tab := True;
    If  S_DeleteKey Then
        Begin
        If  S_Length(S_WorkStr) > 0 Then
            Begin
            Delete(S_WorkStr,S_Str_Pos,1);
            S_WorkStr := S_WorkStr + #32;
            End;
        End;

    If  (Not S_Ctrl) And
        (Not S_Alt ) And
        (Not S_Fkey) And
        (S_Ch In [#32..#127]) Then
        Begin
        If  T < 8 Then
            Begin
            If  (S_Ch = '?') And
                (S_Str_Pos > 1) Or
                (S_Ch <> '?')   Then
                Begin
                Case S_Ch of
                   '-' : If ((Pos('-',S_WorkStr) > 0)
                         Or (S_Str_Pos > 1)) Then
                            S_Ch := #00;
                   '.' : If ((T = 0 ) Or (Pos('.',S_WorkStr) > 0)) And
                            (Pos('.',S_WorkStr) <> S_Str_Pos)  Then
                            S_Ch := #00;
                  '0'..'9':
                Else
                    S_Ch := #00;
                End;{Case of}
                End;{Begin}
            End;

        If  T = 8 Then
            Begin
            If  ((S_Ch = '?') And (S_Str_Pos>1)) Or (S_Ch<>'?') Then
                If  Not (S_Ch In [#32,'A'..'Z','a'..'z']) Then
                    S_Ch := #00;
            End;

        If  S_ch > #00 Then
            Begin
            If  S_InsertMode = True Then
                Begin
                If  S_Str_Pos <= L Then
                    Begin
                    S_Ins_Str[1] := S_Ch;
                    Insert(S_Ins_Str,S_WorkStr,S_Str_Pos);
                    End;
                End
            Else
                S_WorkStr[S_Str_Pos] := S_ch;
            If  S_Str_Pos < L Then
                S_Str_Pos := S_Str_Pos + 1
            Else
                Begin
                S_Tab   := True;
                S_Shift := False;
                End;
            S_WorkStr[0] := Chr(L);
            End;
        End;

    If  ((S_Enter) Or (S_Tab)) And
        (S_WorkStr[1] = '?') Then
        Begin
        S_Msg := '';
        If  (HR > 0) Then
            Begin
            Seek(S_File,HR);
            Read(S_File,S_Indx^);
            If  S_Indx^.S_RangeList[Hl][1]='H' Then
                S_Msg := Copy(S_Indx^.S_RangeList[HL],6,
                         Length(S_Indx^.S_RangeList[Hl]));
            Seek(S_File,0);
            Read(S_File,S_Indx^);
            End;
        If  S_Msg = '' Then
            S_Msg := ' No Help is available for this field ';
        S_Enter  := False;
        S_Tab    := False;
        S_Wait   := True;
        S_Str_Pos := S_Str_Pos - 1;
        Delete(S_WorkStr,1,1);
        End;

Until S_Enter Or
      S_Tab   Or
      S_Esc   Or
      S_Fkey;

S_SetCursor(S_Off);

S_WorkStr := Copy (S_WorkStr,1,S_Length(S_WorkStr));

If  length(S_WorkStr) > 0 Then
    S_Attrib := Trunc((DB*16) + DF)
Else
    S_Attrib := Trunc((NB*16) + NF);

FillChar(S_EditAttrib,81,S_Attrib);
S_EditAttrib[0] := Chr(L+2);

S_Msg     := '';

If  T < 8 Then
    Begin
    If  S_WorkStr = '' then
        S_workstr := '0.0';
    If  S_WorkStr[1] = '.' Then
        S_WorkStr := '0'+S_WorkStr;
    If  Pos('-.',S_WorkStr) = 1 Then
        Begin
        S_Ins_Str[1] := '0';
        Insert(S_Ins_Str,S_WorkStr,2);
        End;
    Val(S_WorkStr,WorkNum,S_Result);
    If  T = 0 Then
        Str(WorkNum:L:T,S_WorkStr)
    Else
        Str(WorkNum:L:(T-1),S_WorkStr);
    While (S_WorkStr [1]= ' ') Or (Length(S_WorkStr)>L) Do
         Delete(S_WorkStr,1,1);
    If  Pos('0.',S_WorkStr) = 1 Then
        Delete(S_WorkStr,1,1);
    If  Pos('-0.',S_WorkStr) = 1 Then
        Delete(S_WorkStr,2,1);
    End;

If  T = 0 Then
    If  S_WorkStr = '' Then
        S_WorkStr := '0';

S_EditStr:= S_WorkStr;
S        := S_WorkStr;
S_DisplayScreenField(R,C,T,L,Length(S_EditStr),DF,DB,NF,NB,S);
End;




Procedure S_Find_Min_and_max;
Begin
FillChar(S_CompMin,81,00);
FillChar(S_CompMax,81,00);
S_Done := False;
S_EndLine    := False;
While Not S_Done Do
    Begin
    S_Str_Ptr := S_Str_Ptr + 1;
    If  S_Str_Ptr <= Length(S_CurStr) Then
        Begin
        If  S_CurStr[S_Str_Ptr] = #94 Then
            Begin
            S_Str_Ptr  := S_Str_Ptr + 1;
            S_CompMax := S_CurStr[S_Str_Ptr]
            End
        Else
            Begin
            If  S_CurStr[S_Str_Ptr] = #39 Then
                Begin
                If  S_CompMax = '' Then
                    S_CompMax := S_CompMin;
                S_Done := True;
                End
            Else
                Begin
                If  S_CompMax = '' then
                    S_CompMin := S_CompMin + S_CurStr[S_Str_Ptr]
                Else
                    S_CompMax := S_CompMax + S_CurStr[S_Str_Ptr];
                End;
            End;
        If  (S_CompMin = '\') or
            (S_CompMin = '=') Then
            S_Done := True;
        End
    Else
        Begin
        S_Done := True;
        If  S_CompMin = '' Then
            S_EndLine    := True;
        End;
    End;
If  S_Upcase Then
    Begin
    S_CompMin := S_UpShiftedStr(S_CompMin);
    S_CompMax := S_UpShiftedStr(S_CompMax);
    End;
End;



Procedure S_ReadNextRangeRec;
Begin
With S_Record^ Do
    Begin
    S_ValidateLine := S_NextLine;
    If  S_RecNo <> S_NextRec Then
        Begin
        S_RecNo := S_NextRec;
        Seek(S_File,S_RecNo);
        Read(S_File,S_Record^);
        End;
    S_NextRec  := S_RangeRec [S_ValidateLine];
    S_NextLine := S_RangeLine[S_ValidateLine];
    S_CurStr := S_RangeList[S_ValidateLine];
    If  S_InIf Then
        S_Str_Ptr := 4
    Else
        S_Str_Ptr := 1;
    End;
End;


Procedure S_ProcessDate;
Label S_ProcessDate_Exit;
Var
TestLen,
Error,
M_Pos,
D_Pos,
Y_Pos     : Byte;
T_Month,
T_Day,
T_Year    : Integer;
DateMask  : String[30];
WorkNum   : Integer;

Begin
Error      := 0;
M_Pos      := 0;
D_Pos      := 0;
Y_Pos      := 0;


DateMask := Copy(S_CurStr,Pos('DATE',S_CurStr)+5,
    Length(S_CurStr)-Pos('DATE',S_CurStr)+4);
S_Str_Ptr   := 1;

If  Length(DateMask) <> Length(S_NewStr) then
    Error := 1; {Date keyed does not match pattern};

While ((Error = 0) and (S_Str_Ptr <= Length(DateMask))) do
    Begin
    Case DateMask[S_Str_Ptr] of
        'Y' : If  Y_Pos = 0 Then
                  Begin
                  Y_Pos := S_Str_Ptr;
                  If  DateMask[S_Str_Ptr+2] = 'Y' Then
                      TestLen := 4
                  Else
                      TestLen := 2;
                  Val(Copy(S_NewStr,S_Str_Ptr,4),T_Year,S_Result);
                  If  (S_Result > 0) Or (T_Year = 0) Then
                      Error := 2;{Year has invalid character};
                  S_Str_Ptr := S_Str_Ptr + (TestLen - 1);
                  End;
        'M' : If  M_Pos = 0 Then
                  Begin
                  M_Pos := S_Str_Ptr;
                  Val(Copy(S_NewStr,S_Str_Ptr,2),T_Month,S_Result);
                  If  (S_Result > 0) Or (T_Month = 0) Then
                      Error := 3;{Month has invalid character};
                  S_Str_Ptr := S_Str_Ptr + 1;
                  End;
        'D' : If  D_Pos = 0 Then
                  Begin
                  D_Pos := S_Str_Ptr;
                  Val(Copy(S_NewStr,S_Str_Ptr,2),T_Day,S_Result);
                  If  (S_Result > 0) Or (T_Day = 0) Then
                      Error := 4;{Day has invalid character};
                  S_Str_Ptr := S_Str_Ptr + 1;
                  End;
        Else  If  S_NewStr[S_Str_Ptr] <> DateMask [S_Str_Ptr] Then
                  Error := 1;{Deliminators do not match};
        End;{Case of}
    S_Str_Ptr := S_Str_Ptr + 1;
    End;

If  Error > 0 Then
    goto S_ProcessDate_Exit;

If  (M_Pos > 0) And
    (Not (T_Month In [1..12])) Then
    Begin
    Error := 6;{Invalid Month Specified}
    goto S_ProcessDate_Exit;
    End;

If  D_Pos > 0 Then
    Begin
    If  M_Pos > 0 Then
        Begin
        If  (T_Month In [1,3,5,7,8,10,12]) Then
            Begin
            If (T_Day > 31) Then
               Error := 8;
            End
        Else
            Begin
            If  (T_Month <> 2) Then
                Begin
                If  (T_Day > 30) Then
                    Error := 9;
                End
            Else
                Begin
                If  (T_Year > 0) Then
                    Begin
                    If  (T_Year Mod 4) <> 0 Then
                        Begin
                        If  (T_Day > 28) Then
                            Error := 10
                        End
                    Else
                        If  (T_Day > 29) Then
                            Error := 11;
                    End
                Else
                    If T_Day > 29 Then
                       Error := 11;
                End;
            End;
        End
    Else
        If  T_Day > 31 Then
            Error := 12;
    End;

S_ProcessDate_Exit:

If  Error > 0 Then
    Begin
    S_ScreenValid := False;
    Case Error Of
       1 : S_Msg := 'Please enter date in ' + DateMask + ' format.';
       2 : S_Msg := 'Year contains invalid charcter.';
       3 : S_Msg := 'Month contains invalid character.';
       4 : S_Msg := 'Day of date contains invalid character.';
       6 : S_Msg := 'Month must be 1 thru 12.';
       8 : S_Msg := 'Only 31 Days in this month.';
       9 : S_Msg := 'Only 30 Days in this month.';
       10: S_Msg := 'February only has 28 days.';
       11: S_Msg := 'February only has 29 days.';
       12: S_Msg := 'Day can never exceed 31';
    End;
    End;

End;


Procedure S_ProcessIN;
Begin
S_EndLine    := True;
S_Matched    := False;
S_Str_Ptr    := Pos('IN',S_CurStr)+3;
S_CompMin[1] := #32;

S_EditStr    := S_NewStr;
If  S_Upcase Then
    S_EditStr := S_UpShiftedStr(S_EditStr);

While Not((S_Matched) or (S_CompMin[1] IN ['\','='])) Do
    Begin
    S_Find_Min_and_max;
    If  (S_CompMin <> '\')  And
        (S_CompMin <> '=')  And
        (Not S_EndLine) Then
        Begin
        If  (S_Field^.S_Type[S_Point] In [0..7,90..97]) Then
            Begin
            S_Numeric   := 0;
            S_CompMin_Numeric := 0;
            S_CompMax_Numeric := 0;
            Val(S_EditStr,S_Numeric,S_Result);
            Val(S_CompMin,S_CompMin_Numeric,S_Result);
            Val(S_CompMax,S_CompMax_Numeric,S_Result);
            If  (S_Numeric >= S_CompMin_Numeric) And
                (S_Numeric <= S_CompMax_Numeric) Then
                S_Matched := True;
            End
        Else
            Begin
            If  (S_EditStr >= S_CompMin) And
                (S_EditStr <= S_CompMax) Then
                S_Matched := True;
            End;
        End;
    If  S_EndLine Then
        Begin
        S_EndLine := False;
        S_ReadNextRangeRec;
        S_Str_Ptr := S_Str_Ptr - 1;
        Repeat
            S_Str_Ptr := S_Str_Ptr + 1;
        Until S_CurStr[S_Str_Ptr] IN [#39,'\','='];
        If  S_CurStr[S_Str_Ptr] <> #39 Then
            S_CompMin := S_CurStr[S_Str_Ptr];
        End;
    End;

If  S_Matched Then
    Begin
    While Not(S_CurStr[S_Str_Ptr] In ['\','=']) Do
        Begin
        S_Str_Ptr := Pos('\',S_CurStr);
        If  S_Str_Ptr = 0 Then
            S_Str_Ptr := Pos('=',S_CurStr);
        If  S_Str_Ptr = 0 Then
            Begin
            S_ReadNextRangeRec;
            S_Str_Ptr := 1;
            End;
        End;
    If  S_CurStr[S_Str_Ptr] = '=' then
        Begin
        S_ScreenValid := False;
        S_Msg         := Copy(S_CurStr,(S_Str_Ptr+1),Length(S_CurStr));
        End
    Else
        S_Matched := False;
    End
Else
    Begin
    If  S_CurStr[S_Str_Ptr] = '\' then
        Begin
        S_ScreenValid := False;
        S_Msg         := Copy(S_CurStr,(S_Str_Ptr+1),Length(S_CurStr));
        End
    End;
End;



Procedure S_ProcessIf;
Var
End_Loop,
Or_Found,
NOT_Found,
THEN_Found : Boolean;
CompField  : String[16];

Begin
S_CompMin  := '';
S_CompMax  := '';
S_Matched := FALSE;
S_WorkStr     := S_EditStr;
THEN_Found    := False;
S_Skip    := False;
While Not Then_Found do
    Begin
    If  Pos('NOT ',S_CurStr) = 4 Then
        Begin
        S_Str_Ptr    := 8;
        NOT_Found := True;
        End
    Else
        Begin
        S_Str_Ptr    := 4;
        NOT_Found := False;
        End;

    CompField := '';
    While S_CurStr[S_Str_Ptr] <> #39 Do
        Begin
        CompField := CompField + UpCase(S_CurStr[S_Str_Ptr]);
        S_Str_Ptr   := S_Str_Ptr + 1;
        End;

    S_FieldNo := 1;
    S_Matched := False;
    End_Loop  := False;

    While CompField <> S_UpShiftedStr(S_Field^.S_FieldName [S_FieldNo])Do
        Begin
        S_FieldNo := S_FieldNo + 1;
        If  S_FieldNo > S_Indx^.S_Count[S_Num] Then
            Begin
            S_FieldNo := 1;
            End_Loop  := True;
            CompField := '';
            S_Field^.S_FieldName[1]:='';
            End;
        End;

    S_Get_Field_Value(S_FieldNo);

    If  S_Upcase Then
        S_EditStr := S_UpShiftedStr(S_EditStr);

    S_Matched := False;
    End_Loop      := False;
    While Not End_Loop do
        Begin
        Repeat
            S_Find_Min_and_Max;
            If  S_EndLine Then
                Begin
                S_ReadNextRangeRec;
                S_Str_Ptr := Pos(Chr(39),S_CurStr);
                End;
        Until Not(S_EndLine);

        If  ((S_CompMin='THEN') Or (S_CompMin='OR') Or (S_CompMin='AND')) Then
            End_Loop := True;
        If  Not((End_Loop) Or (S_Matched)) Then
            Begin
            If  (S_Field^.S_Type [S_FieldNo] In [0..7,90..97]) Then
                Begin
                S_Numeric   := 0;
                S_CompMin_Numeric := 0;
                S_CompMax_Numeric := 0;
                Val(S_EditStr,S_Numeric,S_Result);
                Val(S_CompMin,S_CompMin_Numeric,S_Result);
                Val(S_CompMax,S_CompMax_Numeric,S_Result);
                If  Not_Found Then
                    Begin
                    If  (S_Numeric < S_CompMin_Numeric) Or
                        (S_Numeric > S_CompMax_Numeric) Then
                        S_Matched := True
                    End
                Else
                    Begin
                    If  (S_Numeric >= S_CompMin_Numeric) And
                        (S_Numeric <= S_CompMax_Numeric) Then
                        S_Matched := True;
                    End;
                End
            Else
                Begin
                If  Not_Found Then
                    Begin
                    If  (S_EditStr < S_CompMin) Or
                        (S_EditStr > S_CompMax) Then
                        S_Matched := True
                    End
                Else
                    Begin
                    If  (S_EditStr >= S_CompMin) And
                        (S_EditStr <= S_CompMax) Then
                        S_Matched := True;
                    End;
                End;
            End;
        End;

    If  S_CompMin = 'AND' Then
        Begin
        If  Not S_Matched Then
            Begin
            Repeat
                S_ReadNextRangeRec;
            Until ((Pos('THEN',S_CurStr) = Length(S_CurStr)-3) Or
                   (Pos('OR',S_CurStr) = Length(S_CurStr)-1));
            If  (Pos('OR',S_CurStr) = Length(S_CurStr)-1) Then
                S_CompMin := 'OR';
            If  (Pos('THEN',S_CurStr) = Length(S_CurStr)-3) Then
                Then_Found := True;
            End
        Else
            S_ReadNextRangeRec;
        End;

    If  S_CompMin = 'OR' Then
        Begin
        If  S_Matched Then
            Repeat
                S_ReadNextRangeRec;
                If  (Pos('THEN',S_CurStr) = Length(S_CurStr)-3) Then
                    Then_Found := True;
            Until Then_Found
        Else
            S_ReadNextRangeRec;
        End;
    If  S_CompMin = 'THEN' Then
        Then_Found := True;
    End;

If  S_Matched Then
    Begin
    S_Matched := False;
    While S_CurStr <> 'ENDIF' Do
        Begin
        S_ReadNextRangeRec;
        If  (Pos('ERROR',S_CurStr) = 4) Then
            Begin
            S_ScreenValid := False;
            S_Msg         := Copy(S_CurStr,9,Length(S_CurStr));
            End;
        If  (Pos('DATE',S_CurStr) = 4) Then
            S_ProcessDate;
        If  S_CurStr = '   SKIP' Then
            S_Skip   := True;
        If  (Pos('IN',S_CurStr) = 4) Then
            Begin
            S_Str_Ptr := 4;
            S_InIf := True;
            S_ProcessIn;
            S_InIf := False;
            End;
        If  (S_ScreenValid = False) Or
            (S_Skip)         Then
            While S_CurStr <> 'ENDIF' Do
                S_ReadNextRangeRec
        End;
    End
Else
    While S_CurStr <> 'ENDIF' Do
        S_ReadNextRangeRec;

S_EditStr := S_WorkStr;
End;


Procedure S_Validate_Location;
Var
WorkStr : String[1];
Begin
S_Upcase      := False;
S_ScreenValid := True;
S_WorkStr     := '';
S_Skip        := False;

With S_Record^ do
    Begin
    While ((S_NextRec > 0) And (S_ScreenValid)) And (Not S_Skip) Do
        Begin
        S_ReadNextRangeRec;
        If  (S_CurStr[1] = 'I') Then
            Begin
            If  S_CurStr[2] = 'F' Then
                S_ProcessIf
            Else
                S_ProcessIN;
            End;
        If  S_CurStr [1] = 'U' Then
            Begin
            If  S_CurStr[11] = 'N' Then
                Begin
                S_Upcase := True;
                S_EditStr := S_UpShiftedStr(S_EditStr);
                End
            Else
                Begin
                S_Upcase := False;
                S_EditStr := S_NewStr;
                End;
            End;
        If  (S_CurStr[1] = 'S') Then {Skip if Blank}
            If  S_EditStr = '' Then
                S_NextRec  := 0;
        If  (S_CurStr[3] = 'Q') Then {Required}
            Begin
            If  S_EditStr =  '' Then
                Begin
                WorkStr[0] := #01;
                WorkStr[1] := #39;
                S_Str_Ptr  := Pos(WorkStr,S_CurStr);
                S_ScreenValid := False;
                If  S_Str_Ptr = 0 Then
                    S_Msg := 'This field is required'
                Else
                    S_Msg := Copy(S_CurStr,(S_Str_Ptr+1),Length(S_CurStr)-S_Str_Ptr);
                End;
            End;
        If  S_CurStr[1] = 'D' Then {Date}
            S_ProcessDate;
        End;
    End;
End;



Procedure S_ValidateScreen;
Begin
If  S_ValidateField > 0 Then
    S_Point := S_ValidateField
Else
    S_Point := 1;

S_FieldCounter      := 0;
S_RecNo             := 9999;
S_ScreenValid       := True;
S_Validate_Finished := False;
Repeat
    While (S_Field^.S_Type [S_Point] > 9) And
        (S_FieldCounter <= S_Indx^.S_Count[S_Num]) do
        Begin
        S_FieldCounter := S_FieldCounter + 1;
        S_Point := S_Field^.S_Next [S_Point];
        End;
    If  S_Point <= S_Indx^.S_Count[S_Num] then
        Begin
        S_Get_Field_Value(S_Point);
        S_NewStr   := S_EditStr;
        S_NextRec  := S_Field^.S_RangeNextRec  [S_Point];
        S_NextLine := S_Field^.S_RangeNextLine [S_Point];
        S_Validate_Location;
        If  S_ScreenValid  Then
            Begin
            If  S_ValidateField > 0 then
                S_Validate_Finished := True
            Else
                Begin
                S_Point := S_Point + 1;
                S_FieldCounter := S_FieldCounter +1;
                End;
            End
        Else
            S_Validate_Finished := True;
        End
    Else
        S_Validate_Finished := True;

Until (S_Validate_Finished);
S_ChangeScreen := False;
S_PointHold    := S_Point;
S_NewStr       := S_Msg;
S_LoadScreen(S_Indx^.S_Name[S_Num]);
S_Msg          := S_NewStr;
S_Point        := S_PointHold;
S_ChangeScreen := True;
End;


Procedure S_NextKey;
Var
ShowStatusHold : Boolean;
Begin
ShowStatusHold := S_ShowStatus;
S_ShowStatus   := False;
S_GetKey;
S_ShowStatus   := ShowStatusHold;
End;



Procedure S_ReadKey;
Begin
If  S_Indx^.S_Count[S_Num] > 0 Then
    S_FillScreen;
If  S_Msg > '' Then
    S_Wait := True;
S_GetKey;
End;



Procedure S_ReadField;
Var
RealWork   : Real;
S_Result   : Integer;
Testcnt : integer;

Begin

If  S_Indx^.S_Count[S_Num] > 0 Then
    S_FillScreen;

If  (S_Point < 0) Or (S_Point > S_Indx^.S_Count[S_Num]) Then
    Begin
    S_Msg := ' Field number in S_Point is out of range ';
    S_ReadKey;
    Exit;
    End;

If  S_Field^.S_Type[S_Point] > 9 then
    Begin
    S_Msg := ' Cannot read a DISPLAY only field - Any Key To Continue';
    S_Readkey;
    Exit;
    End;

S_PointHold := S_Point;

Repeat
    If  S_Msg > '' Then
        S_Wait := True;

    S_Get_Field_Value(S_Point);

    Repeat
        S_EditString (
            S_Field^.S_Row[S_Point],
            S_Field^.S_Col[S_Point],
            S_Field^.S_Type[S_Point],
            S_Field^.S_Len[S_Point],
            S_Field^.S_PromptFG[S_Point],
            S_Field^.S_PromptBG[S_Point],
            S_Field^.S_DisplayFg[S_Point],
            S_Field^.S_DisplayBg[S_Point],
            S_Field^.S_NormalFg[S_Point],
            S_Field^.S_NormalBg[S_Point],
            S_Field^.S_RangeNextRec[S_Point],
            S_Field^.S_RangeNextLine[S_Point],
            S_EditStr);

            S_Field^.S_DataLen[S_Point] := S_Length(S_EditStr);
            If  S_Field^.S_Type[S_Point] in [0..7,90..97] Then
                Begin
                Val(S_EditStr,RealWork,S_Result);
                Move(RealWork,S_WorkArea^[S_FieldPtr^[S_Point]],6);
                End
            Else
                MOVE(S_EditStr,S_WorkArea^[S_FieldPtr^[S_Point]],
                    S_Field^.S_Len[S_Point] + 1);

        If  S_Tab Then
            S_Fkey := True;

    Until ((S_Enter) or
           (S_PointHold <> S_Point) or
           (S_Fkey));

    S_Point := S_PointHold;

    If  (S_Enter)      Or
        (S_Tab)        Or
        (S_LeftArrow)  Or
        (S_RightArrow) Then
        Begin
        If  (S_Field^.S_RangeNextRec[S_Point] > 0) Then
            Begin
            S_ValidateField := S_Point;
            S_ValidateScreen;
            S_ValidateField := 0;
            If  not S_ScreenValid Then
                S_ResetKeyFlags;
            End
        Else
            If  (Length(S_EditStr) > S_Field^.S_Len[S_Point]) Or (S_Enter) Then
                S_ScreenValid := True;
        End;
Until (S_ScreenValid) Or (S_Fkey);
End;



Procedure S_ReadScreen;
Var
RealWork   : Real;
S_Result   : Integer;

Begin
Case S_Indx^.S_CompiledInd [S_Num] Of
  1,2 : S_ReadKey;
    3 : Begin
        S_ScreenValid   := False;
        S_ValidateField := 0;
        Repeat
            S_FillScreen;

            If  S_Msg > '' Then
                S_Wait := True;

            S_PointHold := 0;

            If  (S_Point > S_Indx^.S_Count[S_Num]) Or
                (S_Point < 1) then
                S_Point := S_Indx^.S_First[S_Num];

            Repeat
                If  S_PointHold <> S_Point then
                    Begin
                    If  S_Field^.S_Type [S_Point] > 9 then
                        Repeat
                            If  S_Direction > 0 then
                                S_Point := S_Field^.S_Next [S_Point];
                            If  S_Direction < 0 then
                                S_Point := S_Field^.S_Prev [S_Point];
                        Until S_Field^.S_Type [S_Point] < 10;
                    S_PointHold := S_Point;
                    S_Get_Field_Value(S_Point);
                    End;
                S_EditString(
                    S_Field^.S_Row[S_Point],
                    S_Field^.S_Col[S_Point],
                    S_Field^.S_Type[S_Point],
                    S_Field^.S_Len[S_Point],
                    S_Field^.S_PromptFG[S_Point],
                    S_Field^.S_PromptBG[S_Point],
                    S_Field^.S_DisplayFg[S_Point],
                    S_Field^.S_DisplayBg[S_Point],
                    S_Field^.S_NormalFg[S_Point],
                    S_Field^.S_NormalBg[S_Point],
                    S_Field^.S_RangeNextRec[S_Point],
                    S_Field^.S_RangeNextLine[S_Point],
                    S_EditStr);

                S_Field^.S_DataLen[S_Point] := S_Length(S_EditStr);

                If  S_Field^.S_Type[S_Point] in [0..7,90..97] Then
                    Begin
                    Val(S_EditStr,RealWork,S_Result);
                    Move(RealWork,S_WorkArea^[S_FieldPtr^[S_Point]],6);
                    End
                Else
                    MOVE(S_EditStr,S_WorkArea^[S_FieldPtr^[S_Point]],
                        S_Field^.S_Len[S_Point] + 1);

                If  S_Tab Then
                    Begin
                    If  S_Shift then
                        S_Direction := - 1
                    Else
                        S_Direction := 1;
                    If  S_Direction > 0 Then
                        S_Point := S_Field^.S_Next[S_Point]
                    Else
                        S_Point := S_Field^.S_Prev[S_Point];
                    End;

            Until ((S_Enter)or(S_Fkey));

            If  S_ENTER then
                S_ValidateScreen;

        Until(S_ScreenValid) OR (S_Fkey);
        End;
    End;{Case of}
S_Point := 0;
End;
