{
  *** You are allowed to copy and distribute this shareware version of
      documentation and software. ***

----------------------------------------------------------------------------


                Runtime Error Detector Unit for TP 6.0


   Runtime Error Detector Unit allows you to detect runtime errors at
   execution time and transfer the control to your error handle routine.
   In your handle routine, you can recover errors or display a friendlier
   error message than Turbo Pascal's "Run-time error mmm at xxxx:yyyy."
   Runtime Error Detector Unit is easy to use. All you have to do is
   just to place the RED_BEGIN procedure to start checking runtime errors.
   After you passes the procedure, any runtime errors bring you back to
   the RED_BEGIN procedure.
   This software is a shareware. You are allowed to test this software
   for a period of 30 days. If after this 30 days, you would like to
   continue to use it, you are required to register. ( The registration
   fee is $24.95. ) If you register, you will receive the original
   version of Runtime Error Detector Unit and the full source code to
   the unit. The registration form is at the end of this file.
   For your questions and comments, write to :

	Maggie Lok
	16201 S. Figueroa St.220
	Gardena, C.A. 90248-2687
   or
        CompuServe ID# 70334,3333

----------------------------------------------------------------------------

How to Use Runtime Error Detector Unit

   This section explains general implementation of Runtime Error
   Detector Unit.

   Step 1: Declare the "RED" unit in the USES clause. Make the "RED" unit
           the first unit in the USES clause.

   (e.g.)  Uses RED,DOS,CRT;


   Step 2: Place the RED_BEGIN procedure at the place where you want
           to go back to when a runtime error occurs.

           * Any runtime errors before your program executes the
             RED_BEGIN procedure can not be detected.
           * You can place the RED_BEGIN procedure in only one place
             in your program.

   Step 3: Jump to your error handle routine according to a runtime
           error code stored in the RED_CODE variable.

           * RED_CODE is declared as BYTE in the interface section
             of the RED unit.
           * "0" in RED_CODE indicates no runtime error occurred.
           * Usually, it's a good idea to use a CASE statement to
             jump to your error routine.

    (e.g.)
         begin
           RED_Begin;
           Case RED_CODE of
           0: ( Jump to your normal routine )
           1: ( Error handle routine for runtime error code 1 )
           2: ( Error handle routine for runtime error code 2 )
           3: ( Error handle routine for runtime error code 3 )
            .
            .
            .
           255: ( Error handle routine for runtime error code 255 )
         end;

   Step 4: Reset RED_CODE to 0 at the end of each error handle routine.

    (e.g.)
           202:
           begin
             Writeln('Stack-overflow occurred!');
             RED_CODE := 0;  <---- Don't forget this!
           end;

----------------------------------------------------------------------------}
program EX_RED;


{   Comments on EX_RED: Example Program For Runtime Error Detector Unit.

 *  In the main program, you first call RED_BEGIN, which enables
    runtime error checking. The program control goes back to the command
    below RED_BEGIN whenever a runtime error is generated.

 *  The next command, REPEAT, allows you to go back to the menu routine
    after a runtime error is generated.

 *  The CASE statement allows you to branch to an appropriate routine
    according to the value of RED_CODE.

 * In the first iteration of the REPEAT loop, RED_CODE is 0 because
   no runtime error has been generated. So, the program control goes to
   the menu routine.

 * The menu routine asks you which runtime error you want to generate
   and call one of the following procedures:

      procedure Division_by_zero;
      procedure Stack_overflow_error;
      procedure Invalid_pointer_operation;
      procedure Floating_point_overflow;
      procedure User_runtime_error;

 * Those procedures cause a runtime error, which is captured by the RED
   unit, and the program control goes to the next command of RED_BEGIN.
   ( the REPEAT command in this program )

 * This time, RED_CODE has a non-zero value, which is just a runtime error
   code.( To check the meaning of the runtime error code, see "Error
   Messages" in Turbo Pascal 6.0 Programmer's Guide, Appendix A. )

 * The CASE statement chooses an appropriate routine according to the
   value in RED_CODE. Each error handle routine contains
   "RED_CODE := 0;". This lets you go back to the menu routine again.

 * The program will terminate when you choose 'q' in the menu.


}

uses RED,DOS;



procedure Division_by_zero;
var i : integer;
begin
  i := 0;
  i := 5 div i;
end;

procedure Stack_overflow_error;
begin
  Stack_overflow_error;
end;

procedure Invalid_pointer_operation;
var P : Pointer;
begin
  P := nil;
  FreeMem(P,100);
end;

procedure Floating_point_overflow;
var R : real;
begin
  R := 1.0E34;
  R := R * R;
end;

procedure User_runtime_error;
begin
  RunError(255);
end;


var
  Ch : Char;

begin
  RED_Begin;

  repeat
    Case RED_CODE of

    0 : { Menu Routine }
      begin
        Writeln('---------------------------------------------');
        Writeln('Choose a runtime error.');
        Writeln('(A)...Division By Zero');
        Writeln('(B)...Stack overflow error');
        Writeln('(C)...Invalid pointer operation');
        Writeln('(D)...Floating point overflow');
        Writeln('(E)...User runtime error');
        Writeln('(Q)...Quit');
        Writeln('---------------------------------------------');
        readln(Ch);
        Case Ch of
        'a','A' : Division_by_Zero;
        'b','B' : Stack_overflow_error;
        'c','C' : Invalid_pointer_operation;
        'd','D' : Floating_point_overflow;
        'e','E' : User_runtime_error;
        end;
      end;

  200: {Division by zero}
    begin
      Writeln('Division-by-zero occurred!');
      RED_CODE := 0;
    end;

  202: {Stack overflow error}
    begin
      Writeln('Stack-overflow-error occurred!');
      RED_CODE := 0;
    end;

  204: {Invalid pointer operation}
    begin
      Writeln('Invalid-pointer-operation occurred!');
      RED_CODE := 0;
    end;

  205: {Floating point overflow}
    begin
      Writeln('Floating-point-overflow occurred!');
      RED_CODE := 0;
    end;

  255: {User runtime error}
    begin
      Writeln('User-runtime-error occurred! ');
      RED_CODE := 0;
    end;

  else
    begin { Other runtime errors }
      Writeln('This error is not supposed to be generated in');
      Writeln('this example program. :',RED_CODE);
      RED_CODE := 0;
    end;
  end;
  until( Ch = 'q' ) or ( Ch = 'Q' );
end.

=====================================================

<<  Registration Form  >>

   Date: _____/______/______

   Name: ____________________________________________

Company: ____________________________________________

Address: ____________________________________________

         ____________________________________________

   City: _______________ State: ____ Zip: ___________

Please Indicate Disk Size : [  ]3&1/2"  [  ]5&1/4"

Runtime Error Detector Unit for TP6.0      $ 24.95
and the Source Code
Sales Tax (California Residents Only)      $_________

Shipping and Handling
($3.00 U.S.A./$10.00 outside U.S.A.)       $_________

Total                                      $_________

Please mail check or money order to:

	Maggie Lok
	16201 S. Figueroa St. 220
	Gardena, C.A. 90248-2687

---------------------
Document No.TPA5L602 |
=====================================================

