
UNIT FNOBREAK; { FIDO unit to avoid <Pause>, <ctrl-Break>, <ctrl-alt-Del>
                 and <PrtScr> }
 (***************************************************************************

        RELEASE 1.02 - as first contained in the file PRUS101.LZH
                 by Paul Schubert, 2:244/1181.18, GERMANY

               --------------------------------------------
                organized for Fido's PASCAL related echoes
               --------------------------------------------

     06/21/1994 to --/--/---- by Paul Schubert, 2:244/1181.18, GERMANY


           As far as third party copyrights are not violated this
           source code is hereby placed to the public domain. Use
           it whatever way you want, but use AT YOUR OWN RISK.

           In case you should modify the source rather send your
           modifications to the unit's current organizer (see above for
           NM address) than to spread it on your own. This will help to
           keep the unit updated and grant a certain standard to all
           other users as well.

           The unit is currently still under work. So it might greatly
           benefit of your participation.

           Those who contributed to the following piece of source,
           listed in alphabethical order:
        ================================================================
           Paul Schubert
        ================================================================
           YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.

           Credits in your own programs are as welcome as unnecessary.

 ***************************************************************************)

{$I FDEFINE.DEF} { Use the general include file for conditional defines and
                   common compiler directives ... }

                 { ... and set the unit's specific defines aftwerwards. }

{$S-,R-,V-,I-,B-,F-,O-,A+}

INTERFACE

USES   DOS;

FUNCTION  BREAKPRESSED      : BOOLEAN;
FUNCTION  PAUSEPRESSED      : BOOLEAN;
FUNCTION  CTRLALTDELPRESSED : BOOLEAN;
FUNCTION  PRTSCRPRESSED     : BOOLEAN;

PROCEDURE INITKBDVECTORS;
PROCEDURE RESTOREKBDVECTORS;
PROCEDURE PRINTSCREEN;

IMPLEMENTATION

CONST  PAUSEK    : BOOLEAN = FALSE;
       BREAKK    : BOOLEAN = FALSE;
       CTRBRK    : BOOLEAN = FALSE;
       PRTSCK    : BOOLEAN = FALSE;

VAR    EXITSAVE  : POINTER;

{$L FNOBREAK}

PROCEDURE NEWINT09; EXTERNAL;
PROCEDURE NEWINT05; EXTERNAL;
{$F+} { DO NOT !!!! change the position of this compiler directive !!! }
PROCEDURE PRINTSCREEN; EXTERNAL;

PROCEDURE INITKBDVECTORS;    EXTERNAL;
PROCEDURE RESTOREKBDVECTORS; EXTERNAL;

PROCEDURE MYEXIT;
BEGIN
  RESTOREKBDVECTORS;
  MEM[$40:$71] := 0; { BREAK- FLAG RCKSETZEN }
  EXITPROC := EXITSAVE;
END;


FUNCTION  BREAKPRESSED : BOOLEAN;
BEGIN
  BREAKPRESSED := (MEM[$40:$71] <> 0) OR CTRBRK;
  MEM[$40:$71] := 0;
  CTRBRK := FALSE;
END;


FUNCTION  PAUSEPRESSED : BOOLEAN;
BEGIN
  PAUSEPRESSED := PAUSEK;
  PAUSEK := FALSE;
END;


FUNCTION  CTRLALTDELPRESSED : BOOLEAN;
BEGIN
  CTRLALTDELPRESSED := BREAKK;
  BREAKK := FALSE;
END;


FUNCTION  PRTSCRPRESSED : BOOLEAN;
BEGIN
  PRTSCRPRESSED := PRTSCK;
  PRTSCK := FALSE;
END;


BEGIN { MAIN }
  INITKBDVECTORS;
  EXITSAVE := EXITPROC;
  EXITPROC := @MYEXIT;
  MEM[$40:$71] := 0;
END.
