 unit FCHKOS;

 { FIDO unit to detect different OS
 (*************************************************************************)

	 RELEASE 1.00 - as first contained in the file PRUS101.LZH
		by Matthias Tichy, 2:2440/210.14, GERMANY

	       --------------------------------------------
		organized for Fido's PASCAL related echoes
	       --------------------------------------------

     09/11/1994 to --/--/---- by Matthias Tichy, 2:2440/210.14, GERMANY


	   As far as third party copyrights are not violated this
	   source code is hereby placed to the public domain. Use
	   it whatever way you want, but use AT YOUR OWN RISK.

	   In case you should modify the source rather send your
	   modifications to the unit's current organizer (see above for
	   NM address) than to spread it on your own. This will help to
	   keep the unit updated and grant a certain standard to all
	   other users as well.

	   The unit is currently still under work. So it might greatly
	   benefit of your participation.

	   Those who contributed to the following piece of source,
	   listed in alphabethical order:
	================================================================
        Matthias Tichy, Joel Bergen, Andreas Otto ...
	================================================================
	   YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.

	   Credits in your own programs are as welcome as unnecessary.

(***************************************************************************}

{$I FDEFINE.DEF} { Use the general include file for conditional defines and
		   common compiler directives ... }

		 { ... and set the unit's specific defines aftwerwards. }

interface

type
  TWindowsModes = (standard, enhanced);

var
  NebenVersion : Byte;
  HauptVersion : Byte;
  Windows_Mode : TWindowsModes;

function isWindows : boolean;
function isOS2 : boolean;
function isDesqView : boolean;

implementation

uses dos;

var
  R : Registers;

function isWindows : boolean;

begin
  isWindows := false;
  R.AX := $160A;
  intr($2F, R);
  if R.AX = 0 then
    begin
      HauptVersion := R.BH;
      NebenVersion := R.BL;
      case R.CX of
        2 : Windows_Mode := standard;
        3 : Windows_Mode := enhanced;
      end;
      isWindows := true;
    end;
end;

function isOS2 : boolean;

begin
  isOS2 := false;
  if lo(dosVersion) > 10 then
    begin
      isOS2 := true;
      hauptVersion := lo(dosversion) div 10;
      nebenVersion := hi(dosversion);
    end;
end;

function isDesqView : boolean;

{ Source is from Joel Bergen | change by me }

BEGIN
  R.CX := $4445;
  R.DX := $5351;
  R.AX := $2B01;
  INTR($21,R);
  isDesqView := (R.AL<>$0FF);
  IF R.AL<>$0ff THEN
    begin
      NebenVersion := R.BL;
      HauptVersion := R.BH;
    end;
END;

end.

