{$A+,B-,D+,E+,F-,G+,I+,L+,N-,P-,Q-,R-,S+,T-,V-,X+,Y+}

program PrintFilter;

{@ New printfilter }


{ 
	******************************************************************
	*                                                                *
	*     This is a new printfilter for Borland/Turbo Pascal v7.0    *
	*                                                                *
	* The printer settings are configured using printer definition   *
	*	files. These are plain ASCII files which you can easily adapt  *
	*	for your own printer.                                          *
	*	Look at EPSON.FMP for help on the ini file.                    *
	*                                                                *
	*	Written by Fran Moerel & donated to the public domain.         *
	*	If you have any problems or suggestions please contact me      *
	*	on:                                                            *
	*                                                                *
	*		BBS Source Paradise +31-15-621077                            *
	*                                                                *
	*		FidoNet             2:281/912                                *
	*                                                                *
	*		PascalNet           115:3113/0                               *
	*                                                                *
	*		Internet            moerel@nni.nl                            *
	*                                                                *
	*		SnailMail           Fran Moerel                              *
	*												Diepenbrockstraat 210                    *
	*												2625XB DELFT                             *
	*												The Netherlands                          *
	*                                                                *
	******************************************************************


	Options are :
	-------------

			/Tnn             n = Tab Length
			/Pxxxxxxxx.xxx   xxxxxxxx.xxx = printer definition file
			/F$EDNAME        This will put the file name above your listing


	Installation example:
	---------------------
	In the menu option File-Printer Setup enter:

		Filter Path  : The path to the new printfilter (ex.C:\BP7\BIN\PRNFLTR.EXE)

		Command Line : $NOSWAP /T2 /F$EDNAME /PHPLJ.FMP

	The printer definition file will always be fetched out of the directory
	of the PrintFilter Executable.

}

Uses PrintUnt, Toolkit, Dos;

{ Units
	-----

	PrintUnt : FormPrint object - See unit for explanation
	Toolkit  : Collection of handy tools - Not all the functions are used
						 in the printfilter, but perhaps there are some handy routines
						 in there for you.
}


var
	PrintUnit       : PPrintUnit;
	strFileName     : string;
	strToPrint      : string;
	strPrinterType  : string[8];
	intTabLength    : integer;



procedure GetCommands;
{ Get commands }

var
	intParam : integer;
	strParam : string;
	intCode  : integer;

begin
	for intParam := 1 to ParamCount do
	begin
		strParam := ParamStr(intParam);
		if (strParam[1] = '/') or (strParam[1] = '-') then
		begin
			if tlkUpper(strParam[2]) = 'T'
				then Val(Copy(strParam, 3, Length(strParam) - 2), intTabLength, intCode)
			else if tlkUpper(strParam[2]) = 'F'
				then strFileName := Copy(strParam, 3, Length(strParam) - 2)
			else if tlkUpper(strParam[2]) = 'P'
				then strPrinterType := Copy(strParam, 3, Length(strParam) - 2)
			else
			begin
				WriteLn(strParam, 'is an invalid paramameter');
				Halt(1);
			end;
		end
			else
		begin
			WriteLn(strParam, 'is an invalid paramameter');
			Halt(1);
		end;

	end;
end;


procedure Init;
{ Init the program }

var
	strIniDir    : string;
	strSplitDir  : string;
	strSplitName : string;
	strSplitExt  : string;

begin
	{ Get command line parameters }
	intTabLength := 2;
	strFileName := '';
	strPrinterType := 'ASCII';
	GetCommands;

	{ Init the object }
	strIniDir := ParamStr(0);
	FSplit(strIniDir, strSplitDir, strSplitName, strSplitExt);
	strIniDir := strSplitDir;
	PrintUnit := New(PPrintUnit, Init(strIniDir + strPrinterType + '.FMP', BPrintNormal));

	{ Init the document }
	PrintUnit^.SetPageTitle('');
	PrintUnit^.SetHeader(strFileName + ' printed on  - page ',
											 PrintUnit^.Fill('', PrintUnit^.PageWidth));
	PrintUnit^.SetFooter('');
	PrintUnit^.SetBannerFile('');
	PrintUnit^.PrinterInit;

	PrintUnit^.PrinterInit;
end;


procedure Done;
{ Program finished }

begin
	PrintUnit^.PrinterDone;
	Dispose(PrintUnit, Done);
end;


procedure PrintPas(strToDo : string);
{ PrintPas the string using proper formatting }

var
	intTextPos : integer;
	chrToDo    : char;
	bytPos     : byte;
	bolControl : boolean;

begin
	{ Init vars }
	intTextPos := 0;
	bolControl := FALSE;

	with PrintUnit^ do
	begin

		{ Loop through string & check for control codes }
		for bytPos := 1 to Length(strToDo) do
		begin

			{ Save char for processing }
			chrToDo := strToDo[bytPos];

			{ Process it by setting the print style }
			if bolControl then
			begin
				{ Process control code 
					1  -  Whitespace    (space, tab)
					2  -  Comment
					3  -  Reserved word (begin, end, procedure, etc...)
					4  -  Identifier    (Writeln, Reset, etc...)
					5  -  Symbol        (;, :, ., etc...)
					6  -  String        ('string', #32, #$30)
					7  -  Number        (24, $56)
					8  -  Assembler     (asm mov ax,5 end;)}
				if      chrToDo = '1' then Normal
				else if chrToDo = '2' then Italic
				else if chrToDo = '3' then Bold
				else if chrToDo = '4' then Normal
				else if chrToDo = '5' then Normal
				else if chrToDo = '6' then Normal
				else if chrToDo = '7' then Normal
				else if chrToDo = '8' then Bold;

				{ Clear control code }
				bolControl := FALSE;
			end

			{ Set control boolean if needed }
			else if chrToDo = #$1B then bolControl := TRUE

			{ Process TAB char }
			else if chrToDo = #9 then
			begin
				if intTextPos + intTabLength > PageWidth then NewLine;
				Print(Fill(' ', intTabLength));
				Inc(intTextPos, intTabLength);
			end

			{ Process normal char }
			else
			begin
				if intTextPos > PageWidth then 
				begin
					NewLine;
					intTextPos := 0;
				end;
				Print(chrToDo);
				Inc(intTextPos);
			end

		end;

		{ Goto newline }
		NewLine;

	end;

end;


{ Main program }
begin
	Init;

	{ Loop through the text by getting lines out of StdIn }
	repeat
		ReadLn(strToPrint);
		PrintPas(strToPrint);
	until Eof;

	Done;

end.


