{$f+}
Unit Search;

Interface

uses dos;

type action_type = function(fname:string):byte;
     flistptr    = ^flist;
     flist       = record
                     next : flistptr;
                     fname: string;
                   end;

var
  numfilesinlist:integer;
  filelist,
  endoffilelist:flistptr;

procedure searchdirectory(fname:string;
                          action:action_type;
                          filespecs:byte;
                          deldir,recurse:boolean;
                          var evar:byte);

function match(fileset:string):boolean;

procedure deletefilelist;

procedure getfilelist(fileset:string;attribs:byte);

Implementation


procedure searchdirectory(fname:string;
                          action:action_type;
                          filespecs:byte;
                          deldir,recurse:boolean;
                          var evar:byte);

var
  nextdirectory:string;
  tempdirectory:string;
  newfilename  :string;
  currentdta   :searchrec;
  i,j          :integer;

begin
  i:=length(fname);
  while fname[i] <> '\' do
    i:=i-1;

  if recurse then
  begin
      tempdirectory:=copy(fname,1,i) + '*.*';
      findfirst(tempdirectory,anyfile,currentdta);

      while (doserror <> 18) do
        begin
          if ( ( (currentdta.attr and Directory) = Directory )
          and (currentdta.name[1] <> '.'))
          then
            begin
              nextdirectory:=copy(fname,1,i)+
                             currentdta.name+
                             copy(fname,i+1,length(fname)-i);
              searchdirectory(nextdirectory,
                              action,
                              filespecs,
                              deldir,
                              recurse,
                              evar);
            end;
          if evar > 0 then   {if we had an error then keep bailing out!}
             exit;
          findnext(currentdta);
        end;
  end;

  findfirst(fname,filespecs,currentdta);
  if (doserror = 18) then
    begin
     {writeln(fname,' does not exist.');}
     evar:=$FD;
     exit;
    end;

  while (doserror = 0) do
    begin
      if (currentdta.name[1] <> '.') then
        begin
          newfilename:='';
          j:=length(fname);
          while fname[j] <> '\' do
            j:=j-1;
          newfilename:=copy(fname,1,j);
          newfilename:=newfilename+currentdta.name;
          evar:=action(newfilename);
          if (evar <> 0) and (evar <> $FF) then   {if error then bail out!}
            exit;
        end;

      findnext(currentdta);
    end;

   if deldir then
     if length(fname) < 4 then
        writeln('I will not delete the root directory!')
     else
        begin
          {$I-}
          rmdir(copy(fname,1,i-1));
          {$I+}
          if ioresult <> 0 then
             writeln('Unable to remove directory ',copy(fname,1,i-1))
          else
             writeln(copy(fname,1,i-1),' removed');
        end;
end;

function match(fileset:string):boolean;
var
   dirinfo:searchrec;
begin
   findfirst(fileset,anyfile,dirinfo);
   if doserror in [2,3,18] then
      match:=false
   else
      match:=true;
end;

{add a filename to the filelist}
function look4afile(thefilename:string):byte;
var
   tnode:flistptr;
   tname:namestr;
begin
  new(tnode);
  endoffilelist^.next:=tnode;
  with tnode^ do
    begin
      next:=nil;
      fname:=thefilename;
    end;
  if filelist = nil then   {if start of list point filelist to it}
    filelist:=tnode;
  endoffilelist:=tnode;
  numfilesinlist:=numfilesinlist+1;
  look4afile:=$00;
end;

{delete the filelist}
procedure deletefilelist;
var tnode:flistptr;
    tnode2:flistptr;
begin
  tnode:=filelist;
  while tnode <> nil do
    begin
      tnode2:=tnode;
      tnode:=tnode^.next;
      dispose(tnode2);
    end;
  filelist:=nil;
  endoffilelist:=nil;
  numfilesinlist:=0;
end;

{create a list of files on disk from a fileset with wildcards}
procedure getfilelist(fileset:string;attribs:byte);
var
  bailout:byte;
begin
  numfilesinlist:=0;
  filelist:=nil;                {start with no files}
  endoffilelist:=nil;
  searchdirectory(fileset,
                  look4afile,
                  attribs,
                  false,
                  false,
                  bailout);
end;

begin
  {no initialization code needed}
end.
