/******************************************************************************
Header:  POST                             Language:  Turbo C
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:  Provides POST graphics device driver mode values, auto
					detection routine, and installation procedures.
Calling Sequence:  uses POST;
Where Located:  POST HEADER
******************************************************************************/

int huge PostDetect(void);
int PostInstall(void);
void PostSetFont(int font, int size);
void PostSwap(void);

#define ModeCRT		0x80					/* CRT output							*/
#define ModeCOM		0x40					/* serial output					*/
#define ModePRN		0							/* parallel output				*/
#define ModeLAND	0x20					/* landscape, full page		*/
#define ModePORT	0 						/* portrait, full page		*/
#define ModePRO   0x1C    			/* PRO 64000 x 35000    	*/
#define ModeVGA		0x10					/* VGA 640 x 480 					*/
#define ModeEGA		0x08					/* EGA 640 x 350 					*/
#define ModeCGA		0x04					/* CGA 640 x 200 					*/
#define Mode72P   0	        		/* 72 POINT 612 x 792   	*/
#define ModeTOP		0x02					/* upper half page				*/
#define ModeBOT		0x01					/* lower half page				*/
#define ModeCEN   0							/* center               	*/

#define Courier							1		/* Courier Font Number		*/
#define CourierBold					2		/* Courier Bold						*/
#define CourierOblique			3		/* Courier Italic					*/
#define CourierBoldOblique	4		/* Courier Bold Italic		*/
#define Times								5		/* Times Font Number			*/
#define Helvetica						9		/* Helvetica	Font Number	*/
#define Symbol							13	/*	Symbol Font Number		*/

#define TRUE 1
#define FALSE 0
typedef int boolean;

int PostFontNumber = 0;					/* current font						*/
int PostFontSize = 0;						/* current font size			*/
boolean PostInstalled = FALSE;	/* installed flag					*/
int PostMode = 0;								/* current mode						*/
char * PostPath = "                                         \0";
																/* current path						*/
int x[0x1000];									/* force large data area	*/

/******************************************************************************
Function:  PostDetect                     Language:  Turbo C
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:	Driver auto detection routine returns default mode.
					Default mode can be set prior to installation by changing
					PostMode variable contents.
Calling Sequence:	mode = PostDetect;
Where Located:  POST HEADER
Input:	none
Output:	none
Returns:	default graphics mode
******************************************************************************/
int huge PostDetect(void)
{
	return(PostMode);		/* return mode */
};

/******************************************************************************
Function:  PostInstall                    Language:  Turbo C
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:	Installs POST graphics driver using current defaults:
					PostMode and PostPath.  This routine currently halts on
					error detection.
Calling Sequence:		PostMode = current mode;
										PostPath = current path;
										status = PostInstall;
Where Located:  POST HEADER
Input:	none
Output:	none
Returns:	installation status
******************************************************************************/
int PostInstall(void)
{
	int GraphDriver;				/* graphics type */
	int GraphMode;					/* graphics mode */
	int GraphStatus;				/* graphics status */

	GraphDriver = installuserdriver("POST",PostDetect);	/* install */
	GraphStatus = graphresult();												/* get status */
	if (GraphStatus != 0)																/* failed ? */
	{																										/* yes */
		printf("%s\r\n",grapherrormsg(GraphStatus));			/* report */
	}
	else
	{																										/* passed */
		GraphDriver = DETECT;															/* auto detection */
		initgraph(&GraphDriver,&GraphMode,PostPath);			/* initialize */
		GraphStatus = graphresult();											/* get status */
		if (GraphStatus != 0)															/* failed ? */
		{																									/* yes */
			printf("%s\r\n",grapherrormsg(GraphStatus));		/* report */
		};
	};
	PostInstalled = TRUE;															/* enabled */
	return(GraphStatus);															/* okay */
};

/******************************************************************************
Function:  PostSetFont                    Language:  Turbo C
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:	Select new font and size.

					NOTE:  	This procedure only works when current font is the
									system DefaultFont (see SetTextStyle).

Calling Sequence:		PostSetFont(font,size:integer);
Where Located:  POST HEADER
Input:	font:integer - font number
				size:integer - font size
Output:	none
Returns:	none
******************************************************************************/
void PostSetFont(int font, int size)
{
	setusercharsize(font,size,size,0);		/* setup font and point size */
	PostFontNumber = font;								/* save font number */
	PostFontSize = size;									/* save font size */
};

/******************************************************************************
Function:  PostSwap                       Language:  Turbo C
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:	Swap pages between ModeTOP and ModeBOT.
Calling Sequence:	PostSwap;
Where Located:  POST HEADER
Input:	none
Output:	none
Returns:	none
******************************************************************************/
void PostSwap(void)
{
	if ((PostMode & (ModeBOT | ModeTOP)) != 0) cleardevice();
															/* swap two page mode */
};

