PROGRAM PDEMO;
(*----------------------------------------------------------------------------
                 author  : Michael Fiel
                   date  : 10.02.1995
                 version : 1.00
           (C) copyright : Michael Fiel, Vienna 1995

This file is part of library "PicScr", see more information in the file
"PicTrans.Pas".

This is a very simple demonstration for the use of this unit. It will
draw Text on the grafics screen and the copy it into a BMP TIFF and PCX
File.

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!ATTENTION : Use only with a VGA color adapter and 640x480 16 color Mode.!!!!!
!DON'T USE ANY OTHER VIDEO MODES !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Be sure that the EgaVga.BGI is in the current path, BGI drivers are used
only for this demonstration, not for the library itself.

All legal stuff and further explanetions please read in file "PICTRANS.PAS"
enjoy

michael.
----------------------------------------------------------------------------*)
USES
  PicTrans,PicDef, (* Units coming with this file,conaining more infos      *)
  Objects,CRT,Graph; (* standard bp units                                   *)
VAR
  grDriver: Integer;
  grMode: Integer;
  R : TRect;

BEGIN

  (* Initialise Graphics                                                    *)
  grDriver := detect;
  InitGraph(grDriver, grMode,'');

  if (GraphResult <> grOK) then begin
    writeln('Could not initialise grafic mode !');
    writeln('please check path to .bgi driver');
    HALT(1);
  end;

  if ((GetMaxX<>639) and (GetMaxY<>479)) then begin
    MoveTo(0,10);
    OutText('This unit provides support for 640x480 16 colors only !');
    CloseGraph;
  end;

  (* write some text, so that there is something on the picture             *)
  SetColor(RED);
  SetTextStyle(SansSerifFont, HorizDir, 0);
  MoveTo(0,10);
  OutText('This is a demonstration of the FREEWARE library PicScr');
  MoveTo(0,20);
  SetColor(GREEN);
  SetUserCharSize(1, 3, 1, 1);
  OutText('a pascal source libary to save screen parts into a BMP / PCX / TIFF file');
  SetColor(CYAN);
  MoveTo(0,30);
  OutText('pictures will be saved into a file named "PICSCR.XXX"');
  SetColor(YELLOW);
  MoveTo(0,50);
  OutText('PicScr is (C) Copyright Michael Fiel Vienna 1995');

  SetColor(White);
  MoveTo(0,110);
  OutText('press a key to save 3 screen shots');

  readkey;
  (* end of boring stuff                                                    *)

  (* Now that's the part of interrest                                       *)
  R.Assign(0,0,312,90);
  SaveScreen(piBMP,'PICSCR.BMP',R); (* saves a BMP picture into PisScr.BMP  *)

  R.Assign(20,20,467,210);
  SaveScreen(piPCX,'PICSCR.PCX',R); (* saves a PCX picture into PisScr.PCX  *)

  R.Assign(5,5,635,130);
  SaveScreen(piTIFF,'PICSCR.TIF',R); (* saves a TIFF picture into PisScr.TIF*)

  CloseGraph; (* done graphics                                              *)

  writeln('you will find 3 files calles "PICSCR.XXX" with the screen shots.');
  (* THE END                                                                *)

END.