program Install;

uses WObjects,
     WinTypes,
     WinProcs,
     WinDOS,
     Strings,
     GrphFunc,
     DOSFunc,
     InstallC,
     Ctl3D;

{$D PD Install v1.0 by James Pharaoh. This is Public Domain}
{$R install.res}

{ ************************************************************************************************* Special Types }

type
  TPath = Array[0..100] of Char;
  TLine = Array[0..200] of Char;
  TText  = Array[0..50] of Char;

{ ************************************************************************************************* Global var / const }

const
  AppName = 'pdinst11';
  Version = 'v1.1';

const
  White = $00FFFFFF;
  Black = $00000000;

const
  id_Btn_OK     = 1;
  id_Btn_Quit   = 3;
  id_Btn_Help   = 998;
  id_MenuBox    = 5;
  id_DescripBox = 6;

const
  BigTextRgn: TRect = (Left: 60; Top: 10; Right: 628; Bottom: 46);

{ ************************************************************************************************* MenuItem }

type
  PMenuItem = ^TMenuItem;
  TMenuItem = object(TObject)
    Name,
    Description,
    StartDisk,
    ZipName,
    Destination: PChar;
    constructor Init(NewName, NewDescription, NewZipName, NewDestination, NewStartDisk: PChar);
    destructor Done; virtual;
  end;

constructor TMenuItem.Init(NewName, NewDescription, NewZipName, NewDestination, NewStartDisk: PChar);
begin
  Name := StrNew(NewName);
  Description := StrNew(NewDescription);
  StartDisk := StrNew(NewStartDisk);
  ZipName := StrNew(NewZipName);
  Destination := StrNew(NewDestination);
end;

destructor TMenuItem.Done;
begin
  StrDispose(Name);
  StrDispose(Description);
  StrDispose(StartDisk);
  StrDispose(ZipName);
  StrDispose(Destination);
end;

{ ************************************************************************************************* ini File Routines }

function IsFileValid: Boolean; { ------------------------------------------------------------- IsFileValid }
var
  F:     Text;
  FName: TPath;
  Buff,
  Line:  TLine;
  Num:   Integer;
begin
  IsFileValid := False;
  LoadString(HInstance, ini_File_Name, FName, 12);
  FileSearch(Buff, FName, '.\');
  if StrComp(Buff, '') = 0 then Exit;
  Assign(F, FName);
  Reset(F);
    Read(F, Line);
    LoadString(HInstance, inp_Header, Buff, 100);
    Num := StrComp(Buff, Line);
    If num = 0 then IsFileValid := True;
  Close(F);
end;

procedure LoadMenuData(Menu: PCollection; Source, BigText: PChar); { ------------------------- LoadMenuData }
var
  F:            Text;  { The ini File Handle }
  FName:        TPath; { The ini File Name }
  Buff:         TPath;
  Text:         TLine;
  inpItem,
  inpSource,
  inpTitle:     TText;
  PText,
  AName,                               
  ADescription,
  AZipName,
  ADestination,
  AStartDisk:   TLine;
begin
  LoadString(HInstance, inp_Item, inpitem, 50);
  LoadString(HInstance, inp_Source, inpsource, 50);
  LoadString(HInstance, inp_Title, inpTitle, 50);
  LoadString(HInstance, ini_File_Name, Buff, 12);
  StrCopy(BigText, 'PD Install ' + Version);
  Assign(F, Buff);
  Reset(F);
    repeat
    begin
      ReadLn(F, Text);
      if StrComp(Text, inpItem) = 0 then
      begin
        ReadLn(F, AName);
        ReadLn(F, ADescription);
        ReadLn(F, AZipName);
        ReadLn(F, ADestination);
        ReadLn(F, AStartDisk);
        Menu^.Insert(New(PMenuItem, Init(AName, ADescription, AZipName, ADestination, AStartDisk)));
      end;
      if StrComp(Text, inpSource) = 0 then
      begin
        ReadLn(F, Buff);
        StrCopy(Source, Buff);
      end;
      if StrComp(Text, inpTitle) = 0 then
      begin
        ReadLn(F, Buff);
        StrCopy(BigText, Buff);
      end;
    end until EOF(F);
  Close(F);
end;

{ ************************************************************************************************* DestLocationDlg }

type
  PDestLocationDlg = ^TDestLocationDlg;
  TDestLocationDlg = object(T3DDialog)
  end;

type
  SDestLoactionDlg = record
    Input: TPath;
  end;

{ ************************************************************************************************* InstWin }

type
  PInstWin = ^TInstWin;
  TInstWin = object(T3DWindow)
    MenuBox:    PListBox;
    DescripBox: PStatic;
    NewBigText,
    BigText:    TText;
    NewText:    Boolean;
    Dest,
    Source:     TPath;
    Menu:       PCollection;
    BtnInstall: PButton;

    constructor Init;
    destructor  Done; virtual;
    procedure SetupWindow; virtual;
    function  GetClassName: PChar; virtual;
    procedure GetWindowClass(var AWndClass: TWndClass); virtual;
    procedure Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure FillMenu;
    procedure WMControlColor(var Msg: TMessage); virtual wm_First + wm_CtlColor;
    procedure HandleMenuBox(var Msg: TMessage); virtual id_First + id_MenuBox;
    procedure HandleBtn_OK(var Msg: TMessage); virtual id_First + id_Btn_OK;
    procedure HandleBtn_Quit(var Msg: TMessage); virtual id_First + id_Btn_Quit;
    procedure HandleBtn_Help(var Msg: TMessage); virtual id_First + id_Btn_Help;
  end;

constructor TInstWin.Init; { ----------------------------------------------------------------- Init }
var
  Btn: PButton;
  Txt: TText;
  ModPath: Array[0..fsPathName] of Char;
  P: PChar;
begin
  T3DWindow.Init(nil, 'Please Wait. . .');
  with Attr do
  begin
    Style := ws_Caption + ws_SysMenu + ws_MinimizeBox;
    W := 640;
    H := 480;
  end;
  StrCopy(BigText, 'Welcome to PD Install ' + Version);
  Menu := New(PCollection, Init(10, 5));
  LoadMenuData(Menu, Source, NewBigText);
  MenuBox := New(PListBox, Init(@Self, id_MenuBox, 20, 66, 180, 372));
  DescripBox := New(PStatic, Init(@Self, id_DescripBox, 'Select an item from the left and'
                                  +' click Install to begin installation', 230, 66, 388, 322, 100));
  NewText := False;
  BtnInstall := New(PButton, Init(@Self, id_Btn_OK, 'Install', 230, 409, 80, 30, False));
  Btn := New(PButton, Init(@Self, id_Btn_Quit, 'Quit', 315, 409, 80, 30, False));
  Btn := New(PButton, Init(@Self, id_Btn_Help, 'Help', 536, 409, 80, 30, False));

  GetModuleFileName(HInstance, ModPath, SizeOf(ModPath));
  P := ModPath + 2;
  StrCopy(P, Source);
  StrCopy(Source, ModPath);
end;

destructor TInstWin.Done; { ------------------------------------------------------------------ Done }
begin
  WinHelp(HWindow, 'install.hlp', help_Quit, 0);
  T3DWindow.Done;
  Dispose(Menu, Done);
end;

procedure TInstWin.SetupWindow; { ------------------------------------------------------------ SetupWindow }
begin
  T3DWindow.SetupWindow;
  FillMenu;
  SetWindowText(HWindow, 'PD Install ' + Version);
  EnableWindow(BtnInstall^.Hwindow, False);
end;

function TInstWin.GetClassName: PChar; { ----------------------------------------------------- GetClassName }
begin
  GetClassName := 'InstWin';
end;

procedure TInstWin.GetWindowClass(var AWndClass: TWndClass); { ------------------------------- GetWindowClass }
begin
  T3DWindow.GetWindowClass(AWndClass);
  with AWndClass do
  begin
    hIcon := LoadIcon(HInstance, PChar(icon_Install));
    hbrBackground := LtGray_Brush;
  end;
end;

procedure TInstWin.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); { ----------------------- Paint }
const
  Box1: TRect = (Left: 10; Top: 10; Right: 50; Bottom: 46);
  Box2: TRect = (Left: 60; Top: 10; Right: 628; Bottom: 46);
  Box3: TRect = (Left: 62; Top: 12; Right: 630; Bottom: 46);
  Box4: TRect = (Left: 10; Top: 56; Right: 210; Bottom: 448);
  Box5: TRect = (Left: 220; Top: 56; Right: 628; Bottom: 448);
var
  MemFont,
  Font:      HFont;
  MemBkMode: Integer;
begin
  Font := CreateFont(30,0,0,0,fw_Bold,0,0,0,0,0,0, Proof_Quality,0,'Arial');
  MemFont := SelectObject(PaintDC, Font);
  MemBkMode := SetBkMode(PaintDC, Transparent); 
    DrawBox(PaintDC, Box1, bxs_3DEx);
    DrawIcon(PaintDC, 14, 11, LoadIcon(HInstance, PChar(icon_Install)));
    DrawBox(PaintDC, Box2, bxs_3DEx);
    SetTextColor(PaintDC, White);
    DrawText(PaintDC, BigText, -1, Box2, dt_Center or dt_VCenter);
    SetTextColor(PaintDC, Black);
    DrawText(PaintDC, BigText, -1, Box3, dt_Center or dt_VCenter);
  SetBkMode(PaintDC, MemBkMode);
  SelectObject(PaintDC, MemFont);
  DeleteObject(Font);
  DrawBox(PaintDc, Box4, bxs_3DIn);
  DrawBox(PaintDc, Box5, bxs_3DIn);
end;

procedure TInstWin.FillMenu; { --------------------------------------------------------------- FillMenu }
  procedure IntoBox(Item: PMenuItem); far;
  var
    Err: Integer;
  begin
    Err := MenuBox^.AddString(Item^.Name);
  end;
begin
  Menu^.ForEach(@IntoBox);
end;

procedure TInstWin.WMControlColor(var Msg: TMessage); { -------------------------------------- WMControlColor }
begin
  case Msg.LParamHi of
    ctlColor_Static:
      begin
        SetBkMode(Msg.WParam, transparent);
        Msg.Result := GetStockObject(LtGray_Brush);
      end;
  else
    DefWndProc(Msg);
  end;
end;

procedure TInstWin.HandleMenuBox(var Msg: TMessage); { --------------------------------------- HandleMenuBox }
var
  Num:      Integer;
  MenuItem: PMenuItem;
  ItemName,
  Name:     TText;
  function IsNamedItem(MenuItem: PMenuItem): Boolean; far;
  begin
    Num := StrComp(MenuItem^.Name, ItemName);
    if Num = 0 then
      IsNamedItem := True
    else
      IsNamedItem := False;
  end;
begin
  case Msg.lParamHi of
    lbn_SelChange:
      begin
        MenuBox^.GetSelString(ItemName, 50);        { Gets the current string         }
        MenuItem := Menu^.FirstThat(@IsNamedItem);  { Finds it's MenuItem             }
        DescripBox^.SetText(MenuItem^.Description); { And updates the description box }
        EnableWindow(BtnInstall^.Hwindow, True);

        if not NewText then { This block updates the BigText Title if it hasn't already done so }
        begin
          StrCopy(BigText, NewBigText);
          InValidateRect(HWindow, @BigTextRgn, True);
          NewText := True;
        end;
        Num := MenuBox^.GetSelString(Name, 50);
        MenuItem := Menu^.FirstThat(@IsNamedItem);
        StrCopy(Dest, MenuItem^.Destination);
      end;
    lbn_DblClk:
      begin
        HandleBtn_OK(Msg);
      end;
  else
    DefWndProc(Msg);
  end;
end;

procedure TInstWin.HandleBtn_OK(var Msg: TMessage); { ---------------------------------------- HandleBtn_OK }
var
  Dialog:     PDestLocationDlg;
  Trans:      SDestLoactionDlg;
  Edit1:      PEdit;
  DestText,   
  DiskText,
  ZipText,
  StartDisk:  Array[0..200] of Char;
  Decomp:     Array[0..400] of Char;
  MenuItem:   PMenuItem;
  ItemName:   Array[0..50] of Char;
  Error:      Integer;
  SFName,
  FName:      TPath;
  F:          Text;
  Buff,
  InsertDisk: TText;
  RightDisk,
  Continue:   Boolean;
  Result:     Integer;
function IsNamedItem(MenuItem: PMenuItem): Boolean; far;
  var
    Num: Integer;
  begin
    Num := StrComp(MenuItem^.Name, ItemName);
    if Num = 0 then
      IsNamedItem := True
    else
      IsNamedItem := False;
  end;
begin
  if MenuBox^.GetSelIndex >= 0 then
  begin
    Dialog := New(PDestLocationDlg, Init(@Self, PChar(dlg_DestLocation)));
    Dialog^.TransferBuffer := @Trans;
    New(Edit1, InitResource(Dialog, dlg_DestLocation_Input, 100));
    StrCopy(Trans.Input, Dest);
    if Application^.ExecDialog(Dialog) = id_OK then
    begin
      MenuBox^.GetSelString(ItemName, 50);       { Gets the name of the current selection                 }
      MenuItem := Menu^.FirstThat(@IsNamedItem); { Gets the MenuItem containing of then current selection }
      StrCopy(DiskText, MenuItem^.StartDisk);    { Gets StartDisk from the Menu Collectin                 }
      StrCopy(ZipText, MenuItem^.ZipName);       { Gets ZipName   from the Menu Collection                }
      StrCopy(StartDisk, MenuItem^.StartDisk);
      StrCopy(DestText, Trans.Input);

      repeat { This checks for the disk id and that it is correct }
      begin
        RightDisk := False;
        Continue := False;
        FileSearch(SFName, 'pdinst.id', Source);
        if StrComp(SFName, '') <> 0 then
        begin
          FileExpand(FName, SFName);
          Assign(F, FName);
          Reset(F);
            ReadLn(F, Buff);
            if StrComp(Buff, StartDisk) = 0 then
            begin
              RightDisk := True;
              Continue := True;
            end;
          Close(F);
        end;
        if Continue = False then
        begin
          StrCopy(InsertDisk, 'Please insert the disk ');
          StrCat(InsertDisk, StartDisk);
          Result := MessageBox(HWindow, InsertDisk, 'PD Install', mb_OKCancel);
          if Result = id_Cancel then
          begin
            Continue := True;
            RightDisk := False;
          end;
        end;
      end until Continue = True;

      if RightDisk then
      begin
        CreateDir(DestText);
        StrCopy(Decomp, Source);
        StrCat(Decomp, 'pdiunzip.pif -d -o ');
        StrCat(Decomp, Source);
        StrCat(Decomp, ZipText);
        StrCat(Decomp, ' ');
        StrCat(Decomp, DestText);
        WinExec(Decomp, sw_ShowMaximized);
      end;
    end;
  end;
end;

procedure TInstWin.HandleBtn_Quit(var Msg: TMessage); { -------------------------------------- HandleBtn_Quit }
begin
  Done;
end;

procedure TInstWin.HandleBtn_Help(var Msg: TMessage); { -------------------------------------- HandleBtn_Help }
var
  FName: TPath;
begin
  FileSearch(FName, 'install.hlp', Source); { Checks for the existance of INSTALL.HLP }
  if StrComp(FName, '') <> 0 then
    WinHelp(HWindow, 'install.hlp', help_Index, 0) { Displays the help file }
  else { If the help file isn't included, show a quick description anyway }
    begin
      MessageBox(HWindow, 'Click on a selection from the menu on the left of the window, then click OK.'
                     +' To accept the default directory click OK or type in your own. To quit click the'
                     +' abort button', 'Install - Help',mb_OK);
      MessageBox(HWindow, 'PD Install is Public domain. For a full version send a formatted disk (3.5")'
                     +' to: James Pharaoh, Scarab Barn, Marton le Moor, Ripon, N Yorkshire, HG4 5AS, England'
                     +' with ample pstage or e-mail pharaoh@dircon.co.uk', 'Install - About', mb_OK);
    end;
end;

{ ************************************************************************************************* InstApp}

type
  TInstApp = object(T3DApplication)
    procedure InitMainWindow; virtual;
    procedure InitInstance; virtual;
  end;

procedure TInstApp.InitMainWindow; { --------------------------------------------------------- InitMainWindow }
begin
  MainWindow := New(PInstWin, Init);
end;

procedure TInstApp.InitInstance;
begin
  T3DApplication.InitInstance;
  Register3DApp(Name, True, True, True);
end;

{ ************************************************************************************************* Start }

var
  App: TInstApp;
begin
  if IsFileValid then
  begin
    App.Init('Install');
    App.Run;
    App.Done;
  end else
    MessageBox(0, 'Bad Menu File - install.ini must be present and have correct strucutre. See '
                   + 'documentation for more information', 'Install - Error', id_OK);
end.        