program PAvtDemo; { Demo of Avatar level 1 console using Crt routines }
                  { Public Domain.  Author: Gregory P. Smith          }
                  { Modification History:                             }
                  {        12/23/91   Added coordinate checks on all  }
                  {                   Screen Manipluations            }
                  {        08/21/92   Added VT-52 & AdLib support     }
                  {        10/17/92   Changed AVT/0+ to the default   }
                  {                   Terminal.                       }
                  {        01/30/93   Allowed music to finish playing }
                  {                   before exiting.                 }
                  {        04/07/93   Cleaned up and added comments.  }
{$R-,F-,M 4096,4096,4096}

Uses Dos, Crt,
     PAvtIO, PAvtSnd, PAvt150;

{$IFNDEF ST}
{$I DHOOKS.INC -- link in the screen I/O and user hooks. }
{$ENDIF}

function UpStr(s:string): string;
var
  ns : string;
  i : integer;
begin
  for i := 1 to length(s) do
    ns[i] := upcase(s[i]);
  ns[0] := s[0];  { copy the length byte }
  UpStr := ns;
end;

procedure Help(long:boolean);
begin
  Writeln('PAvatar 1.50 Demo -- Copr. 1993 Gregory P. Smith'^M^J);
  Writeln('Usage:  pavtdemo [params] input_file [params]');
  if long then
   begin
     Writeln;
     Writeln(' parameters (may be abbreviated):');
     Writeln('   /AVT1         Emulate a full Avatar level 1 terminal. (*)');
     Writeln('   /ANSI         Emulate an ANSI-BBS terminal. (*)');
     Writeln('   /VT52         Emulate a VT-52 terminal. (*)');
     Writeln('   /SLOW         Slow down emulation for easier viewing.');
     Writeln('   /NOFM         Do NOT use AdLib / SoundBlaster FM music for sounds.');
     Writeln;
     Writeln(' (*) Avatar level 0+ with ANSI-BBS fallback is the default terminal.');
   end
  else Writeln(' type pavtdemo /? for more help');
  halt;
end;

var
  fname : pathstr;  { name of file to display }
  slowdown : byte;  { ms to delay between characters }

procedure ProcessParams;
const
  Prms = '/AVT1/ANSI/SLOW/?/HELP/VT52/NOFM';
var
  t : TerminalType;
  i,p : byte;
begin
  p := paramcount;
  if p = 0 then Help(False);
  t := TermAVT0;   { AVT/0+ with fallback is default }
  slowdown := 0;   { default to full speed }
  while p > 0 do
   begin
     i := pos(UpStr(ParamStr(p)),Prms);
     case i of
       1  : t := TermAVT1;
       6  : t := TermANSI;
       11 : Slowdown := 1; { set to ms between chars. }
       16..18 : Help(True);
       23 : t := TermVT52;
       28 : Use_AdLib := False;
     else
      fname := ParamStr(p);
     end; { case }
     dec(p);
   end; { while }
  SetTerminal(t);
end;  { processed in reverse so that first non-parameter is the filename }

var
  f : file;
  buf : Array[1..1024] of char;
  i,z : word;

BEGIN
  InitUnit;  { Initialize the PAvatar unit }
{$IFNDEF ST}
  Assign(Output,''); Rewrite(Output);
  Assign(Input,''); Reset(Input);
{$ENDIF}
  fname := '';
{$IFNDEF ST}
  SetScrPtr;  { Initialize the video routines (dhooks.inc) }
  SetHooks;   { Initialize the I/O hooks in PAvatar (dhooks.inc) }
{$ENDIF}
  ProcessParams;  { Parse command line parameters }
{$IFNDEF ST}
  FillArea(1,1,80,25,7,' ');  { Clear the screen }
{$ENDIF}
  Set_Sound_Backg(True);  { We want background music }
  Assign(f,fname);
  Reset(f,1);
  repeat  { read and display the file }
    BlockRead(f,buf,1024,z);
    for i := 1 to z do begin
{$IFNDEF ST}
      Delay(slowdown);
{$ENDIF}
      Parse_AVT1(buf[i]);
    end;
  until EOF(f); { end else }
  if Sounds_Left > 0 then begin
    Writeln(' * Allowing music to finish * ');
    Sound_Finish;  { Wait until all music has completed }
  end;
END.
