program TaskList ; { page 571 }
Const Max = 20 ;
type  ListData = string[ Max ] ;
      ListPointer = ^Item ;
      Item = record
                Data: ListData ;
                Next: ListPointer
             end ;
var NullChar: char ;

procedure Initialization( var First: ListPointer ) ;
   begin
      First := nil ;
      NullChar := chr( 0 )
   end ;

procedure ReadData ( var Name : ListData ) ;
   begin
      repeat
         read( Name ) ;
         if length( Name ) > Max
            then write( '<-- too long ' )
      until length( Name ) <= Max
   end ;

procedure FindPrevious( Name: ListData; var PrevElt: ListPointer;
                        First: ListPointer ) ;
   var ListElt: ListPointer ;

   function Done : boolean ;
      begin
         if ListElt = nil
            then Done := true
            else Done := ( Name = ListElt^.Data )
      end ;

   begin
      PrevElt := First ;
      ListElt := PrevElt^.Next
      while Not Done
         do begin
               PrevElt := ListElt ;
               ListElt := PrevElt^.Next
            end
   end ;

procedure AddName( var First: ListPointer ) ;
   var NewItem : ListPointer ;
       OldName : ListData ;

   procedure InsertFirst( NewItem: ListPointer; var First: ListPointer ) ;
      begin
         NewItem^.Next := First ;
         First := NewItem
      end;

   procedure InsertAfterFirst( NewItem, First: ListPointer ) ;
      var PrevElt: ListPointer ;
      begin
         FindPrevious( OldName, PrevElt, First ) ;
         NewItem^.Next := PrevElt^.Next ;
         PrevElt^.Next := NewItem
      end ;

   begin
      New( NewItem ) ;
      write( 'Enter new task=================================================
      write( 'Enter old task which new task should preceed, ' ) ;

