program TaskList;

const Max = 20;   { length of task names }

type ListData = packed array[ 1 .. Max ] of char;
     ListPointer = ^Item;
     Item = record
             Data : ListData;
             Next : ListPointer
            end;

     Pointer Array = array [ 'A'..'Z' ] of ListPointer;

procedure Initialization( var First : PointerArray );
{ This procedure initializes appropriate variables }
   var Index : 'A'..'Z';

   begin
      for Index := 'A' to 'Z'
          do First[ Index ] := Nil
   end { Initialization };

procedure ReadData( var Name : ListData );
{This procedure reads a name from the terminal }
   var Index : integer;
   begin
      Index := 1;
      while ( Index <= Max ) and not Eoln
         do begin
            read( Name[ Index ] );
            Index := Index + 1
         end;
      readln;
      while ( Index <= Max )
         do begin
            Name[ Index ] := NullChar;
            Index := Index + 1
         end;
   end { readData };

procedure FindPrevious( Name: ListData; var PrevElt: ListPointer;
                        First: PointerArray );
{This procedure locates the task that comes befire given name on the list.
 If the mane is not found, PrevElt^.Next will be Nil.
 The procedure assures the Name is not the first list element.}


procedure AddName( var First: PointerArray );
{This procedure reads a task name and inserts it into the list}
   var Let1: char;
       NewItem: ListPointer;
       OldName: ListData;

   procedure InsertFirst( NewItem: ListPointer; var First: ListPointer );
   {This procedure inserts the new item at the beginning of the list }

   procedure InsertAfterFirst( NewItem, First: ListPointer );
   {The procedure inserts the new item after the start of the list}

   begin {AddName}
      New( NewItem );
      Write( 'Enter new task: ' );
      ReadData( NewItem^.Data );
      Let1 := NewItem^.Data[1];
      if First[ Let1 ] = Nil
         then InsertFirst( NewItem, First[ Let1 ] )
         else begin
            writeln( 'Enter ols task which new task should proceed, ' );
            write( 'or enter a blank if new task should be palced "last": ');
            ReadData( OldName );
            if OldName = First[ Let1 ]^.Data
               then InsertFirst( NewItem, First[ Let1 ] )
               else InsertAfterFirst( NewItem, First[ Let1 ] )
              end
   end {AddName} ;