{****************************************************************************}
{***********************                              ***********************}
{**                           R-G-B Demonstrator                           **}
{****************************                    ****************************}
{**                       Copyrighted February 12, 1993                    **}
{**                       (C) To Authors                                   **}
{**                             Fernando Padilla                           **}
{**                             Stephen Markham                            **}
{******************************                ******************************}
{****************************************************************************}

uses
     roger,crt;
const
     pause=15;
     base=15;
     top=63;
type
     RGB=(R,RRG,RG,RGG,G,GGB,GB,GBB,B,BBR,BR,BRR,W);

procedure updatergb(a,b,c,d:integer);
begin
     textcolor(1);
     gotoxy(1,1);
      write('Color:');
      writeln(a:14);
     gotoxy(1,3);
      write('RED:');
      writeln(b:16);
     gotoxy(1,4);
      write('GREEN:');
      writeln(c:14);
     gotoxy(1,5);
      write('BLUE:');
      writeln(d:15);
end;

function inverse(a,b:integer):integer;
begin
     inverse:=abs(a-b);
end;

Procedure saycolor(a,b,c,d:integer;  updat:boolean);
begin
     PutColor(a,b,c,d);
     PutColor(a+1,inverse(d,top),inverse(c,top),inverse(d,top));
     if updat then UpdateRGB(a,b,c,d);
end;

Procedure FadeColor(c:RGB;  display:boolean;  var stop:boolean);
var
     i:integer;
  Procedure DoColor(c:RGB;  i:integer;  var display,stop:boolean);
  Begin
       if not stop then
       begin
            Case c of
                 R: SayColor(0,i,0,0,display);
               RRG: SayColor(0,i,i div 2,0,display);
                RG: SayColor(0,i,i,0,display);
               RGG: SayColor(0,i div 2,i,0,display);
                 G: SayColor(0,0,i,0,display);
               GGB: SayColor(0,0,i,i div 2,display);
                GB: SayColor(0,0,i,i,display);
               GBB: SayColor(0,0,i div 2,i,display);
                 B: SayColor(0,0,0,i,display);
               BBR: SayColor(0,i div 2,0,i,display);
                BR: SayColor(0,i,0,i,display);
               BRR: SayColor(0,i,0,i div 2,display);
                 W: SayColor(0,i,i,i,display);
            end;
            delay(pause);
            stop:=keypressed;
       end;
  end;
Begin
     if not stop then
     begin
          For i := base To top Do Docolor(c,i,display,stop);
          For i := top DownTo base Do Docolor(c,i,display,stop);
     end;
end;

procedure control(display:boolean);
var
     palette:rogerrgbpalette;
     color:rgb;
     stop:boolean;
Begin
     store(palette);
     stop:=false;
     Repeat
       for color:=R to W do FadeColor(color,display,stop);
     Until KeyPressed or stop;
     Restore(palette);
End;

begin
     clrscr;
     window(30,11,51,17);
     control(not(pos('false',paramstr(1))>0));
end.