unit polygony;
interface
uses
   Graph,Objects;
type
   TDoint=object
      X,Y:Real;
      Size:Real;
   end;
   PDot=^TDot;
   TDot=object(TObject)
      change                                       ,
      count                                        ,
      color                                        :     Integer;
      was                                          ,
      iss                                          ,
      wlb                                          ,
      slp                                          :     TDoint;
      constsize                                    :     Boolean;

    constructor Init(R,C,Cor,Sez:integer);
      procedure Jump;                                    virtual;
      procedure Bounce;                                  virtual;
      procedure Seet(var A:TDoint);                      virtual;
      procedure Draw;                                    virtual;
      procedure Cycle;                                   virtual;
      procedure Doer;                                    virtual;
      procedure ReNew;                                   virtual;
   end;


   PBall=^TBall;
   TBall=object(TDot)
      procedure Draw;                                    virtual;
   end;


   PBox=^TBox;
   TBox=object(TDot)
      procedure Draw;                                    virtual;
   end;



implementation
{TObject.TDot}
procedure   TDot.ReNew;
begin
   Seet(slp);
   change:=Random(1000)+1;
   count:=0;
   constsize:=(random(2)=1);
end;
procedure   TDot.Doer;
begin
   if count>=change then ReNew;
   Cycle;
   Inc(Count);
end;
procedure   TDot.Cycle;
begin
   Jump;
   Draw;
end;
procedure   TDot.Seet(var A:TDoint);
begin
   a.size:=2*((random(getmaxy div 8)+1)-(getmaxy/16));
   a.x:=2*((random(ABS(Round(a.size)))+1)-(a.size/2));
   a.y:=2*((random(ABS(Round(a.size)))+1)-(a.size/2));
   a.size:=a.size/8;
end;
constructor TDot.Init(R,C,Cor,Sez:Integer);
begin
   inherited Init;
   color:=C;
   change:=100;
   case Cor Mod 4 of
      0: begin
            was.x:=R;          was.y:=R;
         end;
      1: begin
            was.x:=R;          was.y:=getmaxy-R;
         end;
      2: begin
            was.x:=getmaxx-R;  was.y:=getmaxy-R;
         end;
      3: begin
            was.x:=getmaxx-R;  was.y:=R;
         end;
   end;
   was.size:=R;
   iss:=was;
   wlb:=iss;
   constsize:=(sez=1);
   ReNew;
end;
procedure   TDot.Draw;
begin
   PutPixel(Round(was.x),Round(was.y),0);
   PutPixel(Round(iss.x),Round(iss.y),color);
end;
procedure   TDot.Jump;
begin
   was:=iss;
   iss:=wlb;
   wlb.x:=wlb.x+slp.x;
   wlb.y:=wlb.y+slp.y;
   if Not constsize then wlb.size:=wlb.size+slp.size;
   Bounce;
end;
procedure   TDot.Bounce;
   procedure rev(var a:real);
   begin
      a:=-1*a;
   end;
begin
   if (wlb.x<=wlb.size) or (wlb.x>=getmaxx-wlb.size) then
   begin
      wlb.x:=iss.x;
      rev(slp.x);
   end;
   if (wlb.y<=wlb.size) or (wlb.y>=getmaxy-wlb.size) then
   begin
      wlb.y:=iss.y;
      rev(slp.y)
   end;
   if (wlb.size<=1) or (wlb.size>=getmaxy/8) then
   begin
      wlb.size:=iss.size;
      rev(slp.size)
   end;
   if (wlb.x-wlb.size<=0) then
   begin
      wlb.x:=wlb.size+1;
      rev(slp.x)
   end;
   if (wlb.x+wlb.size>=getmaxx) then
   begin
      wlb.x:=getmaxx-wlb.size-1;;
      rev(slp.x);
   end;
   if (wlb.y-wlb.size<=0) then
   begin
      wlb.y:=wlb.size+1;
      rev(slp.y);
   end;
   if (wlb.y+wlb.size>=getmaxy) then
   begin
      wlb.y:=getmaxy-wlb.size-1;
      rev(slp.y);
   end;
end;

{TDot.TBall}
procedure   TBall.Draw;
begin
   setcolor(0);
   circle(Round(was.x),Round(was.y),Round(was.size));
   setcolor(color);
   circle(Round(iss.x),Round(iss.y),Round(iss.size));
end;
{TDot.TBox}
procedure   TBox.Draw;
begin
   with was do
   begin
      setcolor(0);
      Rectangle(Round(x-size),Round(y-size),Round(x+size),Round(y+size));
   end;
   with iss do
   begin
      setcolor(color);
      Rectangle(Round(x-size),Round(y-size),Round(x+size),Round(y+size));
   end;
end;

end.