{****************************************************************************}
{***********************                              ***********************}
{**                           R-G-B Demonstrator                           **}
{****************************                    ****************************}
{**                       Copyrighted February 12, 1993                    **}
{**                       (C) To Authors                                   **}
{**                             Fernando Padilla                           **}
{**                             Stephen Markham                            **}
{******************************                ******************************}
{****************************************************************************}

uses
     roger,crt;
const
     pause=15;
     bottom=0;
     base=15;
     top=63;
type
     pRGB=(R,RRG,RG,RGG,G,GGB,GB,GBB,B,BBR,BR,BRR,W);
     cRGB=record
          color,
          red,
          green,
          blue:byte;
     end;

procedure updatergb(a,b,c,d:integer);
begin
     textcolor(1);
     gotoxy(1,1);
      write('Color:');
      writeln(a:14);
     gotoxy(1,3);
      write('RED:');
      writeln(b:16);
     gotoxy(1,4);
      write('GREEN:');
      writeln(c:14);
     gotoxy(1,5);
      write('BLUE:');
      writeln(d:15);
end;

function inverse(a,b:integer):integer;
begin
     inverse:=abs(a-b);
end;

Procedure saycolor(a,b,c,d:integer;  updat:boolean);
  function rat(percent,high:byte):integer;
  begin
       rat:=trunc(high*(percent/100));
  end;
  function inverse(a,b:integer):integer;
  begin
       inverse:=abs(a-b);
  end;
begin
     PutColor(a,rat(b,top),rat(c,top),rat(d,top));
     PutColor(a+1,inverse(rat(b,top),top),inverse(rat(c,top),top),inverse(rat(d,top),top));
     if updat then UpdateRGB(a,b,c,d);
end;

procedure raise(var c:byte);
begin
     if c<100 then inc(c);
end;

procedure lower(var c:byte);
begin
     if c>0 then dec(c);
end;

Procedure ControlColor(var rgb:crgb;  var stop:boolean;  command:char);
begin
     if not stop then
     begin
          with rgb do case command of
               '7': raise(red);
               '8': raise(green);
               '9': raise(blue);

               '1': lower(red);
               '2': lower(green);
               '3': lower(blue);
               #27: stop:=true;
               else
          end;
     end;
end;


procedure control1(display:boolean);
var
     palette:rogerrgbpalette;
     color:prgb;
     stop:boolean;
  Procedure FadeColor(c:pRGB;  display:boolean;  var stop:boolean);
  var
      i:integer;
    Procedure DoColor(c:pRGB;  i:integer;  var display,stop:boolean);
    Begin
         if not stop then
         begin
              Case c of
                   R: SayColor(0,i,0,0,display);
                 RRG: SayColor(0,i,i div 2,0,display);
                  RG: SayColor(0,i,i,0,display);
                 RGG: SayColor(0,i div 2,i,0,display);
                   G: SayColor(0,0,i,0,display);
                 GGB: SayColor(0,0,i,i div 2,display);
                  GB: SayColor(0,0,i,i,display);
                 GBB: SayColor(0,0,i div 2,i,display);
                   B: SayColor(0,0,0,i,display);
                 BBR: SayColor(0,i div 2,0,i,display);
                  BR: SayColor(0,i,0,i,display);
                 BRR: SayColor(0,i,0,i div 2,display);
                   W: SayColor(0,i,i,i,display);
              end;
              delay(pause);
              stop:=keypressed;
         end;
    end;
  Begin
       if not stop then
       begin
            For i := 0 To 100 Do Docolor(c,i,display,stop);
            For i := 100 DownTo 0 Do Docolor(c,i,display,stop);
       end;
  end;
Begin
     store(palette);
     stop:=false;
     Repeat
       for color:=R to W do FadeColor(color,display,stop);
     Until KeyPressed or stop;
     Restore(palette);
End;

procedure control2(display:boolean);
var
     palette:rogerrgbpalette;
     c:crgb;
     stop:boolean;
Begin
     store(palette);
     stop:=false;
     c.color:=0;
     c.red:=0;
     c.green:=0;
     c.blue:=0;
     Repeat
          controlcolor(c,stop,readkey);
          with c do saycolor(color,red,green,blue,display);
     Until stop;
     Restore(palette);
End;


begin
     clrscr;
     window(30,11,51,17);
     control1(not(pos('false',paramstr(1))>0));
     control2(not(pos('false',paramstr(1))>0));
end.