program problem4at992;
const
     units=['C','T','t','e'];
type
     ingredientrecord=record
        amount:string[10];
        recipe:word;
        egg:boolean;
        ingredient:string[30];
     end;
     fingredientrecord=file of ingredientrecord;
     ratiotype=(half,full,onehalf,double);
var
     serving:word;

function recip(amount:string):word;
var
   code:integer;
   num:word;
begin
   code:=0;
   repeat
      delete(amount,code,1);
      val(amount,num,code);
   until code=0;
   recip:=num;
end;

procedure convert(var ingred:ingredientrecord);
var
   code:integer;
   num:word;
begin
   ingred.egg:=false;
   if pos('/',ingred.amount)=0 then
   begin
      num:=recip(ingred.amount);
      if pos('C',ingred.amount) in [3..5] then ingred.recipe:=num*16*3*16
      else
         if pos('T',ingred.amount) in [3..5] then ingred.recipe:=num*3*16
         else
            if pos('t',ingred.amount) in [3..5] then ingred.recipe:=num*16
            else
               if pos('e',ingred.amount) in [3..5] then
               begin
                  ingred.recipe:=num;
                  ingred.egg:=true;
               end;
   end
   else begin
      if pos('t',ingred.amount)=5 then
      case ingred.amount[3] of
         '2': ingred.recipe:=8;
         '4': ingred.recipe:=4;
         '8': ingred.recipe:=2;
      end
      else case ingred.amount[1] of
         '1': case ingred.amount[3] of
            '2': ingred.recipe:=384;
            '4': ingred.recipe:=192;
         end;
         '2': ingred.recipe:=512;
         '3': ingred.recipe:=576;
      end;
   end;
end;

function ratio(ingred:ingredientrecord;  ration:ratiotype):string;
var
   temps:string;
   tempn:word;
begin
   temps:='';
   if not(ingred.egg) then
   begin
      case ration of
         half: ingred.recipe:=ingred.recipe div 2;
         full: ingred.recipe:=ingred.recipe div 1;
         onehalf: ingred.recipe:=(ingred.recipe*3) div 2;
         double: ingred.recipe:=ingred.recipe*2;
      end;
      case ingred.recipe of
         1: temps:='dash';
         2: temps:='1/8 t';
         3: temps:='scant 1/4 t';
         4: temps:='1/4 t';
         6: temps:='3/8 t';
         8: temps:='1/2 t';
         12: temps:='3/4 t';
         192: temps:='1/4 C';
         256: temps:='1/3 C';
         384: temps:='1/2 C';
         512: temps:='3/2 C';
         864: temps:='1 C+2 T';
         3072: temps:='3/4 C';
         else begin
            if ingred.recipe mod 768=0 then
            begin
               tempn:=ingred.recipe div 768;
               str(tempn,temps);
               temps:=concat(temps,' C');
            end
            else if ingred.recipe mod 384=0 then
               begin
                  tempn:=ingred.recipe div 768;
                  str(tempn,temps);
                  temps:=concat(temps,' 1/2 C');
               end
               else if ingred.recipe mod 256=0 then
                  begin
                     tempn:=ingred.recipe div 768;
                     str(tempn,temps);
                     temps:=concat(temps,' 1/3 C');
                  end
                  else if ingred.recipe mod 48=0 then
                     begin
                        tempn:=ingred.recipe div 48;
                        str(tempn,temps);
                        temps:=concat(temps,' T');
                     end
                     else if ingred.recipe mod 16=0 then
                        begin
                           tempn:=ingred.recipe div 16;
                           str(tempn,temps);
                           temps:=concat(temps,' t');
                        end
                        else if ingred.recipe mod 8=0 then
                           begin
                              tempn:=ingred.recipe div 16;
                              str(tempn,temps);
                              temps:=concat(temps,' 1/2 t');
                           end;
         end;
      end;
   end
   else begin
      case ration of
         half: if ingred.recipe mod 2=0 then tempn:=ingred.recipe div 2
            else tempn:=(ingred.recipe div 2)+1;
         full: tempn:=ingred.recipe;
         onehalf: if (ingred.recipe*3) mod 2=0 then tempn:=(ingred.recipe*3) div 2
            else tempn:=((ingred.recipe*3) div 2)+1;
         double: tempn:=ingred.recipe*2;
      end;
      str(tempn,temps);
      if tempn=1 then temps:=concat(temps,' egg')
      else temps:=concat(temps,' eggs');
   end;
   ratio:=temps;
end;


procedure batchinputingredients(var batchingfile:text;  var batchfile:fingredientrecord);
var
   tempc:char;
   tempr:ingredientrecord;
begin
   repeat
      tempr.amount:='';
      tempr.egg:=false;
      repeat
         read(batchingfile,tempc);
         tempr.amount:=concat(tempr.amount,tempc);
      until tempc in units;
      if tempc='e' then
      begin
         tempr.ingredient:='';
         tempr.egg:=true;
         readln(batchingfile);
      end
      else readln(batchingfile,tempr.ingredient);
      convert(tempr);
      write(batchfile,tempr);
   until eoln(batchingfile);
   readln(batchingfile);
end;

procedure batchinputdata(var batchfile:fingredientrecord;  var constfile:text);
var
   tempn:integer;
   temps:string;
   batchingfile:text;
begin
   assign(batchingfile,'a:p4-data.dat');
   reset(batchingfile);

   readln(batchingfile,temps);
   writeln(constfile,temps);
   readln(batchingfile,temps);
   delete(temps,1,7);
   val(temps,serving,tempn);
   readln(batchingfile);
   batchinputingredients(batchingfile,batchfile);
   repeat
      readln(batchingfile,temps);
      writeln(constfile,temps);
   until eof(batchingfile);

   close(batchingfile);
end;



procedure inputingredients(var batchfile:fingredientrecord);
var
   tempc:char;
   tempr:ingredientrecord;
begin
   repeat
      tempr.amount:='';
      tempr.egg:=false;
      repeat
         read(tempc);
         tempr.amount:=concat(tempr.amount,tempc);
      until tempc in units;
      if tempc='e' then
      begin
         tempr.ingredient:='';
         tempr.egg:=true;
         readln;
      end
      else readln(tempr.ingredient);
      convert(tempr);
      write(batchfile,tempr);
   until eoln;
end;

procedure inputdata(var batchfile:fingredientrecord;  var constfile:text);
var
   temps:string;
begin
   readln(temps);
   writeln(constfile,temps);
   readln(serving);
   readln;
   inputingredients(batchfile);
   repeat
      readln(temps);
      writeln(constfile,temps);
   until eof;
end;

function printserving(ration:ratiotype):string;
var
     ton1:boolean;
     tempn:word;
     temps1,temps2:string;
begin
   ton1:=false;
   case ration of
      half: begin
         tempn:=serving div 2;
         ton1:=not(serving mod 2=0);
      end;
      full: tempn:=serving;
      onehalf: begin
         tempn:=(serving*3) div 2;
         ton1:=not((serving*3) mod 2=0);
      end;
      double: tempn:=serving*2;
   end;
   str(tempn,temps1);
   temps1:=concat('serves ',temps1);
   if ton1 then
   begin
      tempn:=tempn+1;
      str(tempn,temps2);
      temps1:=concat(temps1,' to ',temps2);
   end;
   printserving:=temps1;
end;

procedure output(var constfile:text;  var batchfile:fingredientrecord;  ration:ratiotype);
var
   a:longint;
   tempr:ingredientrecord;
   temps:string;
begin
   reset(constfile);

   readln(constfile,temps);
   writeln(temps);

   writeln(printserving(ration));
   writeln;

   for a:=0 to filesize(batchfile)-1 do
   begin
      seek(batchfile,a);
      read(batchfile,tempr);
      writeln(ratio(tempr,ration),tempr.ingredient);
   end;
   writeln;

   repeat
      readln(constfile,temps);
      writeln(temps);
   until eof(constfile);
   for a:=1 to 66 do
   begin
      write('-');
   end;
   writeln;
end;

procedure control;
var
   batchfile:fingredientrecord;
   constfile:text;
   ration:ratiotype;
begin
   assign(batchfile,'a:tempfil1.dat');
   rewrite(batchfile);
   reset(batchfile);

   assign(constfile,'a:tempfil2.dat');
   rewrite(constfile);

{   inputdata(batchfile,constfile);}
   batchinputdata(batchfile,constfile);
   for ration:=half to double do
   begin
      output(constfile,batchfile,ration);
   end;

   close(batchfile);
   close(constfile);
   erase(batchfile);
   erase(constfile);
end;

begin
   control;
end.