(*********************************
   MUSIC.TPU (C)1993 David A. Bell P.O.Box 620644 Littleton, CO 80162

MUSIC.TPU is a Turbo Pascal unit which adds (surprisingly) music to your
programs.  Used in conjunction with a fundamental knowledge of musical
scores, MUSIC.TPU can add some pretty impressive tunes to your programs.

This file can be compiled using Turbo Pascal to demonstrate the Unit.

There are four procedures.  By using these procedures, you can copy a song
from sheet music directly into your Turbo Pascal program.  The four
procedures are listed and explained below.

     PROCEDURE Tempo(Beats_Per_Minute: integer);
     PROCEDURE Play(Note: string; Duration: real);
     PROCEDURE Rest(Duration: real);
     PROCEDURE Staccato(State: byte);


PROCEDURE Tempo(Beats_Per_Minute: integer);

     This sets the tempo of the song in beats per minute.  The following
     chart lists the major tempos.

          Largo............. 40- 60
          Larghetto......... 60- 66
          Adagio............ 66- 76
          Andante........... 76-108
          Moderato..........108-120
          Allegro...........120-168
          Presto............168-200
          Prestissimo.......200-208

     These are for reference; you can use any tempo you wish.  The higher
     the tempo, the faster the song.  Experiment.  Default = 60.


PROCEDURE Play(Note: string; Duration: real);

       # and b notes
     
     ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABC
     
        -3     -2     -1   MIDDLE   +1     +2     +3   +4

     On the keyboard shown, crude as it is, the gamut runs from A-3 at the
     left (lowest note), to C+4 at the right (highest note).  The variable
     Note is a string and will be passed as 'C+4' or 'G-1', etc.  The middle
     register is represented the same way, but with no '+' or '-'.  Sharp is
     represented as '#' and flat is 'b', for example, 'C+1#' or 'G-2b'.

     Below is a really cheesey ASCII diagram of the bass and treble clef,
     along with their corresponding note values in MUSIC.TPU.

            F+1
                                 E+1
            D+1
                                 C+1
     Treble B+1
                                 A+1
     Clef   G
                                  F
            E
                                  D
                                    C (Middle C)
                                  B
            A
                                 G-1
            F-1
                                 E-1
     Bass   D-1
                                 C-1
     Clef   B-1
                                 A-1
            G-2

     This procedure makes no distinction between, for example, A# and Bb.
     Both produce the same result.  Remember that Ab is the same as G-1#.

     The variable Duration is the length of the note.  It is represented as
     a fraction.  For example, a quarter-note is passed as either 1/4 or
     0.25.  This is handy in determining "dotted" notes.  A dotted half-
     note is simply (1/2) + (1/4), or 0.75.  Remember to use braces
     whenever possible so you don't get unexpected results , such as
     1/(2+1)/4.  Refer to the following chart.

          Two Whole-notes     :  2/1        or 2
          Whole-note          :  1/1        or 1
          Dotted Half-note    :  1/2 + 1/4  or 0.75
          Half-note           :  1/2        or 0.5
          Dotted Quarter-note :  1/4 + 1/8  or 0.375
          Quarter-note        :  1/4        or 0.25
          Dotted Eighth-note  :  1/8 + 1/16 or 0.1875
          Eighth-note         :  1/8        or 0.125
          Et Cetera.

     Duration is a real number so that odd-length notes can be accomodated.
     Triplets, sextuplets and the like are just a matter of division.  A
     triplet quarter-note would be (1/4)/3, and so on.

     In theory, these note durations should rarely be off, and never by
     more than 1/1000 seconds, but theories are just that.  If your tune
     loses or gains a beat please let me know (preferably with the song's
     source-code and sheet music) and I'll dive into it.

-----=====Example=====-----
     A chromatic scale of quarter-notes beginning at Middle C would be:
                    Play('C',1/4);
                    Play('C#',1/4);
                    Play('D',1/4);
                    Play('D#',1/4);
                    Play('E',1/4);
                    Play('F',1/4);
                    Play('F#',1/4);
                    Play('G',1/4);
                    Play('G#',1/4);
                    Play('A+1',1/4);
                    Play('B+1b',1/4);
                    Play('B+1',1/4);
                    Play('C+1',1/4);

     As you can see, a simple song might require a couple-hundred lines of
     code, or more.  Stream-lining will be your pal.

-----=====Important!!!=====-----
     Be advised that these notes cannot be 100% in-tune.  The equal-tempered
     scale is based on a frequency ratio of 122 (twelfth root of two), which
     is about 1.05946.  This procedure outputs the frequency in whole numbers
     and therefore some discrepency will occur, but it should not be more
     than 1/2 Hz.  This will be more noticable at lower frequencies, however,
     most mortals will find this acceptable.  Still, don't try to slip it
     past Andre Watts.

     This also means that attempting to play two notes simultaneously will
     result in an awful discord.  Beware.


PROCEDURE Rest(Duration: real);

     This works the same way as Play, but there is no note value.  You need
     only enter a duration.


PROCEDURE Staccato(State: byte);

     State is either 1 or 0.  1 turns on the staccato, 0 turns it off.  As
     its name implies, it causes the output to be staccato.  Try it.


EXAMPLE PROGRAM
*********************************)

(*** Aria from "The Marriage of Figaro" by Wolfgang Amadeus Mozart ***)

USES MUSIC;

VAR I, J: integer;  {Loop Control}

BEGIN
  Tempo(120);            {Tempo = 120 beats per minute; can adjust}
  J:=0;
 REPEAT
   FOR I:=1 TO 2 DO                       {Play this twice}
     BEGIN
       Play('B+1b',(1/8)+(1/16));         {Dotted Eighth}
       Play('B+1b',1/16);
       Play('G',1/4);
     END;
   Play('B+1b',0.1875);            {Another way to express a Dotted Eighth}
   Play('B+1b',1/16);
   Play('A+1b',1/4);
   Play('F',1/4);
   Rest(1/4);
   FOR I:=1 TO 2 DO
     BEGIN
       Play('A+1b',(1/8)+(1/16));
       Play('A+1b',1/16);
       Play('F',1/4);
     END;
   Play('A+1b',(1/8)+(1/16));
   Play('A+1b',1/16);
   Play('G',1/4);
   Play('Eb',1/4);
   Rest(1/4);
   Staccato(1);         {Staccato on for demonstration}
   Play('Eb',(1/8)+(1/16));
   Play('G',1/16);
   Play('B+1b',1/4);
   Play('G',(1/8)+(1/16));
   Play('B+1b',1/16);
   Play('E+1b',1/4);
   Play('B+1b',(1/8)+(1/16));
   Play('E+1b',1/16);
   Play('G+1',1/4);
   Play('E+1b',1/2);
   Staccato(0);         {Staccato off}
   Play('B+1b',(1/8)+(1/16) );
   Play('E+1b',1/16);
   Play('B+1b',1/4 );
   Play('G',(1/8)+(1/16) );
   Play('B+1b',1/16);
   Play('A+1b',1/4 );
   Play('F',(1/8)+(1/16) );
   Play('B+1b',1/16);
   Play('G',1/4 );
   Play('G',1/16);
   Play('A+1b',1/16);
   Play('B+1b',1/16);
   Play('A+1b',1/16);
   Play('G',1/4 );
   Play('Eb',(1/8)+(1/16) );
   Play('G',1/16);
   Play('B+1b',1/4 );
   Play('G',(1/8)+(1/16) );
   Play('B+1b',1/16);
   Play('E+1b',1/4 );
   Play('B+1b',(1/8)+(1/16) );
   Play('E+1b',1/16);
   Play('G+1',1/4 );
   Play('E+1b',1/2 );
   Play('B+1b',(1/8)+(1/16) );
   Play('E+1b',1/16);
   Play('B+1b',1/4 );
   Play('G',(1/8)+(1/16) );
   Play('B+1b',1/16);
   Play('A+1b',1/4);
   Play('F',(1/8)+(1/16));
   Play('B+1b',1/16);
   Play('Eb',1/4 );
   IF J=0 THEN
     BEGIN
       Play('Eb',(1/8)+(1/16) );
       Play('Eb',1/16);     {Play this ending first time through}
       Play('Eb',1/4 );
     END;
   IF J=1 THEN
     BEGIN
       Play('E+1b',(1/8)+(1/16) );
       Play('E+1b',1/16);   {Play this ending last}
       Play('E+1b',1/4 );
     END;
   J:=J+1;
 UNTIL J=2;
END.

(*********************************

Finally, be careful about copyright infringement.  Almost all songs are
protected in some way, the most notable exceptions being Classical and
Traditional works.

Copyright violation is very nearly as heinous as not contributing $$ for
shareware <grin>.  All contributions appreciated!

Please send comments, suggestions and gnarly source-code to:

     David A. Bell
     Post Office Box 620644
     Littleton, Colorado  80162

Your Zip should have included MUSIC.TPU, MUSICTPU.PAS (this file) and
MUSDEMO.EXE.  If you didn''t receive a complete Zip, send $2.50 for
disk & postage.

Anyone have ideas on volume control?  Please let me know!

Turbo Pascal is a registered trademark of Borland International, Incorporated.

*********************************)
