program MTblTest;

uses
  WinTypes, WinProcs, OWindows, ODialogs, MLBTypes, MLBCtl, Table, Strip, Strings;

{$R TEST.RES}

const
  AppName: PChar = 'Test parent';

const
  Items: array [1..3] of tListItem = ((ItemID: 0; FldName: ''; Caption:'First'; ItemType: ct_String;
                                       Part: 0.4; Align: DT_RIGHT; Wrap:0; Sort: True),
                                      (ItemID: 0; FldName: ''; Caption:'Second'; ItemType: ct_Bitmap;
                                       Part: 0.2; Align: DT_CENTER; Wrap:0; Sort: False),
                                      (ItemID: 0; FldName: ''; Caption: 'Third'; ItemType: ct_String;
                                       Part: 0.4; Align: DT_LEFT; Wrap:0; Sort: False));

  ItList: tItemsList = (ColNumber: 3; Items: @Items);

var
  Bmp: HBitmap;
  CurRecNo:   LongInt;

type
  pTestApp = ^tTestApp;
  tTestApp = object(TApplication)
     procedure InitMainWindow; virtual;
  end;

  pTestTable = ^tTestTable;
  tTestTable = object(tListTable)
    Strip:      pStripDialog;
    procedure   CloseStrip; virtual;
    procedure   CreateStrip(ATitle: PChar; ATotal: Longint); virtual;
    function    GetBmpField(RecNo: LongInt; Index: Word): HBitmap; virtual;
    function    GetRecordCount: Longint; virtual;
    function    GetRecordField(RecNo: LongInt; Index: Word): PChar; virtual;
    function    GetRecordNo: Longint; virtual;
    function    GetRecordWidth: Word; virtual;
    function    GetStrField(RecNo: LongInt; Index: Word): PChar; virtual;
    procedure   NewStrip(Current: LongInt); virtual;
    function    NextRecord: Boolean; virtual;
    function    SkipRecord(dwRecno: Longint): Boolean; virtual;
  end;

  pTestWnd = ^tTestWnd;
  tTestWnd = object(TWindow)
    ListCtl: pMLBCtl;
    constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure SetupWindow; virtual;
    function  GetClassName: PChar; virtual;
    procedure   IDDelete(var Msg: tMessage); virtual id_First + 101;
    procedure   IDAdd(var Msg: tMessage); virtual id_First + 102;
  end;

{ ------------------------------------------------------------------- }

constructor tTestWnd.Init(AParent: PWindowsObject; AName: PChar);
var
  R: TRect;
  i: Integer;
  Comma: PChar;
  Button: pButton;
begin
  inherited Init(AParent, AName);
  SetRect(R, 10, 40, 520, 316);
  ListCtl := New(pMLBCtl, Init(@Self, R, @ItList, $000000, pListTable(New(pTestTable, Init(@ItList)))));
  Button := New(pButton, Init(@Self, 101, 'Delete', 530, 40, 100, 30, False));
  Button := New(pButton, Init(@Self, 102, 'Add...', 530, 80, 100, 30, False));
end;

procedure tTestWnd.SetupWindow;
var
  i: integer;
begin
  inherited SetupWindow;
  SetFocus(ListCtl^.MLBox^.HWindow);
  SendMessage(ListCtl^.MLBox^.HWindow, LB_SETCURSEL, 0, 0);
end;

function tTestWnd.GetClassName: PChar;
begin
  GetClassName := 'TestWindow';
end;

procedure tTestWnd.IDDelete(var Msg: tMessage);
var
  Index : integer;
begin
  index := ListCtl^.MLBox^.GetSelIndex;
  if index <> lb_Err then
    ListCtl^.DeleteItemIndex(index);
end;

procedure tTestWnd.IDAdd(var Msg: tMessage);
var
  Index: integer;
begin
  Inc(CurRecNo);
  ListCtl^.AddItem(CurRecNo, index);
end;

{ TestTable -------------------------------------------------------- }

procedure tTestTable.CreateStrip(ATitle: PChar; ATotal: Longint);
begin
  Strip := pStripDialog(Application^.MakeWindow(New(pStripDialog, Init(Application^.MainWindow, 'STRIP', ATitle, ATotal))));
end;

procedure tTestTable.NewStrip(Current: LongInt);
begin
  if Assigned(Strip) then
    Strip^.DrawNewStrip(Current);
end;

procedure tTestTable.CloseStrip;
begin
  if Assigned(Strip) then
  begin
    Strip^.EndDlg(0);
    Dispose(Strip, Done);
  end;
end;

function tTestTable.GetBmpField;
begin
  GetBmpField := Bmp;
end;

function tTestTable.GetRecordCount;
begin
  GetRecordCount := 50000;
end;

function tTestTable.GetRecordWidth;
begin
  GetRecordWidth := 500;
end;

function tTestTable.GetRecordNo;
begin
  GetRecordNo := CurRecNo;
end;

function tTestTable.NextRecord: Boolean;
begin
  Inc(CurRecNo);
  NextRecord := True;
end;

function tTestTable.GetRecordField(RecNo: LongInt; Index: Word): PChar;
var
  Res: array [0..MaxFieldWidth] of Char;
  Bmp: HBitmap;
  i: word;
begin
  if ItemsList^.Items^[Index].ItemType = ct_String then
  begin
    if ItemsList^.Items^[Index].FldName[0] = #0 then
      (*
       * Get field from decendant
       *)
        StrCopy(Res, GetStrField(RecNo, Index))
    else
    begin
      (*
       * Get field from database
       *)
    end;
  end
  else
  begin
    (*
     * Get Bitmap from decendant
     *)
    Bmp := GetBmpField(RecNo, Index);
    move(Bmp, Res, SizeOf(HBitmap));
  end;
  GetRecordField := Res;
end;

function tTestTable.GetStrField(RecNo: LongInt; Index: Word): PChar;
var
  StrField: array [0..50] of Char;
  Num: array [0..5] of Char;
begin
  StrCopy(StrField, 'Record Number N ');
  Str(RecNo:10, Num);
  StrCat(StrCat(StrField, Num), ', Column number N ');
  Str(Index:10, Num);
  StrCat(StrField, Num);
  GetStrField := StrField;
end;

function tTestTable.SkipRecord;
begin
  SkipRecord := False;
end;

{ Application ------------------------------------------------------- }

procedure tTestApp.InitMainWindow;
begin
  MainWindow := New(pTestWnd, Init(nil, AppName));
end;

{ Body -------------------------------------------------------------- }

var
  TestApp: tTestApp;

begin
  Bmp := LoadBitmap(hInstance, 'BITMAP_1');
  { It was a bug in previous version - intialization was missed for CurRecNo }
  CurRecNo := 1;
  TestApp.Init(AppName);
  TestApp.Run;
  TestApp.Done;
  DeleteObject(Bmp);
end.


