{Map Square Editor}

Uses
  Crt,Dos,Graph,Drivers,Fonts,Mouse,Convert,MouseRs2,Box;

Const
  CGAGREEN = 1;				{CGA mode colors}
  CGARED = 2;
  CGABROWN = 3;

Var
  flag:  BOOLEAN;
  OldExitProc:  POINTER;
  Size,					{size of map squares}
  Color,				{current drawing color}
  x,y,					{cursor location}
  LookX,LookY,
  MaxColor,
  MaxX,MaxY,
  i:  INTEGER;
  Xasp,Yasp:  WORD;

Const
  mt: array[1..5,1..4] of INTEGER = (	{table of prompts}
  (20,150,46,55),			{limits of 'load a file' prompt}
  (20,150,56,65),			{limits of 'choose a color' prompt}
  (20,150,66,75),			{limits of 'hit a key' prompt}
  (20,150,76,85),			{limits of 'quit' prompt}
  (0,160,25,95) );			{limits of entire menu box}

{$F+}
procedure MyExitProc;
begin
  ExitProc := OldExitProc;		{restore exit procedure address}
  CloseGraph;				{exit graphics mode}
end; { MyExitProc }
{$F-}

procedure Abort(Msg : string);
begin
  Writeln(Msg, ': ', GraphErrorMsg(GraphResult));
  Halt(1);
end;

procedure Initialize;
{ Initialize graphics and report any errors that may occur.  Don't forget
  to register the graphics module before calling this routine, i.e.:

  if RegisterBGIdriver(@EGAVGADriverProc) < 0 then
    Abort('EGA/VGA');
   Initialize;
}
var
  i,
  GraphDriver,
  Graphmode:  INTEGER;
begin
  { when using Crt and graphics, turn off Crt's memory-mapped writes }
  DirectVideo := False;
  OldExitProc := ExitProc;		{save previous exit proc}
  ExitProc := @MyExitProc;		{insert our exit in chain}
  GraphDriver := CGA;                     { force CGA graphics }
  GraphMode := CGAC2;
  InitGraph(GraphDriver, GraphMode, '');  { activate graphics }
  i := GraphResult;
  if i <> grOk then begin
    Writeln('Cannot initialize graphics, error #',i:2);
    WriteLn(GraphErrorMsg(i));
    Halt(1);
  end;
  Randomize;                { init random number generator }
  MaxColor := GetMaxColor;  { Get the maximum allowable drawing color }
  MaxX := GetMaxX;          { Get screen resolution values }
  MaxY := GetMaxY;
  GetAspectRatio(Xasp,Yasp);
end; { Initialize }

procedure FileExample;
{ demonstrate selecting a file name }
var
  filename:  STRING;
begin
  filename := '';
  filename := MGetFile('*.exe','Select any file:');
  SetColor(CGAGREEN);
  if filename[0] = #255 then begin	{user aborted}
    OutTextXY(200,100,'Aborted');
  end {if user aborted}
  else begin				{if file name selected...}
    OutTextXY(200,90,'You selected:');
    OutTextXY(200,100,filename);
  end;
  Delay(2000);
  SetFillStyle(SolidFill,0);
  Bar(200,80,319,105);
end; {FileExample procedure}

procedure ChooseExample;
{ demonstration of selecting from a list }
var
  i:  INTEGER;
const
  ColorQues: array[1..3] of STRING = (	{color question choices}
  'Green','Red','Brown');
begin
  i := MouseQuestion(3,'Select a color',@ColorQues);
  SetColor(CGABROWN);
  OutTextXY(200,100,'Your color is: ');
  SetColor(i);
  case i of
    1: OutTextXY(200,110,'Green');
    2: OutTextXY(200,110,'Red');
    3: OutTextXY(200,110,'Brown');
  end; {case}
  Delay(2000);
  SetFillStyle(SolidFill,0);
  Bar(200,90,319,115);
end; {ChooseExample procedure}

procedure HitKeyExample;
{ demonstration of key selection }
var
  c:  CHAR;
begin
  c := MouseReadKey('Hit a key or click mouse');
  SetColor(CGAGREEN);
  if c = #0 then begin			{user clicked the mouse}
    OutTextXY(200,100,'Mouse clicked');
  end
  else begin				{user hit a key}
    OutTextXY(200,100,'"'+c+'" key hit');
  end;
  Delay(2000);
  SetFillStyle(SolidFill,0);
  Bar(200,90,319,105);
end; {HitKeyExample}

begin {Main routine}
  if RegisterBGIdriver(@CGADriverProc) < 0 then
    Abort('CGA');
  Initialize;					{initialize graphics}
  SetTextJustify(CenterText,BottomText);
  OutTextXY(160,10,'CGA Mouse Demonstration');
  OutTextXY(160,20,'by Nels Anderson');
  SetTextJustify(LeftText,BottomText);
  OutlineBox(0,25,160,95,3,2);
  Setcolor(2);
  OutTextXY(20,40,'MENU:');
  Setcolor(0);
  OutTextXY(20,55,'Load a file');		{example of MGetFile}
  OutTextXY(20,65,'Choose a color');		{example of MouseQuestion}
  OutTextXY(20,75,'Hit a key');			{example of MouseReadKey}
  OutTextXY(20,85,'Quit');			{example of MouseYN}

  if MReset = -1 then begin			{see if mouse installed}
    MLimit(0,319-MW,0,199-MH);			{set mouse limits}
    MPut(0,0);					{reset mouse coordinates}
  end;
  Mx := 0; My := 0;				{reset mouse cursor}
  Button := 0;
  GetMem(MCurs,ImageSize(0,0,MW,MH));
  MouseCursorOn(Mx,My,FINGER);
  flag := FALSE;
  repeat					{repeat until quit}
    MStatus(NewButton,NewX,NewY);		{get mouse status}
    if (NewX <> Mx) or (NewY <> My) then begin	{mouse cursor moved!}
      case MouseLocate(NewX,NewY,5,@mt) of
        0: MouseCursor(NewX,NewY,Mx,My,ARROW);	{arrow if outside menu}
        5: MouseCursor(NewX,NewY,Mx,My,HAND);	{hand if not valid selection}
        else MouseCursor(NewX,NewY,Mx,My,FINGER); {valid selection pointed to}
      end; {case}
      Mx := NewX; My := NewY;			{remember new location}
    end;
    if NewButton <> Button then begin		{if button changed...}
      if NewButton > 0 then begin		{if button now down...}
	SetColor(0);
	case MouseLocate(Mx,My,5,@mt) of	{do a command...}
          1: FileExample;			{load a file}
          2: ChooseExample;			{chose a color}
          3: HitKeyExample;			{hit a key}
	  4: flag := MouseYN(100,80,'Quit?');	{quit}
        end; {case}
      end;
    end;
  until flag;
end.
