program StructoApp;

{---------------------------------------------------------------------
Example application for the custom control Structo (Structos.DLL) of
the SMWCC 2.0 Custom Control Pack

Copyright (C) by Sebastian Modersohn

Note: This code file isn't documented into detail. If you have
      questions to *THIS* code file or want to know some details
      please contact me via CompuServe, ID 100340,1474.
---------------------------------------------------------------------}

{$IFNDEF AUTOLOAD}

  You HAVE to compile this program with the global defined symbol "AUTOLOAD" !
  This demonstrates the autoloading feature of the import unit HifiBtn!
{$ENDIF}

{$R StructAp}

uses WinTypes, WinProcs, OWindows, ODialogs, Strings, BWCC,
     {the import unit for the button}
     Structo, StructCo;

{some Id's}
const id_Ex1         =201;
      id_Ex2         =202;

type
  PStructoWindow = ^TStructoWindow;
  TStructoWindow = object(TDlgWindow)
    Ex1, Ex2: PStructo;
    constructor Init(AParent: PWindowsObject; AName: PChar);

    procedure WMMeasureItem(var Msg: TMessage);
      virtual wm_first + wm_MeasureItem;
    procedure WMDrawItem(var Msg: TMessage);
      virtual wm_first + wm_DrawItem;

    procedure Help(var Msg: TMessage);
      virtual id_First + idHelp;
  end;

{App that initializes the main window}
  PStructoApp = ^TStructoApp;
  TStructoApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

{ TStructoWindow }

constructor TStructoWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
  inherited Init(AParent, AName);
  {init the two structos}
  Ex1:=New(PStructo, InitResource(@Self, id_Ex1));
  Ex2:=New(PStructo, InitResource(@Self, id_Ex2));
end;

procedure TStructoWindow.WMMeasureItem(var Msg: TMessage);
var MeasureItemStruct: PMeasureItemStruct;
begin
  MeasureItemStruct:=PMeasureItemStruct(Msg.LParam);
  case MeasureItemStruct^.CtlID of
    id_Ex1, id_Ex2:
      begin
        MeasureItemStruct^.itemHeight := 150;
        MeasureItemStruct^.itemWidth  := 150;
      end;
  end; {case}
end;

procedure tStructoWindow.WMDrawItem(var Msg: TMessage);
var DrawItemStruct:PDrawItemStruct;
    Strg: array[0..4] of Char;

{the paint proc for the first structo; very simple}
procedure PaintStructo;
var x, y: Byte;
begin
  SetTextColor(DrawItemStruct^.hDC, TColorRef(RGB(0, 0, 0)));
  SetBkColor(DrawItemStruct^.hDC, TColorRef(RGB(192, 192, 192)));

  for x:=1 to 10 do
    for y:=1 to 10 do
    begin
      Str(X+Y, Strg);
      TextOut(DrawItemStruct^.hDC, (x-1)*20, (y-1)*20, Strg, StrLen(Strg));
    end;
end;

{the paint proc for the 2nd structo; just for fun}
procedure PaintCurve;
const Zoom = 1;
      k = -20;
var x, y: Integer;
    OldPen, Pen: HPen;
begin
  Pen:=CreatePen(ps_solid, 1, $00000000);
  OldPen:=SelectObject(DrawItemStruct^.hDC, Pen);
  MoveTo(DrawItemStruct^.hDC, 0, DrawItemStruct^.rcItem.bottom div 2);
  LineTo(DrawItemStruct^.hDC, DrawItemStruct^.rcItem.right, DrawItemStruct^.rcItem.bottom div 2);
  MoveTo(DrawItemStruct^.hDC, DrawItemStruct^.rcItem.right div 2, 0);
  LineTo(DrawItemStruct^.hDC, DrawItemStruct^.rcItem.right div 2, DrawItemStruct^.rcItem.bottom);
  SelectObject(DrawItemStruct^.hDC, OldPen);
  DeleteObject(Pen);
  Pen:=CreatePen(ps_solid, 1, $00FF0000);
  OldPen:=SelectObject(DrawItemStruct^.hDC, Pen);
  x:=(-DrawItemStruct^.rcItem.right div 2) div Zoom;
  y:=Trunc(-X/k*(X-(k+2))) * Zoom;
  MoveTo(DrawItemStruct^.hDC, x*Zoom+DrawItemStruct^.rcItem.right div 2, y*-1);
  for x:=(-DrawItemStruct^.rcItem.right div 2) div Zoom +1 to (DrawItemStruct^.rcItem.right div 2) div Zoom do
  begin
    y:=Trunc(-X/k*(X-(k+2))) * Zoom;
    LineTo(DrawItemStruct^.hDC, x*Zoom+DrawItemStruct^.rcItem.right div 2, y*-1+DrawItemStruct^.rcItem.bottom div 2);
  end;
  SelectObject(DrawItemStruct^.hDC, OldPen);
  DeleteObject(Pen);
  Pen:=CreatePen(ps_solid, 1, $0000FF00);
  OldPen:=SelectObject(DrawItemStruct^.hDC, Pen);
  x:=(-DrawItemStruct^.rcItem.right div 2) div Zoom;
  y:=Trunc(X*X/(2*X-2)) * Zoom;
  MoveTo(DrawItemStruct^.hDC, x*Zoom+DrawItemStruct^.rcItem.right div 2, y*-1);
  for x:=(-DrawItemStruct^.rcItem.right div 2) div Zoom +1 to (DrawItemStruct^.rcItem.right div 2) div Zoom do
  begin
    if x<>1 then
    begin
      y:=Trunc(X*X/(2*X-2)) * Zoom;
      LineTo(DrawItemStruct^.hDC, x*Zoom+DrawItemStruct^.rcItem.right div 2, y*-1+DrawItemStruct^.rcItem.bottom div 2);
    end;
  end;
  SelectObject(DrawItemStruct^.hDC, OldPen);
  DeleteObject(Pen);
  Pen:=CreatePen(ps_solid, 1, $000000FF);
  OldPen:=SelectObject(DrawItemStruct^.hDC, Pen);
  x:=(-DrawItemStruct^.rcItem.right div 2) div Zoom;
  y:=Trunc((X+2)*(X+2)/(4*X)) * Zoom;
  MoveTo(DrawItemStruct^.hDC, x*Zoom+DrawItemStruct^.rcItem.right div 2, y*-1);
  for x:=(-DrawItemStruct^.rcItem.right div 2) div Zoom +1 to (DrawItemStruct^.rcItem.right div 2) div Zoom do
  begin
    if x<>0 then
    begin
      y:=Trunc((X+2)*(X+2)/(4*X)) * Zoom;
      LineTo(DrawItemStruct^.hDC, x*Zoom+DrawItemStruct^.rcItem.right div 2, y*-1+DrawItemStruct^.rcItem.bottom div 2);
    end;
  end;
  SelectObject(DrawItemStruct^.hDC, OldPen);
  DeleteObject(Pen);
end;

begin
  DrawItemStruct := PDrawItemStruct(Msg.LParam);
  case DrawItemStruct^.CtlID of
    id_Ex1:
      begin
        if DrawItemStruct^.ItemAction=oda_DrawEntire then
            PaintStructo else DefWndProc(Msg);
      end;
    id_Ex2:
      begin
        if DrawItemStruct^.ItemAction=oda_DrawEntire then
            PaintCurve else DefWndProc(Msg);
      end else DefWndProc(Msg);
  end; {case}
end;

procedure TStructoWindow.Help(var Msg: TMessage);
begin
  WinHelp(HWindow, HelpFile, Help_Context, 200);
end;

{ TStructoApp }

procedure TStructoApp.InitMainWindow;
begin
  MainWindow := New(PStructoWindow, Init(nil, MakeIntResource(100)));
end;

var
  App: TStructoApp;

begin
  App.Init('Structo Demo');
  App.Run;
  App.Done;
end.
