program MenuButton;

{---------------------------------------------------------------------
Example application for the custom control MenuButton (MButtons.DLL) of
the SMWCC 2.0 Custom Control Pack

Copyright (C) by Sebastian Modersohn

Note: This code file isn't documented into detail. If you have
      questions to *THIS* code file or want to know some details
      please contact me via CompuServe, ID 100340,1474.
---------------------------------------------------------------------}

{$IFNDEF AUTOLOAD}

  You HAVE to compile this program with the global defined symbol "AUTOLOAD" !
  This demonstrates the autoloading feature of the import unit MButton!
{$ENDIF}

{$R MBAPP}

uses WinTypes, WinProcs, OWindows, ODialogs, Strings, BWCC,
     {the import unit for the button and its constant unit}
     MButton, MButtonC;

type
  PMButtonWindow = ^TMButtonWindow;
  TMButtonWindow = object(TDlgWindow)
    MB: PMButton;
    constructor Init(AParent: PWindowsObject; AName: PChar);

    procedure SetupWindow; virtual;

    procedure WMCommand(var Msg: TMessage);
      virtual wm_first + wm_Command;

    procedure Help(var Msg: TMessage);
      virtual id_First + idHelp;
  end;

{App thatinitializes the main window}
  PMButtonApp = ^TMButtonApp;
  TMButtonApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

{ TMButtonWindow }

constructor TMButtonWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
  inherited Init(AParent, AName);
  {Inits the Button}
  MB:=New(PMButton, InitResource(@Self, 300));
  {the button is normally disposed by the destructor of the parent}
end;

procedure TMButtonWindow.SetupWindow;
begin
  inherited SetupWindow;
  {configure the menu}
  MB^.AppendItem(100, 'Test&1');
  MB^.AppendItem(101, 'Test&2');
  MB^.AppendSeparator;
  MB^.AppendItem(102, 'Test&3');
  MB^.AppendItem(103, 'Test&4');

  {starts a new row with that item}
  MB^.AppendItemAndRow(104, 'Test&5');
  MB^.AppendItem(105, 'Test&6');
  MB^.AppendSeparator;
  MB^.AppendItem(106, 'Test&7');
  MB^.AppendItem(107, 'Test&8');
end;

procedure TMButtonWindow.WMCommand(var Msg: TMessage);
begin
  {If it is a menu message change buttons text}
  if Msg.lParamHi=0 then
  begin
    case Msg.wParam of
      100: SetWindowText(MB^.HWindow, 'Test&1');
      101: SetWindowText(MB^.HWindow, 'Test&2');
      102: SetWindowText(MB^.HWindow, 'Test&3');
      103: SetWindowText(MB^.HWindow, 'Test&4');
      104: SetWindowText(MB^.HWindow, 'Test&5');
      105: SetWindowText(MB^.HWindow, 'Test&6');
      106: SetWindowText(MB^.HWindow, 'Test&7');
      107: SetWindowText(MB^.HWindow, 'Test&8');
    end;
  end;
  inherited WMCommand(Msg);
end;

procedure TMButtonWindow.Help(var Msg: TMessage);
begin
  WinHelp(HWindow, HelpFile, Help_Context, 100);
end;

{ TMButtonApp }

procedure TMButtonApp.InitMainWindow;
begin
  MainWindow := New(PMButtonWindow, Init(nil, 'dlg_main'));
end;

var
  App: TMButtonApp;

begin
  App.Init('MButton Demo');
  App.Run;
  App.Done;
end.
