(*--------------------------------------------------------------------------*)
(*                 TestSigt --- Test t significance routine                 *)
(*--------------------------------------------------------------------------*)

PROGRAM TestSigt;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*   Program:  TestSigt                                                     *)
(*                                                                          *)
(*   Purpose:  Demonstrate t-significance routine in PIBSIGS.LBR            *)
(*                                                                          *)
(*   Usage:    This program prompts for a t-value and corresponding         *)
(*             degrees of freedom.  It computes and prints both a           *)
(*             one-tailed and a two-tailed significance level for           *)
(*             the given t value.                                           *)
(*                                                                          *)
(*             To stop the program, enter a t value of -99.                 *)
(*                                                                          *)
(*   Calls:    Sigt                                                         *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   t:    REAL;
   Df:   REAL;
   P:    REAL;
   Done: BOOLEAN;

(*$I SIGCONST.PAS *)
(*$I POWTEN.PAS   *)
(*$I LOGTEN.PAS   *)
(*$I ALGAMA.PAS   *)
(*$I CDBETA.PAS   *)
(*$I SIGT.PAS     *)

BEGIN (* TestSigt *)

   Done := FALSE;
   ClrScr;

   REPEAT

      WRITE('Enter t-value and degrees of freedom (-99 to stop): ');
      READLN( t, Df );

      IF ( t > 0.0 ) THEN
         BEGIN
            P     := Sigt( t, Df );
            WRITELN('Two-tailed significance = ',P:8:5);
            WRITELN('One-tailed significance - ',( P / 2.0 ):8:5);
         END
      ELSE
         Done := TRUE;

   UNTIL Done;


END   (* TestSigt *).