procedure Box(TopLeftX,TopLeftY,BottomRightX,BottomRightY:integer;
  boxchar:integer;attr:byte);
var
 i,TLY,BRY:integer;
 tl,tr,bl,br,hl,vl:byte;
 VidFlag          : byte  absolute $0000:$0449;  {type of display}
 ScreenPtr        : integer;
 ScreenCell:integer;
 ScreenChar:byte absolute ScreenCell;
 ScreenAttr:integer absolute ScreenCell;
begin
  ScreenAttr:=attr;
  ScreenAttr:=ScreenAttr shl 8;
  case boxchar of
  256:
    begin
      tl:=218; {top left corner}
      tr:=191; {top right corner}
      bl:=192; {bottom left corner}
      br:=217; {bottom right corner}
      hl:=196; {horizontal line}
      vl:=179; {vertical line}
    end;
  else
    tl:=boxchar; {top left corner}
    tr:=boxchar; {top right corner}
    bl:=boxchar; {bottom left corner}
    br:=boxchar; {bottom right corner}
    hl:=boxchar; {horizontal line}
    vl:=boxchar; {horizontal line}
  end;
  {Type of display determines base of display memory}
  if VidFlag=7 then ScreenPtr:=$B000
  else ScreenPtr := $B800;
  if WaitForRetrace then
   begin
    while (port[$3DA] and $80)=0 do;
    port[$3D8]:=$21;
   end;
  ScreenChar:=tl;
  TopLeftX:=TopLeftX-1;
  TopLeftY:=TopLeftY-1;
  BottomRightX:=BottomRightX-1;
  BottomRightY:=BottomRightY-1;
  TLY:=TopLeftY*80;
  BRY:=BottomRightY*80;
  MemW[ScreenPtr:(TLY+TopleftX) shl 1]:=ScreenCell;
  ScreenChar:=tr;
  MemW[ScreenPtr:(TLY+BottomRightX) shl 1]:=ScreenCell;
  ScreenChar:=bl;
  MemW[ScreenPtr:(BRY+TopLeftX) shl 1]:=ScreenCell;
  ScreenChar:=br;
  MemW[ScreenPtr:(BRY+BottomRightX) shl 1]:=ScreenCell;
  ScreenChar:=hl;
  for i:=TopLeftX+1 to BottomRightX-1 do
    begin
      MemW[ScreenPtr:(TLY+i) shl 1]:=ScreenCell;
      MemW[ScreenPtr:(BRY+i) shl 1]:=ScreenCell;
    end;
  ScreenChar:=vl;
  for i:=TopLeftY+1 to BottomRightY-1 do
    begin
      MemW[ScreenPtr:(i*80+TopLeftX) shl 1]:=ScreenCell;
      MemW[ScreenPtr:(i*80+BottomRightX) shl 1]:=ScreenCell;
    end;
  if WaitForRetrace then
    port[$3D8]:=$29;
end; {Box}

procedure MakeExpandingBox(TopLeftX,TopLeftY,BottomRightX,BottomRightY:byte;
  boxchar:integer;attr:byte;soundeffects:boolean);
var
  x1,x2,y1,y2:integer;
  freq:integer;
  HoldRetrace:boolean;
begin
  HoldRetrace:=WaitForRetrace;
  WaitForRetrace:=false;
  y1:=(TopLeftY+BottomRightY) div 2;
  y2:=y1+1;
  x1:=(TopLeftX+BottomRightX) div 2;
  x2:=x1+1;
  freq:=440;
  while (x1>TopLeftX)
            or
        (x2<BottomRightX)
            or
        (y1>TopLeftY)
            or
        (y2<BottomRightY)
    begin
      if soundeffects then
        begin;
          freq:=freq+freq div 10;
          sound(freq);
        end;
      box(x1,y1,x2,y2,ord(' '),attr);
      if (x1>TopLeftX) then x1:=x1-1;
      if (x2<BottomRightX) then x2:=x2+1;
      if (y1>TopLeftY) then y1:=y1-1;
      if (y2<BottomRightY) then y2:=y2+1;
    end;
  if soundeffects then nosound;
  box(TopLeftX,TopLeftY,BottomRightX,BottomRightY,boxchar,attr);
  WaitForRetrace:=HoldRetrace;
end;

procedure ExplodeBox(TopLeftX,TopLeftY,BottomRightX,BottomRightY:byte;
  boxchar:integer;attr:byte);
begin
  MakeExpandingBox(TopLeftX,TopLeftY,BottomRightX,BottomRightY,
  boxchar,attr,true);
end;

procedure ExpandBox(TopLeftX,TopLeftY,BottomRightX,BottomRightY:byte;
  boxchar:integer; attr:byte);
begin
  MakeExpandingBox(TopLeftX,TopLeftY,BottomRightX,BottomRightY,
  boxchar,attr,false);
end;
