program test_123;
uses
   Line_Collection,
   Unit123;

{*******************************************************************}
procedure TEst_proc;
var
  Err_Code_Overall      : integer;
  Cell_List             : LINE_COLLECTION.PMany_Line_Sort_Collection;
  Cell_Ptr              : LINE_COLLECTION.PStrIntMixed_Record;
  File_Name             : string;
  Read_From_Cells       : boolean; {true=read, false=write!}
  Idx                   : LongInt;
  Err_String            : string;
  Default_Value_For_When_Cell_Not_Exist : string;
  Value                 : string;
  Addr                  : string;
begin
  Err_code_Overall := 0;
  Err_String       := '';
  Default_Value_For_When_Cell_Not_Exist := '0';
  Read_From_Cells  := TRUE;
  File_Name        := 'Test_123.WK1';

  Cell_List  := New (PMany_Line_Sort_Collection, Init (3,3));
  Cell_Ptr   := NIL;

  {*---------------------------------------*}
  {* CELL_PTR : PStrIntMixed_Record        *}
  {*  Line[ ]                              *}
  {*       0 = Which Cell Count 1,2..(reserved)*}
  {*       1 = Cell_Col                    *}
  {*       2 = Cell_Row                    *}
  {*       3 = Cell_Value                  *}
  {*           NOTE: Blanks are NIL        *}
  {*       4 =                             *}
  {*       5 = Cell_Addr (unit123 reserved)*}
  {*           NOTE: Blanks are NIL        *}
  {*  Ints[ ]                              *}
  {*       1 = Err_Code for cell           *}
  {*       2 = IF cell found (123 internal)*}
  {*       3 = Used when writing to file   *}
  {*           contains file position of   *}
  {*           the beginning of cell       *}
  {*---------------------------------------*}
  Cell_Ptr := NEW (PStrIntMixed_Record,
                     Init (Create_Key(Cell_List^.Count+1), '', ''));
  Cell_Ptr^.Set_Data(1, 'A'); {col}
  Cell_Ptr^.Set_Data(2, '1'); {row}
  Cell_List^.Insert (Cell_Ptr);


  Cell_Ptr := NEW (PStrIntMixed_Record,
                     Init (Create_Key(Cell_List^.Count+1), '', ''));
  Cell_Ptr^.Set_Data(1, 'C'); {col}
  Cell_Ptr^.Set_Data(2, '1'); {row}
  Cell_List^.Insert (Cell_Ptr);


  Cell_Ptr := NEW (PStrIntMixed_Record,
                     Init (Create_Key(Cell_List^.Count+1), '', ''));
  Cell_Ptr^.Set_Data(1, 'A'); {col}
  Cell_Ptr^.Set_Data(2, '11'); {row}
  Cell_List^.Insert (Cell_Ptr);

  {*----------------------------------------------------*}
  {* NOTE: if WRITING, you would Set_Data(3, New_Value) *}
  {*----------------------------------------------------*}


  {*--------------------------------------------------*}
  {*  OVERALL Err_Code:                               *}
  {*      -1   : see the Err_String for message       *}
  {*       0   : ok!                                  *}
  {*--------------------------------------------------*}
  {*--------------------------------------------------*}
  {*  Individual Cell Err_Code:                       *}
  {*      -999 : Row+Col Not Found                    *}
  {*      -998 : Row+Col Not supported data type      *}
  {*       0   : everything ok!                       *}
  {*--------------------------------------------------*}
  UNIT123.Find_Lotus_Record (File_Name,
                             Cell_List,
                             Read_From_Cells,
                             Err_Code_Overall,
                             Err_String);

  IF (Err_Code_Overall = 0) THEN
    FOR idx := 0 to (Cell_List^.Count-1) DO
    BEGIN
      Cell_Ptr := PStrIntMixed_Record(Cell_List^.At (idx));

      IF ((Cell_Ptr^.Ints[1]= -999) and (Read_from_Cells)) THEN
        BEGIN
          IF (Default_Value_For_When_Cell_Not_Exist = '')
            THEN Err_String := '123 data '+
                          Cell_Ptr^.Lines[1]^+ Cell_Ptr^.Lines[2]^+
                          ' not found.'
          ELSE
            BEGIN
              Cell_Ptr^.Set_Data(3, Default_Value_For_When_Cell_Not_Exist);
              Cell_Ptr^.Ints[1] := 0; {error override}
            END;
        END

      ELSE IF ((Cell_Ptr^.Ints[1] = -999) and (NOT Read_From_Cells))
        THEN Err_String := '123 data '+
                            Cell_Ptr^.Lines[1]^+ Cell_Ptr^.Lines[2]^+
                          ' not found or BLANK.'

      ELSE IF (Cell_Ptr^.Ints[1] = -998) {stop processing, fatal error}
        THEN Err_String := '123 data '+
                           Cell_Ptr^.Lines[1]^+Cell_Ptr^.Lines[2]^+
                           ' is currently an unsupported type.';

      IF (Cell_Ptr^.Ints[1] <> 0)
        THEN Err_Code_Overall := -1;   {if want ONE failure to kill ALL}

    END; {for}


    IF (Err_Code_Overall = 0)  and (Read_from_Cells) THEN
      FOR idx := 0 to (Cell_List^.Count-1) DO
      BEGIN
        Cell_Ptr := PStrIntMixed_Record(Cell_List^.At (idx));

        Cell_Ptr^.Get_Data(3, Value); {value/handles NIL}
        Cell_Ptr^.Get_Data(5, Addr); {value/handles NIL}

        Writeln (Addr,':',Value);
      END; {for}


  Writeln ('Err_Code_Overall:',Err_Code_Overall);

  {* Clean UP *}
  DISPOSE (Cell_List, DONE);

end; {test_proc}


{*******************************************************************}
{*******************************************************************}
{*******************************************************************}
begin {main}
  Writeln ('------------Test Program----------------------------');
  test_proc;
  Writeln;
  Writeln ('...Normal Termination...');
end. {main}