{$F+,O+}
UNIT Line_COLLECTION;
  {*-------------------------------------------------------------*}
  {* STR(sort) COLLECTION is an example of how to use a sorted   *}
  {* collection on records of strings (it really wants 1 string) *}
  {*-------------------------------------------------------------*}

  {*-------------------------------------------------------------*}
  {* INT(sort) COLLECTION is an example of how to use a sorted   *}
  {* collection on integers (it really wants strings)            *}
  {*-------------------------------------------------------------*}
  {* Simply use the IntSort_Record in place of the Str_Sort      *}
  {* record in the StrSort_Collection.                           *}
  {*-------------------------------------------------------------*}
INTERFACE
USES
   Objects;

CONST  {must be constant to work right}
   GBL_Max_Int_Coll_Str_Lines = 6;
   GBL_Max_Int_Coll_Int_Lines = 7;

TYPE
  PStrSort_Record = ^StrSort_Record;
  StrSort_Record  = object (TObject)
                   {0 = keystr}
     Lines : array [0..GBL_Max_Int_Coll_Str_Lines] of PString;
             {any text string, note MORE fields can be added..}

     constructor Init (Key_Str : string;
                       Str1    : string;
                       Str2    : string);
     destructor Done; virtual;

     procedure Set_Data (Line_Idx : integer; Temp_Str : string);
     procedure Get_Data (Line_Idx : integer; VAR Temp_Str : string);

     procedure Self_Save    (Keep_Blanks : boolean;
                             VAR F: Text;
                             VAR Ok : boolean);
     procedure Self_Restore (VAR F: Text;
                             VAR Ok : boolean);
  end; {StrSort_Record}




  {*---------------------------------------------------------*}
  {* For an integer collection,                              *}
  {* Simply use the IntSort_Record in place of the Str_Sort  *}
  {* record in the StrSort_Collection.                       *}
  {*---------------------------------------------------------*}
  PIntSort_Record = ^IntSort_Record;
  IntSort_Record  = object (StrSort_Record)
     constructor Init (Number : LongInt; Str1, Str2 : string);
     {*-------------------------------------------------------------*}
     {* MUST use decompress to use the 'number' field since it      *}
     {* had to be converted to a string for sorting.......          *}
     {*   and use Create_Key for searches...                        *}
     {*-------------------------------------------------------------*}
     procedure DeCompress (Var Number : LongInt; Var Str1 : string);
  end; {intSort_Record}

  function Create_Key (Number : LongInt) : string;


TYPE
  {*---------------------------------------------------------*}
  {* For an string collection,                               *}
  {* But you want to store INTS as well                      *}
  {* NOTE: Ints not saved in file                            *}
  {*---------------------------------------------------------*}
  PStrIntMixed_Record = ^StrIntMixed_Record;
  StrIntMixed_Record  = object (StrSort_Record)
                   {0 = keystr}
     Ints : array [1..GBL_Max_Int_Coll_Int_Lines] of LongInt;
     constructor Init (Key_Str : string;
                       Str1    : string;
                       Str2    : string);
  end; {StrIntMixed_Record}


  {*---------------------------------------------------------*}
  {* Collection manager for StrSort or IntSort records.      *}
  {*---------------------------------------------------------*}
  PMany_Line_Sort_Collection = ^Many_Line_Sort_Collection;
  Many_Line_Sort_Collection = Object(TStringCollection)
     Which_Field_Is_Key : word;
     constructor init (ALimit, ADelta : integer);
     function KeyOf (item : pointer) : pointer; virtual;
     {*-------------------------------------------------------------*}
     {* MUST not use the 'default' string collection FreeItem since *}
     {* it assumes the record is only a single field!!!!!           *}
     {*-------------------------------------------------------------*}
     procedure FreeItem (Item: pointer) ; virtual;
     procedure Over_Write (Item : pointer);

     procedure Save_To_File      (File_Name       : string;
                                  Keep_Blanks     : boolean;
                                  VAR Ok          : boolean);
     procedure Restore_From_File (File_Name           : string;
                                  Clear_All           : boolean;
                                  VAR Ok              : boolean);
  end; {Many_Line_Sort_Collection}





{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
IMPLEMENTATION
USES
  STR_STF;   {string utilities}

{**********************************************************************}
constructor StrSort_Record.Init (Key_Str, Str1, Str2 : string);
var
  i : integer;
begin
  TObject.Init;
  Lines[0] := OBJECTS.NewStr (Key_Str);
  Lines[1] := OBJECTS.NewStr (Str1);
  Lines[2] := OBJECTS.NewStr (Str2);
  for i := 3 to GBL_Max_Int_Coll_Str_Lines
    do Lines[i] := OBJECTS.NewStr('');
end; {init}

{**********************************************************************}
destructor StrSort_Record.Done;
var
  i : integer;
begin
  for i := 0 to GBL_Max_Int_Coll_Str_Lines
    DO IF (Lines[i] <> Nil)
         THEN OBJECTS.DisposeStr (Lines[i]);
  TObject.Done;
end; {done}

{**********************************************************************}
procedure StrSort_Record.Set_Data (line_idx : integer;
                                   Temp_Str : string);
begin
  if (Line_Idx IN [0..GBL_Max_Int_Coll_Str_Lines]) then
    BEGIN
      IF (Lines[Line_Idx] <> NIL)
        THEN OBJECTS.DisposeStr (Lines[Line_Idx]);
      Lines[Line_Idx] := OBJECTS.NewStr (Temp_Str);
    END;
end; {set_data}

{**********************************************************************}
procedure StrSort_Record.Get_Data (line_idx     : integer;
                                   VAR Temp_Str : string);
begin
  IF ((Line_Idx IN [0..GBL_Max_Int_Coll_Str_Lines]) and
      (Lines[Line_Idx] <> NIL))
    THEN Temp_Str := Lines[Line_Idx]^
    ELSE Temp_Str := '';
end; {get_data}


{**********************************************************************}
procedure StrSort_Record.Self_Save (Keep_Blanks    : boolean;
                                    VAR F: Text;
                                    VAR Ok : boolean);
var
  i : integer;
begin
  {$I-}
  for i := 0 to GBL_Max_Int_Coll_Str_Lines
    DO IF (Lines[i] <> Nil)
         THEN Writeln (F, Lines[i]^)
       ELSE IF (Keep_Blanks)
         THEN Writeln (F);

    Writeln (F, Fill_String(25, '*'));
  {$I+}
  Ok := (IOResult = 0);
end; {self_save}

{**********************************************************************}
procedure StrSort_Record.Self_Restore (VAR F: Text; VAR Ok : boolean);
var
  i : integer;
  Temp_Str : string;
  Record_Done : boolean;
begin
  {$I-}
  Record_Done := FALSE;
  for i := 0 to GBL_Max_Int_Coll_Str_Lines DO
    IF ((NOT Record_Done) AND (NOT (EOF(F)))) THEN
      BEGIN
        ReadLn (F, Temp_Str);
        {*---------------------------------------------------*}
        {* Check if record separator                         *}
        {*---------------------------------------------------*}
        IF ((LENGTH(Temp_Str) > 0) and
            (Temp_Str[1] = '*') and
            (COPY(Temp_Str, 2, 16) <> '***************'))
          THEN Record_Done := TRUE
          ELSE Set_Data(i, Temp_Str);
      END; {if}
  {$I+}
  Ok := (IOResult = 0);
end; {self_restore}


{**********************************************************************}
function Create_Key (Number : LongInt) : string;
begin
  Create_Key := STR_STF.Right_Justify(STR_STF.Int_To_Str(Number), 10);
end; {create_key}

{**********************************************************************}
constructor IntSort_Record.Init (Number : LongInt; Str1, Str2 : string);
begin
  StrSort_Record.Init (Create_Key (Number),
                       Str1,
                       Str2);
end; {init}

{**********************************************************************}
procedure IntSort_Record.DeCompress (var Number : LongInt;
                                     var Str1   : string);
var
  Err_Code   : integer;
  Number_Str : string;
begin
  Get_Data (0, Number_Str); {* get the key numberStr, and convert to int *}
  VAL (Number_Str, Number, Err_Code);

  Get_Data(1, Str1);
end; {decompress}

{**********************************************************************}
constructor StrIntMixed_Record.Init (Key_Str, Str1, Str2 : string);
begin
  StrSort_Record.Init (Key_Str, Str1, Str2);
  FILLCHAR (Ints, SizeOf(Ints), 0);
end; {init}


{**********************************************************************}
constructor Many_Line_Sort_Collection.Init (ALimit, ADelta : integer);
begin
  TStringCollection.Init (ALimit, ADelta);
  Which_Field_Is_Key := 0;
end;{init}


{**********************************************************************}
function Many_Line_Sort_Collection.KeyOf (item : pointer) : pointer;
begin
  KeyOf := PStrSort_Record(Item)^.Lines[Which_Field_Is_Key];
end; {keyof}

{**********************************************************************}
procedure Many_Line_Sort_Collection.Over_Write (item : pointer);
var
  Idx : integer;
  T_Ptr : PStrSort_Record;
begin
  IF (Search(KeyOf(Item), idx)) THEN
    BEGIN
      T_Ptr := PStrSort_Record(At (Idx));
      DISPOSE (T_Ptr, DONE);
      AtPut (Idx, Item)
    END
  ELSE AtInsert (Idx, Item);
end; {over_write}


{**********************************************************************}
procedure Many_Line_Sort_Collection.FreeItem (Item : pointer);
begin
 {  TSortedCollection.FreeItem (Item);  {to avoid MEMORY faults}
 DISPOSE (PStrSort_Record(Item), DONE);
end; {freeitem}

{**********************************************************************}
procedure Many_Line_Sort_Collection.Save_To_File
                            (File_Name       : string;
                             Keep_Blanks     : boolean;
                             VAR Ok          : boolean);
var
  I         : integer;
  File_Ptr  : TEXT;
  Reply     : word;
  Item_Ptr  : PStrSort_Record;
begin
  ASSIGN (File_Ptr, File_Name);
  {$I-} REWRITE (File_Ptr); {$I+}
  Ok := (IOResult = 0);
  IF (ok) THEN
    BEGIN
      FOR i := 0 to Count-1 DO
      BEGIN
        Item_Ptr := At(I);
        IF (Item_Ptr <> Nil)
          THEN Item_Ptr^.Self_Save (Keep_Blanks, File_Ptr, Ok);
      END; {for}
      {$I-} Close (File_Ptr); {$I+}
      Reply := IOResult;  {clear the register}
    END; {if file open}

end; {save_to_file}

{**********************************************************************}
procedure Many_Line_Sort_Collection.Restore_From_File
                            (File_Name           : string;
                             Clear_All           : boolean;
                             VAR Ok              : boolean);
var
  File_Ptr : TEXT;
  Reply     : word;
  Item_Ptr  : PStrSort_Record;
begin
  ASSIGN (File_Ptr, File_Name);
  {$I-} RESet (File_Ptr); {$I+}
  Ok := (IOResult = 0);
  IF (ok) THEN
    BEGIN
      IF ((Clear_All) and (NOT (EOF (File_Ptr))))
        THEN FreeAll; {clear up any in memory}
      WHILE (NOT (EOF (File_Ptr))) DO
      BEGIN
        Item_Ptr := NEW (PStrSort_Record, INIT ('','',''));
        Item_Ptr^.Self_Restore (File_Ptr, Ok);
        Over_Write (Item_Ptr);
      END; {while}
      {$I-} Close (File_Ptr); {$I+}
      Reply := IOResult;  {clear the register}
    END; {if file open}
end; {restore_from_file}

end. {Line_collection}