{************************************************}
{ finished simple example                        }
{************************************************}

program MyProgram;

uses WinTypes, WinProcs, Objects, OWindows, ODialogs;
{$R ListBox3}

const
  cm_Dialog = 105;
  id_ListBox = 101;
  id_Edit = 102;
  id_Button = 103;

type
  TMyApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyDialog =^TMyDialog;
  TMyDialog = Object(TDialog)
      Edit: PEdit;
      ListBox: PListBox;
    Constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure SetUpWindow; virtual;
    procedure GetSelBtn(var Msg: TMessage);
      virtual id_First + id_Button;
  end;

type
  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure CmDialog(var Msg: TMessage);
      virtual cm_First + cm_Dialog;
  end;

{--------------------------------------------------}
{ TMyWindow's method implementations:              }
{--------------------------------------------------}

constructor TMyDialog.Init(AParent: PWindowsObject; AName: PChar);
begin
  TDialog.Init(AParent, AName);
  ListBox := New(PListBox, InitResource(@Self, Id_ListBox));
  Edit := New(PEdit, InitResource(@Self, Id_Edit, 100));
end;

procedure TMyDialog.SetUpWindow;
var
  S: array[0..200] of Char;
  i: Integer;
begin
  TDialog.SetUpWindow;
  for i := 0 to 20 do begin
    WvsPrintF(S, 'Item: %d', i);
    ListBox^.AddString(S);
  end;
end;

procedure TMyDialog.GetSelBtn(var Msg: TMessage);
var
  i: Integer;
  S: array[0..100] of Char;
begin
 { ListBox^.GetSelString(S, 100); Use this in lieu of next 2 calls }
  i :=  ListBox^.GetSelIndex;
  ListBox^.GetString(S, i);
  Edit^.SetText(S);
end;

constructor TMyWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
  TWindow.Init(AParent, AName);
  Attr.Menu := LoadMenu(HInstance, 'Menu_1');
end;

procedure TMyWindow.cmDialog(var Msg: TMessage);
var
  D: PMyDialog;
begin
  D := new(PMyDialog, Init(@Self, 'Dialog_1'));
  Application^.ExecDialog(D);
end;


{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}

procedure TMyApplication.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(nil, 'Sample ObjectWindows Program'));
end;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

var
  MyApp: TMyApplication;

begin
  MyApp.Init('MyProgram');
  MyApp.Run;
  MyApp.Done;
end.
