Unit DemoTab;  {Demonstration for Application Hash Tables}
{$R-,S-,V-}    {See GenTable.Doc for indepth explanations}
               {Simply copy this Unit, changing all Demo }
               {declarations to whatever you want to make}
               {a Hash table for.                        }

INTERFACE

Uses GenTable;

Type
  Demo = Record
          Data : LongInt
        End;

  {NOTE: Potential problems with data records which contain fields }
  {      which are pointers.  There is NO provision for copying any}
  {      data referenced by the pointer -- only the pointer itself }
  {      will be copied into the table.  If you then destroy your  }
  {      "local copy" of the referenced data, it is GONE, and can  }
  {      not be recovered by the entry in the table.  Worse yet,   }
  {      this error is completely undetectable by the table, and it}
  {      will lead to all manner of misleading error messages. Boy }
  {      do I know this one -- I had such an error in a simple     }
  {      80x86 assembler MacroTable which drove me buggy for weeks!}

  DemoTable = Object (HTable)

{ By redefining the following, we can (come as close as possible to)    }
{ impose Data Types on the Generic Hash Table.  It should be noted that }
{ it IS possible to load differing Data Types into the same Hash Table, }
{ provided they have the exact same size.  while this SHOULD present no }
{ problems, it may (possibly) have some interesting uses....            }

                   Constructor Create (MaxEntries : LongInt;
                                       LoadFactor : Word);

                   Function Hash (TheString : String) : Word; Virtual;

                   Procedure Enter (TheKey : String; D : Demo;
                                         Var Duplicate : Boolean);

                   Procedure Retrieve (TheKey : String; Var D : Demo;
                                                    Var Found : Boolean);

                   Procedure UpDate (TheKey : String; NewData : Demo);

                   Destructor Destroy; Virtual;

{ Inherited HTable methods which require no changes }
(*
                   Function Member (Key : String) : Boolean; {Is key in Table?}

                   Function StaticLength : Word; {How many buckets allocated?}

                   Function Empty          : Boolean; {Is Table empty?}
                   Function EntryCount     : Word;    {How many entries?}
                   Function MaxLoad        : Byte;    {Size of largest bucket}
                   Function Buckets_In_Use : Word;    {How many buckets used}
                   Function AverageLoad    : Real;    {Average bucket size}
                   Function LastBucket     : Word;    {Index of last bucket}
                                                      { 1..StaticLength}
                   Procedure Distribution_Report;     {Write certain stats}
                                                      {to the screen}
*)
              End;

IMPLEMENTATION

Constructor DemoTable.Create (MaxEntries : LongInt; LoadFactor : Word);
{ Instantiates a Generic HashTable  }
{ "Typed" for the DemoRec Data Type }
Begin
  HTable.Create (LoadFactor,SizeOf(Demo),MaxEntries)
End;

Function DemoTable.Hash (TheString : String) : Word;
{ If you use a different Hashing function, You MUST ensure }
{ that it returns a value from 0..HTable.StaticLength-1,   }
{ or you guarantee a system crash at some point!!!         }
Begin
  Hash := HTable.Hash(TheString)
End;

Procedure DemoTable.Enter (TheKey : String; D : Demo;
                                  Var Duplicate : Boolean);
{ Enters the data (of type Demo) into the table }
{ if Duplicate, then nothing was entered.       }
Begin
  HTable.Enter (TheKey,D,SizeOf(D),Duplicate)
End;

Procedure DemoTable.Retrieve (TheKey : String; Var D : Demo;
                                              Var Found : Boolean);
{ Retrieves the Demo associated with TheKey. }
{ If Not found, then nothing is done to D -- }
{ If D contained old Data, it still will!    }
Begin
  HTable.Retrieve (TheKey,D,SizeOf(D),Found)
End;

Procedure DemoTable.UpDate (TheKey : String; NewData : Demo);
{ Allows the Data associated with TheKey to be changed }
Begin
  HTable.UpDate (TheKey,NewData,SizeOf(Demo))
End;

Destructor DemoTable.Destroy;
{ Returns every last byte of the table (other then Data Segment }
{ space allocated for the Object variable itself) to the Heap   }
Begin
  HTable.Destroy
End;

BEGIN
{No Initialization Code}
END.