{-----------------------------------------------------------------------------}
{			   TEGL Windows ToolKit II			      }
{		  Copyright (C) 1990, 1992 TEGL Systems Corporation	      }
{			    All Rights Reserved.			      }
{-----------------------------------------------------------------------------}
{$I switches.inc}
{$F-}

Unit stredits;

INTERFACE

uses crt,			{keypress}
     intrpts,
     visual,
     frames,
     fgraph,
     msmouse;

type
   septr = ^serec;
   serec = record
	     nxtptr	: septr;
	     cpos	: word;
	     txtstr	: pointer;
	     maxlen	: word;
	     tcursx	: word;
	     tcursy	: word;
	     color	: word;
	     ms 	: msclickptr;
	     active	: boolean;
	     formevent	: callproc;
	     formeventexit : callproc;
	     highlighted : boolean;
	   end;


procedure DefineStrEditEvent(fs:imagestkptr; x,y,x1,y1,maxlen,color:word;
		       var txtstr:string;
		       formevent,formexit:callproc);

procedure SetStrEdit(fs:ImageStkPtr; ms: MsClickPtr; ncpos:word);

procedure DisplayStrEdit(fs:ImageStkPtr; ms: MsClickPtr);

function getactiveSE(fs:imagestkptr):septr;

IMPLEMENTATION

{$F+}
procedure FreeStrEdit(fs:ImageStkPtr; Userkey:word; Var DataArea);
{$F-}
   var SEP : septr absolute DataArea;
       nse : septr;
       cse : septr;
   begin
      cse := sep;
      while cse<>nil do
	 begin
	    nse := cse^.nxtptr;
	    freemem(cse,sizeof(cse^));
	    cse := nse;
	 end;
   end;

function getactiveSE(fs:imagestkptr):septr;
   var se      : septr;
   begin
      GetUserDataArea(fs,$7000,se);	{get active msclickptr}
      while (se<>nil) and not se^.active do
	 se := se^.nxtptr;

      getactiveSE := se;
   end;

function getSE(fs:imagestkptr; ms:msclickptr):septr;
   var se      : septr;
   begin
      GetUserDataArea(fs,$7000,se);	{get active msclickptr}
      while (se<>nil) and (se^.ms<>ms) do
	 se := se^.nxtptr;

      getSE := se;
   end;

function Leftfitstring(mystr:string; ln:word) : string;
   var wd,sl  : word;
       tmpstr : string;
   begin
      tmpstr := mystr;
      sl := length(tmpstr);
{     wd := textwidth(tmpstr); }
      wd := sl*8;
      while wd>ln do
	 begin
{	    dec(wd,charwidth(tmpstr[sl])); }
	    dec(wd,8);
	    delete(tmpstr,sl,1);
	    dec(sl);
	 end;
      leftfitstring := tmpstr;
   end;

function Rightfitstring(mystr:string; ln:word) : string;
   var wd : word;
       tmpstr : string;
   begin
      tmpstr := mystr;
{     wd := textwidth(tmpstr); }
      wd := length(tmpstr)*8;
      while wd>ln do
	 begin
{	    dec(wd,charwidth(tmpstr[1])); }
	    dec(wd,8);
	    delete(tmpstr,1,1);
	 end;
      rightfitstring := tmpstr;
   end;


procedure outstring(x,y,x1,y1:word; txtstr:string; color,bkcolor:word);
   begin
      hidemouse;
      TxtCursorOff;
      setfillstyle(solidfill,bkcolor);
      bar(x,y,x1,y1);
      setcolor(color);
      OutTextXY(x,y,txtstr);
      showmouse;
   end;

function FitRight(fs:imagestkptr; ms:msclickptr; mx,my,mx1,my1,cpos,color:word; var txtstr:string) : word;
   var tmpstr : string;
   begin
      tmpstr := rightfitstring(copy(txtstr,1,cpos),mx1-mx);
      outstring(mx,my,mx1,my1,tmpstr,color,white);
{     FitRight := mx+textwidth(tmpstr); }
      FitRight := mx+length(tmpstr)*8;
   end;

function FitLeft(fs:imagestkptr; ms:msclickptr; mx,my,mx1,my1,cpos,color:word; var txtstr:string) : word;
   begin
      Outstring(mx,my,mx1,my1,leftfitstring(copy(txtstr,cpos,255),mx1-mx),color,white);
      FitLeft := mx;
   end;

{$F+}
procedure StrEdit(fs:ImageStkPtr; ms: MsClickPtr);
{$F-}
   var ch      : char;
       txtstr  : string;
       tx1,ty1,lx : word;
       se      : septr;
       color   : word;
       cpos    : word;
       wd      : word;
       mx,my,mx1,my1 : word;
       tmpstr  : string;
       maxlen  : word;
   begin
      se := getactivese(fs);

      tx1    := fs^.x+se^.tcursx;
      ty1    := fs^.y+se^.tcursy;
      txtstr := string(se^.txtstr^);
      cpos   := se^.cpos;
      color  := se^.color;
      maxlen := se^.maxlen;

      mx     := fs^.x+ms^.x;
      my     := fs^.y+ms^.y;
      mx1    := fs^.x+ms^.x1;
      my1    := my+charheight-1;

      while keypressed do
	 begin
	   ch := readkey;

	   IF Ord(ch)=0 THEN
	     BEGIN
	       ch := readkey;
	       {function}
	       CASE Ord(ch) of
		 {left cursor}
		 $4b  : BEGIN
			   if se^.highlighted then
			      begin
				 reversemsarea(fs,se^.ms);
				 se^.highlighted := false;
			      end;

			  IF cpos>1 THEN
			    BEGIN
			      Dec(cpos);
{			      Dec(tx1,CharWidth(txtstr[cpos])); }
			      Dec(tx1,8);

			      if tx1<mx then
				  tx1 := FitLeft(fs,ms,mx,my,mx1,my1,cpos,color,txtstr);

			      TxtCursorPos(tx1,ty1);
			    END;
			END;
		 {right cursor}
		 $4d  : BEGIN
			   if se^.highlighted then
			      begin
				 reversemsarea(fs,se^.ms);
				 se^.highlighted := false;
			      end;

			  IF cpos<=length(txtstr) THEN
			    BEGIN
{			      inc(tx1,CharWidth(txtstr[cpos])); }
			      inc(tx1,8);
			      inc(cpos);

			      if tx1>mx1 then
				  tx1 := FitRight(fs,ms,mx,my,mx1,my1,cpos,color,txtstr);

			      TxtCursorPos(tx1,ty1);
			    END;
			END;
		 {Del}
		 $53  : BEGIN
			  if se^.highlighted then
			     begin
				reversemsarea(fs,se^.ms);
				se^.highlighted := false;
			     end;

			  IF cpos<=length(txtstr) THEN
			    BEGIN
			      Delete(txtstr,cpos,1);
			      tx1 := FitLeft(fs,ms,tx1,ty1,mx1,my1,cpos,color,txtstr);
			      TxtCursorOn;
			    END;
			END;
		 {HOME}
		 $47  : BEGIN
			  if se^.highlighted then
			     begin
				reversemsarea(fs,se^.ms);
				se^.highlighted := false;
			     end;

			  IF cpos>1 THEN
			    BEGIN
			      cpos := 1;

			      {add an external event for
			       shifting a full text page home}

			      tx1 := FitLeft(fs,ms,mx,my,mx1,my1,cpos,color,txtstr);
			      TxtCursorPos(tx1,ty1);
			    end;
			END;
		 {End}
		 $4F  : BEGIN
			  if se^.highlighted then
			     begin
				reversemsarea(fs,se^.ms);
				se^.highlighted := false;
			     end;

			  IF cpos<=length(txtstr) THEN
			    BEGIN
			      cpos := length(txtstr)+1;

			      {add an external event for
			       shifting a full text page to the end}

			      tx1 := FitRight(fs,ms,mx,my,mx1,my1,cpos,color,txtstr);
			      TxtCursorPos(tx1,ty1);
			    END;
			END;
	       END;
	     END
	   else
	     BEGIN
		CASE Ord(ch) of
		  {chars}
		  32..126 : BEGIN
			      if se^.highlighted then
				 begin
				    reversemsarea(fs,se^.ms);
				    se^.highlighted := false;
				    txtstr := '';
				    cpos := 1;
				    tx1 := FitLeft(fs,ms,mx,my,mx1,my1,cpos,color,txtstr);
				    TxtCursorPos(tx1,ty1);
				 end;

			      if (length(txtstr)<maxlen) then
				begin
				  TxtCursorOff;
				  if cpos>length(txtstr) then
				    begin
				      txtstr := txtstr+ch;
				      inc(cpos);

				      lx := tx1;
{				      inc(tx1,charwidth(ch)); }
				      inc(tx1,8);

				      if tx1>mx1 then
					 tx1 := FitRight(fs,ms,mx,my,mx1,my1,cpos,color,txtstr)
				      else
					begin
					   hidemouse;
					   txtcursoroff;
					   setcolor(color);
					   WrtChar(Ord(ch),lx,ty1,color);
					   showmouse;
					end;
				    end
				  else
				    begin
				      lx := tx1;
{				      inc(tx1,charwidth(ch)); }
				      inc(tx1,8);
				      insert(ch,txtstr,cpos);

				      if tx1>mx1 then
					 begin
					    tx1 := FitRight(fs,ms,mx,my,mx1,my1,cpos,color,txtstr);
					    inc(cpos);
					    lx := FitLeft(fs,ms,tx1,ty1,mx1,my1,cpos,color,txtstr);
					 end
				      else
					 begin
					    lx := FitLeft(fs,ms,lx,ty1,mx1,my1,cpos,color,txtstr);
					    inc(cpos);
					 end;
				    END;

				  TxtCursorPos(tx1,ty1);
				end;
			    END;
		  {backspace}
		  8	  : BEGIN
			      if se^.highlighted then
				 begin
				    reversemsarea(fs,se^.ms);
				    se^.highlighted := false;
				 end;

			      IF (cpos=1) and (length(txtstr)>0) then
				 begin
{				    inc(tx1,CharWidth(txtstr[1])); }
				    inc(tx1,8);
				    inc(cpos);
				 end;

			      IF cpos>1 THEN
				 BEGIN
				   Dec(cpos);
{				   Dec(tx1,CharWidth(txtstr[cpos])); }
				   Dec(tx1,8);

				   {if tx1<left mouse click area then
				       redisplay the string and
					reset the cursor area }

				   if tx1<mx then
				      tx1 := mx;

				   {add an external event for
				    shifting a full text page left}

				   Delete(txtstr,cpos,1);
				   tx1 := FitLeft(fs,ms,tx1,ty1,mx1,my1,cpos,color,txtstr);
				   TxtCursorPos(tx1,ty1);
				 END
			    END;
		END;
	     END;
	 end;

      se^.cpos := cpos;
      string(se^.txtstr^) := txtstr;
      se^.tcursx := tx1-fs^.x;
   end;

procedure RedisplayString(fs:imagestkptr; se:septr);
   var tx1     : word;
   begin
      se^.cpos := 1;
      tx1 := FitLeft(fs,se^.ms,fs^.x+se^.ms^.x,fs^.y+se^.ms^.y,
			       fs^.x+se^.ms^.x1,fs^.y+se^.ms^.y1,
			       se^.cpos,se^.color,string(se^.txtstr^));
      se^.tcursx := tx1-fs^.x;
   end;

{$F+}
procedure ReleaseStrEdit(fs:ImageStkPtr; ms: MsClickPtr);
{$F-}
   var se      : septr;
       tx1     : word;
   begin
      if pendactive=nil then
	 pendactive := fs;

      se := getactivese(pendactive);	 {get active se}

      if (se=nil) then
	 setpendingoff
      else
      if (se<>nil) and (se^.ms<>ms) then
	 begin
	    TxtCursorStop;

	    if se^.highlighted then
	       begin
		  reversemsarea(pendactive,se^.ms);
		  se^.highlighted := false;
	       end;

	    se^.active := false;
	    DropKeyClick(pendactive,0,StrEdit);
	    RedisplayString(pendactive,se);
	    se^.formeventexit(pendactive,se^.ms);
	    setpendingoff;
	 end;
   end;


procedure DisplayStrEdit(fs:ImageStkPtr; ms: MsClickPtr);
   var se  : septr;
   begin
      se := getse(fs,ms);

      if (se<>nil) then
	 RedisplayString(fs,se);
   end;


{$F+}
procedure SelectStrEdit(fs:ImageStkPtr; ms: MsClickPtr);
{$F-}
   var se      : septr;
       tx1,ty1 : word;
       nx1     : word;
       txtstr  : string;
       newse   : boolean;
       mx,my   : word;
       cpos,ln : word;
       mouse_xcoord,mouse_ycoord,buttons : word;
   begin
      buttons := mouseposition(mouse_xcoord,mouse_ycoord);
      se := getactivese(fs);	 {get active se}

      if (se<>nil) and (se^.highlighted) then
	 begin
	    reversemsarea(fs,se^.ms);
	    se^.highlighted := false;
	 end;

      newse := false;
      if (se=nil) or (se^.ms<>ms) then
	 begin
	    newse := true;

	    setpendingevent(fs,ReleaseStrEdit);

	    se := getse(fs,ms);
	    se^.active := true;

	    se^.formevent(fs,ms);

	    definelocalkeyclickarea(fs,ms,0,StrEdit);
	 end;

      nx1    := mouse_Xcoord;
      tx1    := fs^.x+se^.tcursx;
      ty1    := fs^.y+se^.tcursy;
      mx     := fs^.x+ms^.x;
      my     := fs^.y+ms^.y;
      cpos   := se^.cpos;
      txtstr := string(se^.txtstr^);
      ln     := length(txtstr);

      if (tx1<nx1) and (cpos<=ln) then
	 begin
	    while (tx1<nx1) and (cpos<=ln) do
	       begin
{		  inc(tx1,charwidth(txtstr[cpos])); }
		  inc(tx1,8);
		  inc(cpos);
	       end;
	    if tx1>nx1 then
	       begin
		  dec(cpos);
{		  dec(tx1,charwidth(txtstr[cpos])); }
		  dec(tx1,8);
	       end;
	 end
      else
      if (tx1>nx1) and (cpos>1) then
	 begin
	    while (tx1>nx1) and (cpos>1) do
	       begin
		  dec(cpos);
{		  dec(tx1,charwidth(txtstr[cpos])); }
		  dec(tx1,8);
	       end;
	 end;

      se^.cpos	 := cpos;
      se^.tcursx := tx1-fs^.x;

      if newse then
	 TxtCursorInit(tx1,ty1,tx1,ty1+charheight-1,9,7)
      else
	 Txtcursorpos(tx1,ty1);

       while mouseposition(mouse_xcoord,mouse_ycoord)<>0 do;
   end;

procedure SetStrEdit(fs:ImageStkPtr; ms: MsClickPtr; ncpos:word);
   var se      : septr;
       tx1,ty1 : word;
       txtstr  : string;
       newse   : boolean;
       mx,my,mx1,my1 : word;
       cpos,ln : word;
       color   : word;
   begin
      se := GetActiveSE(fs);	 {get active se}

      newse := false;
      if (se=nil) or ((se<>nil) and (se^.ms<>ms)) then
	 begin
	    if (se<>nil) then
	       ReleaseStrEdit(fs,nil);

	    se := nil;
	    if ms<>nil then
	       se := Getse(fs,ms);

	    if (se<>nil) then
	       begin
		  newse := true;

		  setpendingevent(fs,ReleaseStrEdit);

		 {change the key to $7fff for active edit string}
		 se^.active := true;

		  definelocalkeyclickarea(fs,ms,0,StrEdit);

		  reversemsarea(fs,se^.ms);
		  se^.highlighted := true;
	       end;
	 end;

      {check if we have changed StrEdits, or whether it is the same
       StrEdit with different txt cursor positions}
      if (se<>nil) and ((newse) or (se^.cpos<>ncpos)) then
	 begin
	    tx1    := fs^.x+se^.tcursx;
	    ty1    := fs^.y+se^.tcursy;
	    mx	   := fs^.x+ms^.x;
	    my	   := fs^.y+ms^.y;
	    mx1    := fs^.x+ms^.x1;
	    my1    := fs^.y+ms^.y1;
	    cpos   := se^.cpos;
	    txtstr := string(se^.txtstr^);
	    ln	   := length(txtstr);
	    color  := se^.color;

	    if ncpos<1 then
	       ncpos:=0
	    else
	    if ncpos>ln then
	       ncpos:=ln;

	    if (cpos<=ncpos) then
	       begin
		  while (cpos<=ncpos) and (tx1<mx1) do
		     begin
{			inc(tx1,charwidth(txtstr[cpos])); }
			inc(tx1,8);
			inc(cpos);
		     end;
		  if (cpos<ncpos) then
		     begin
			cpos := ncpos;
			tx1 := FitRight(fs,ms,mx,my,mx1,my1,cpos-1,color,txtstr);
			if newse then
			   reversemsarea(fs,se^.ms);
		     end;
	       end
	    else
	    if (cpos>ncpos) then
	       begin
		  while (cpos>ncpos) and (tx1>mx) do
		     begin
			dec(cpos);
{			dec(tx1,charwidth(txtstr[cpos])); }
			dec(tx1,8);
		     end;
		  if (cpos>ncpos) then
		     begin
			cpos := ncpos;
			tx1 := FitLeft(fs,ms,mx,my,mx1,my1,cpos,color,txtstr);
			if newse then
			   reversemsarea(fs,se^.ms);
		     end;
	       end;

	    se^.cpos   := cpos;
	    se^.tcursx := tx1-fs^.x;

	    if newse then
	       TxtCursorInit(tx1,ty1,tx1,ty1+Charheight-1,9,7)
	    else
	       Txtcursorpos(tx1,ty1);
	 end;
   end;

procedure DefineStrEditEvent(fs:imagestkptr; x,y,x1,y1,maxlen,color:word;
		       var txtstr:string;
		       formevent,formexit:callproc);
   var se,ose	 : septr;
       ms	 : msclickptr;
       fm	 : boolean;
   begin
      definemouseclickarea(fs,x,y,x1,y1,SelectStrEdit);
      ms := fs^.msptr;

      getmem(se,sizeof(se^));

      se^.nxtptr    := nil;
      se^.cpos	    := 1;
      se^.txtstr    := @txtstr;
      se^.maxlen    := maxlen;
      se^.tcursx    := x;
      se^.tcursy    := y;
      se^.color     := color;
      se^.ms	    := ms;
      se^.active    := false;
      se^.formevent := formevent;
      se^.formeventexit := formexit;
      se^.highlighted := false;

      GetUserDataArea(fs,$7000,ose);
      if ose=nil then
	 SetUserDataArea(fs,$7000,se,FreeStrEdit)
      else
	 begin
	    se^.nxtptr := ose^.nxtptr;
	    ose^.nxtptr := se;
	 end;

      RedisplayString(fs,se);
   end;


end.
