{-----------------------------------------------------------------------------}
{			   TEGL Windows ToolKit II			      }
{		  Copyright (C) 1990, 1992 TEGL Systems Corporation		      }
{			    All Rights Reserved.			      }
{-----------------------------------------------------------------------------}
{$I switches.inc}
{$F+}

Unit TABLINKS;

INTERFACE

USES
     fgraph,
     frames;


type
    tablinkptr	= ^tablinkrec;
    tablinkrec	= RECORD
		     nextptr		  : tablinkptr;
		     lastptr		  : tablinkptr;
		     ms 		  : msclickptr;
		     highlighted	  : boolean;

		     activateproc	  : callproc;
		     highlightproc	  : callproc;
		     dehighlightproc	  : callproc;
		  END;

function  getactivetabnum(ifs:ImageStkPtr):word;

procedure addtablinks(ifs:imagestkptr; ms:msclickptr; highlightproc,dehighlightproc,activateproc:callproc);

procedure settablink(ifs:ImageStkPtr; tabnum:word);

procedure activatetablinks(ifs:imagestkptr; tabnum:word);
procedure deactivatetablinks(ifs:imagestkptr);

IMPLEMENTATION

procedure droptablinks(fs:ImageStkPtr; Userkey:word; Var DataArea);
   var tablinkanchor : tablinkptr absolute DataArea;
       nexttablink   : tablinkptr;
       currtablink   : tablinkptr;
   begin
      currtablink := tablinkanchor;

      repeat
	 nexttablink := currtablink^.nextptr;
	 freemem(currtablink,sizeof(currtablink^));
	 currtablink := nexttablink;
      until currtablink=tablinkanchor;
   END;

function getactivetabs(ifs:ImageStkPtr; var ct:word):tablinkptr;
   var currtablink   : tablinkptr;
       tablinkanchor : tablinkptr;
   begin
      getuserdataarea(ifs,759,tablinkanchor);
      currtablink := tablinkanchor;
      ct := 1;

      if currtablink<>nil then
	 while (not currtablink^.highlighted) and (currtablink^.nextptr<>tablinkanchor) do
	    begin
	       currtablink := currtablink^.nextptr;
	       inc(ct);
	    end;

      if (currtablink=nil) or ((currtablink<>nil) and (not currtablink^.highlighted)) then
	 begin
	    currtablink := nil;
	    ct := 0;
	 end;

      getactivetabs := currtablink;
   END;

function getactivetablink(ifs:ImageStkPtr):tablinkptr;
   var ct : word;
   begin
      getactivetablink := getactivetabs(ifs,ct);
   END;

function getactivetabnum(ifs:ImageStkPtr):word;
   var ct : word;
   begin
      if getactivetabs(ifs,ct)<>nil then;
      getactivetabnum := ct;
   END;

procedure settablink(ifs:ImageStkPtr; tabnum:word);
   var hightablink   : tablinkptr;
       currtablink   : tablinkptr;
       tablinkanchor : tablinkptr;
       ct	     : word;
   begin
      getuserdataarea(ifs,759,tablinkanchor);
      currtablink := tablinkanchor;
      ct := 1;

      if currtablink<>nil then
	 begin
	    while (ct<tabnum) do
	       begin
		  currtablink := currtablink^.nextptr;
		  inc(ct);
	       end;

	    hightablink := getactivetablink(ifs);
	    if (hightablink<>nil) then
	       begin
		  hightablink^.dehighlightproc(ifs,hightablink^.ms);
		  hightablink^.highlighted := false;
	       end;

	    currtablink^.highlightproc(ifs,currtablink^.ms);
	    currtablink^.highlighted := true;
	 end;
   end;

procedure addtablinks(ifs:imagestkptr; ms:msclickptr;
		      highlightproc,dehighlightproc,activateproc:callproc);
   var tablinkanchor : tablinkptr;
       newtablink    : tablinkptr;
   begin
      getuserdataarea(ifs,759,tablinkanchor);
      getmem(newtablink,sizeof(newtablink^));
      if tablinkanchor<>nil then
	 begin
	    newtablink^.nextptr := tablinkanchor;
	    newtablink^.lastptr := tablinkanchor^.lastptr;
	    newtablink^.lastptr^.nextptr := newtablink;
	    tablinkanchor^.lastptr := newtablink;
	 end
      else
	 begin
	    newtablink^.lastptr := newtablink;
	    newtablink^.nextptr := newtablink;
	    setuserdataarea(ifs,759,newtablink,droptablinks);
	 end;

      newtablink^.ms		  := ms;
      newtablink^.highlighted	  := false;
      newtablink^.activateproc	  := activateproc;
      newtablink^.highlightproc   := highlightproc;
      newtablink^.dehighlightproc := dehighlightproc;
   end;

const
   key_tab    : word = $0009;
   key_shftab : word = $0f00;
   key_enter  : word = $000d;

procedure ifstabcontrol(ifs:ImageStkPtr; ms: MsClickPtr);
   var hightablink  : tablinkptr;
       currtablink  : tablinkptr;
       firsttablink : tablinkptr;
   begin
      hightablink := getactivetablink(ifs);
      if hightablink=nil then
	 getuserdataarea(ifs,759,firsttablink)
      else
	 firsttablink := hightablink;

      currtablink := firsttablink;
      if functionkeycode=key_tab then
	 currtablink := currtablink^.nextptr
      else
	 currtablink := currtablink^.lastptr;

      if (hightablink<>currtablink) then
	 begin
	    if (hightablink<>nil) then
		hightablink^.dehighlightproc(ifs,hightablink^.ms);
	    hightablink^.highlighted := false;

	    if (currtablink<>nil) then
	       currtablink^.highlightproc(ifs,currtablink^.ms);
	    currtablink^.highlighted := true;
	 end;
   end;

procedure ifstabenter(ifs:ImageStkPtr; ms: MsClickPtr);
   var hightablink  : tablinkptr;
   begin
      hightablink := getactivetablink(ifs);
      if (hightablink<>nil) then
	 hightablink^.activateproc(ifs,hightablink^.ms);
   end;

procedure activatetablinks(ifs:imagestkptr; tabnum:word);
   begin
      definelocalkeyclickarea(ifs,nil,key_tab,ifstabcontrol);
      definelocalkeyclickarea(ifs,nil,key_shftab,ifstabcontrol);
      definelocalkeyclickarea(ifs,nil,key_enter,ifstabenter);
      settablink(ifs,tabnum);
   end;

procedure deactivatetablinks(ifs:imagestkptr);
   begin
      dropkeyClick(ifs,key_tab,ifstabcontrol);
      dropkeyclick(ifs,key_shftab,ifstabcontrol);
      dropkeyclick(ifs,key_enter,ifstabenter);
   end;

END.
