{-----------------------------------------------------------------------------}
{			   TEGL Windows ToolKit II			      }
{		  Copyright (C) 1990, 1992 TEGL Systems Corporation           }
{			    All Rights Reserved.			      }
{-----------------------------------------------------------------------------}
{$I switches.inc}
{$F+}

Unit intrpts;

INTERFACE

USES Dos,fgraph,msmouse;

const
{$IFDEF StonyBrook}
   Timerbusy	       : boolean  VOLATILE = FALSE;
{$ELSE}
   Timerbusy	       : boolean = FALSE;
{$ENDIF}

Procedure SwapIntrptsOff;
Procedure SwapIntrptsOn;

procedure TxtCursorPos(x1,y1 : word);
procedure TxtCursorOn;
procedure TxtCursorOff;
procedure TxtCursorStop;
procedure TxtCursorInit(x1,y1,x2,y2,blinktime,color:word);

procedure checkblink;

Procedure InitIntrpts;

IMPLEMENTATION

const
    TxtCursInit  : boolean = false;
    TxtCursBlink : boolean = false;
    TxtCursLast  : boolean = false;
    BlinkFlag	 : boolean = false;

VAR
    Intrpts_ExitSave : Pointer;
    SaveInt08	      : Pointer;	{timer}

    X1TC	      : word;
    Y1TC	      : word;
    X2TC	      : word;
    Y2TC	      : word;
    x1Txtdiff	      : word;
    y1Txtdiff	      : word;

    BlinkRate	      : word;
    TxtCursStat       : boolean;	     {flag for Txt cursor on/off}
    TxtCursColor      : word;
    TxtCursSize       : word;
    Blinkcount	      : word;


procedure TxtCursOn(x1,y1:word);
   var lastrmwb  : word;
   begin
      X1TC  := x1;
      Y1TC  := y1;
      Y2TC  := y1+y1txtdiff;

      hidemouse;
      lastrmwb := RmwBits;
      RmwBits := Xorput;
      fastline(X1TC,Y1TC,X1TC,Y2TC,TxtCursColor);
      RmwBits := lastrmwb;
      showmouse;

      TxtCursStat := True;
   end;

procedure TxtCursOff;
   var lastrmwb  : word;
   begin
      if TxtCursStat then
	 begin
	    hidemouse;
	    lastrmwb := RmwBits;
	    RmwBits := Xorput;
	    Fastline(X1TC,Y1TC,X1TC,Y2TC,TxtCursColor);
	    RmwBits := lastrmwb;
	    showmouse;
	 end;

      TxtCursStat := false;
   end;

procedure TxtCursorPos(x1,y1 : word);
   var lastcursStat  : boolean;
       lastmouse     : boolean;
   begin
      if TxtCursInit then
	 begin
	    if txtcursblink then
	       begin
		  txtcursblink	:= false;
		  while timerbusy do;	    {wait before setting new position}
	       end;

	    lastcursStat := TxtCursStat;
	    if TxtCursStat then
	       TxtCursOff;

	    X1TC  := x1;
	    Y1TC  := y1;
	    X2TC  := x1+x1txtdiff;
	    Y2TC  := y1+y1txtdiff;

	    if lastcursStat then
	       TxtCursOn(x1,y1);

	    Txtcursblink := True;
	 end;
   end;

procedure TxtCursorOn;
   var lastmouse : boolean;
   begin
      if TxtCursInit then
	 begin
	    Txtcursblink := false;
	    while timerbusy do;

	    if not TxtCursStat then
	       TxtCursOn(X1TC,Y1TC);

	    Blinkcount	 := Blinkrate;
	    Txtcursblink := true;
	 end;
   end;

procedure TxtCursorOff;
   begin
      if TxtCursInit then
	 begin
	    Txtcursblink := false;
	    while timerbusy do;
	    if TxtCursStat then
	       TxtCursOff;
	 end;
   end;

procedure TxtCursorStop;
   begin
      TxtCursorOff;
      TxtCursInit  := false;
   end;

procedure TxtCursorInit(x1,y1,x2,y2,blinktime,color:word);
   begin
      if txtcursinit then
	 TxtCursorStop;

      Blinkrate    := blinktime;
      txtcursblink := false;
      TxtCursInit  := true;
      TxtCursColor := color;
      TxtCursStat  := false;

      X1TC  := x1;
      Y1TC  := y1;
      X2TC  := x2;
      Y2TC  := y2;
      x1Txtdiff := x2tc-x1tc;
      y1Txtdiff := y2tc-y1tc;

      TxtCursorOn;
   end;

procedure checkblink;
  begin
      if TxtCursblink then
	 begin
	    if blinkflag then
	       begin
		  if TxtCursStat then
		     TxtCursOff
		  else
		     TxtCursOn(X1TC,Y1TC);

		  blinkcount := blinkrate;
		  blinkflag := false;
	       end;
	 end;
  end;

Procedure TimerHandler(Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP: Word);
  Interrupt;
  BEGIN
      if TxtCursblink then
	 begin
	    Timerbusy := true;
	    dec(blinkcount);
	    if blinkcount=0 then
	       blinkflag := true;
	    Timerbusy := false;
	 end;

     Inline(
	     $9C/     {PUSHF ;Save the flags}
	     $FF/$1E/>SaveInt08); {CALL [Saveint08]}

  END;

Procedure Intrpts_TerminateExit;
   BEGIN
     SetIntVec($08,SaveInt08);
     ExitProc := Intrpts_ExitSave;
   END;

Procedure SwapIntrptsOff;
   BEGIN
     SetIntVec($08,SaveInt08);
   END;

Procedure SwapIntrptsOn;
   BEGIN
     GetIntVec($08,SaveInt08);
     SetIntVec($08,@TimerHandler);
   END;

Procedure InitIntrpts;
   begin
      SwapIntrptsOn;

      Intrpts_ExitSave	:= ExitProc;
      ExitProc	:= @Intrpts_TerminateExit;
   end;

END.
