{------------------------------------------------------------------------------}
{		    Concepts from the TEGL Windows Toolkit		       }
{		   Copyright (C) 1992, TEGL Systems Corporation 	       }
{			     All Rights Reserved.			       }
{------------------------------------------------------------------------------}
{$I switches.inc}

unit fgraph;

INTERFACE

const
    RmwBits	 : Word = 0;

    EGA 	       =  3;
    VGA 	       =  9;
    EGAHi	       =  1;  { 640x350 16 color 2 page }
    VGAMed	       =  1;  { 640x350 16 color 2 page }
    VGAHi	       =  2;  { 640x480 16 color 1 page }

    { Constants for GetBiti and PutBiti }
    NormalPut	       =  0;
    CopyPut	       =  0;
    AndPut	       =  $08;
    OrPut	       =  $10;
    XORPut	       =  $18;
    NotPut	       =  $80;

    { Error Constants for GraphResults }
    grOk	       =   0;
    grInvalidDriver    =  -4;
    grInvalidMode      = -10;


    { Color Constants }
    Black	       =  0;
    Blue	       =  1;
    Green	       =  2;
    Cyan	       =  3;
    Red 	       =  4;
    Magenta	       =  5;
    Brown	       =  6;
    LightGray	       =  7;
    DarkGray	       =  8;
    LightBlue	       =  9;
    LightGreen	       =  10;
    LightCyan	       =  11;
    LightRed	       =  12;
    LightMagenta       =  13;
    Yellow	       =  14;
    White	       =  15;

    { Fill patterns for Get/SetFillStyle: }
    SolidFill	    = 1;  { fills area in solid fill color }

    { use constant instead of function return / saves 48 bytes of code}
    graphresult : integer = 0;
    getmaxx	: word = 639;
    getmaxy	: word = 349;


procedure InitGraph(var GR,GM : integer; PathToDriver : String);
Procedure OutTextXY(x,y : Integer; mystr : String);
function  ImageSize(x,y,x1,y1:Word) :longint;
Procedure line(x,y,x1,y1:Word);
Procedure getimage(x,y,x1,y1:Word;var buffer);
Procedure putimage(x,y:Word;var buffer;RmwBits:Word);
procedure setcolor(color:word);
procedure setfillstyle(filltype,color:word);
procedure rectangle(x1, y1, x2, y2 : integer);
procedure CloseGraph;
procedure RestoreCrtMode;
procedure bar(x,y,x1,y1:word);
function  textheight(textstring:string) : word;
function  textwidth(textstring:string):word;
procedure setwritemode(writemode:integer);
function  getcolor:word;
function  charwidth(ch:char) : word;

Procedure FastLine (x,y,x1,y2,n:Word);
Procedure wrtchar(c,x,y,Color:Word);
Function  CharHeight : Word;

IMPLEMENTATION

const
    ActivePage	  : Word = $0000;

    BytesPerLine  : Word = 80;

    color_	  : word = 15;
    fillcolor_	  : word = 15;
    lastmode__	  : byte = $ff;
    lastpage__	  : byte = $ff;
    Ingraphics	  : boolean = false;

    egapalette	  : array[0..16] of byte =
		    (0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63,0);

function  ImageSize(x,y,x1,y1:Word) :longint; external;
Procedure FastLine (x,y,x1,y2,n:Word); external;
Procedure getimage(x,y,x1,y1:Word;var buffer); external;
Procedure putimage(x,y:Word;var buffer;RmwBits:Word); external;
Procedure wrtchar(c,x,y,Color:Word); external;
procedure setgrmode(gm:integer); external;
Function  CharHeight : Word; external;
procedure currentvid; external;
procedure restorevid; external;
{$L fgraph.obj}

function getcolor:word;
   begin
      getcolor := color_;
   end;

procedure setwritemode(writemode:integer);
   begin
      RMWBits := writemode;
   end;

function textwidth(textstring:string):word;
   begin
      textwidth := length(textstring)*8;
   end;

Procedure OutTextXY(x,y : Integer; mystr : String);
   VAR i  : Integer;
   BEGIN
      FOR i:=1 to length(mystr) DO
	 BEGIN
	    wrtchar(Ord(mystr[i]),x,y,Color_);
	    inc(x,8);
	 END;
   END;

function textheight(textstring:string) : word;
   begin
      textheight := charheight;
   end;

function charwidth(ch:char) : word;
   begin
      charwidth := 8;
   end;

procedure setcolor(color:word);
   begin
      color_ := color;
   end;

procedure line(x,y,x1,y1:word);
   begin
      fastline(x,y,x1,y1,color_);
   end;

procedure rectangle(x1, y1, x2, y2 : integer);
  BEGIN
    fastLine(x1+1,y1,x2,y1,color_);
    fastLine(x2,y1+1,x2,y2,color_);
    fastLine(x2-1,y2,x1,y2,color_);
    fastLine(x1,y2-1,x1,y1,color_);
  END;

procedure bar(x,y,x1,y1:word);
   var i : word;
   begin
      for i:=y to y1 do
	 fastline(x,i,x1,i,fillcolor_);
   end;

procedure setfillstyle(filltype,color:word);
   begin
      fillcolor_ := color;
   end;

procedure InitGraph(var GR,GM : integer; PathToDriver : String);  { -- ignore }
  BEGIN
     graphresult := grOK;
     if GR in [EGA,VGA] then
	begin
	   if GM in [EGAHi,VGAMed,VGAHi] then
	      begin
		 setgrmode(GM);
		 Ingraphics := true;
	      end
	   else
	      graphresult := grInvalidMode
	end
     else
	graphresult := grInvalidDriver;
  END;

procedure RestoreCrtMode;
  BEGIN
    if Ingraphics then
       begin
	  Restorevid;
	  Ingraphics := false;
       end;
  END;

procedure CloseGraph;
  BEGIN
    RestoreCrtMode;
  END;

begin
   currentvid;
END.
