Program FixMem;
{
   Fix Mem Version 1.0 (C)1994 Sutron Corporation, (703)406-2800, February 3, 1995
   Written by: Jonathan D. Weisberg, CIS:74710,1675
   Language  : Borland Pascal for Windows version 7.0

   Sutron develops mission critical Windows programs for environmental real-time data
   collection which multi-task and run for extended periods.

   You may make changes to this source code and executable as long as you do not delete
   or change the information in this header or remove the (C)1994 Sutron Corp from the
   icon title and include a notation as to the changes made.

   The executable may be freely distributed, executed, and copied.

   This software is made available to the public "as-is" without warranty of any kind.

   FixMem fixes what I would refer to as a "bug" in Windows which leads to the infamous
   "Insufficent memory to run this application" error when you seem to have plenty of
   memory and resources. This problem is caused by applications which Fix or Lock pages
   of memory. Moveable memory is allocated starting from the beginning of memory,
   discardable memory is allocated starting from the end. When an application Fixes or Locks
   a page of memory it becomes no longer moveable. If enough of these pages build up below
   the real mode boundary of 1MB then Windows will run out of room to create 512 byte Task
   Database Blocks (TDBs) - preventing new Tasks/Programs from being started.

   FixMem fixes the problem by consuming all but 4K bytes of this memory (up to a max of 100K).
   Strange but true ... you have to consume memory to save memory...
   This forces Windows to allocate new pages larger than 4K above the 1MB barrier. When FixMem
   notices that a new task has been run or stopped it will re-adjust so that at least 4K bytes
   is available again. Run FixMem as early as you can, and it will struggle to hold on to this
   precious resource as other programs you start up try to eat it away. COM programs are
   especially troublesome because they must fix the location of their rx/tx interrupt buffers.
   Net DDE in WFW also uses a large quantity of fixed pages.

   YEAH BUT! If you run a program which uses GlobalDOSAlloc and allocates pages larger than
   4K bytes then it will most likely report an out of memory error. Send me e-mail if you
   run across a program like this. Of course you can always close FixMem and it will free
   up all the memory it has snared.
}

{
   Change history:

}

{$C PRELOAD MOVEABLE DISCARDABLE}
{$R FIXMEM.RES}

Uses WinProcs, WinTypes, OWindows, Strings;


Type
   { Define a TApplication descendant }
   TMainApp = Object(TApplication)
      Procedure InitMainWindow; Virtual;
   End;

   PMainWin = ^TMainWin;
   TMainWin = Object(TWindow)
      Constructor Init(AParent : PWindowsObject; ATitle : PChar);
      Procedure SetupWindow; Virtual;
      Procedure Timer(var Msg : TMessage); Virtual wm_First+wm_Timer;
      Procedure GetWindowClass(Var WndClass : TWndClass); Virtual;
      Procedure SetTitle;
      Procedure QueryOpen(Var Msg : TMessage); Virtual wm_First+wm_QueryOpen;
      Destructor Done; Virtual;
   End;

Var
   MainApp       : TMainApp;

Var
   Stack : Array[1..100] Of LongInt;

Const
   AllocUnit = 1024;
   Reserve = 4;

Const
   SP : Word = 0;

Procedure AllocSome;
Var i : Word;
Begin
   For i := Sp+1 To 100 Do
      Begin
         Stack[i] := GlobalDOSAlloc(AllocUnit);
         If Stack[i] = 0 Then
            Break;
         Inc(Sp);
      End;
End;

Procedure FreeUp;
Var i : Word;
Begin
   For i := 1 To Reserve Do
      If Sp > 0 Then
         Begin
            GlobalDOSFree(Stack[Sp]);
            Dec(Sp);
         End;
End;

Constructor TMainWin.Init(AParent : PWindowsObject; ATitle : PChar);
Begin
   Inherited Init(AParent, ATitle);
   Attr.Style := ws_Iconic+ws_SysMenu+ws_MinimizeBox;
   CmdShow    := sw_ShowMinimized;
   Sp := 0;
End;

Procedure TMainWin.QueryOpen(Var Msg : TMessage);
Begin
   Msg.Result := 0;  { Do not allow icon to be opened }
End;

Procedure TMainWin.SetupWindow;
Begin
   Inherited SetupWindow;
   AllocSome;
   FreeUp;
   SetTitle;
   SetTimer(hWindow, Integer(hWindow), 1000, Nil)
End;

Procedure TMainWin.GetWindowClass(Var WndClass : TWndClass);
Begin
   Inherited GetWindowClass(WndClass);
   WndClass.hIcon := LoadIcon(hInstance, 'FIXMEM');
End;

Procedure TMainWin.SetTitle;
Var Title : Array[0..40] Of Char;
Const PrevSp : Word = 65535;
Begin
   If PrevSp = Sp Then
      Exit;
   PrevSp := Sp;
   StrCopy(Title, 'Fix'#160'Mem'#160#160#160'0K'#160'Free (C)1994'#160'Sutron'#160'Corp.');
   If Sp >= 100 Then
      Title[7+1] := Chr(Sp Div 100 + 48);
   If Sp >= 10 Then
      Title[7+2] := Chr(Sp Div 10 Mod 10 + 48);
   Title[7+3] := Chr(Sp Mod 10 + 48);
   SetWindowText(hWindow, Title);
End;

Procedure TMainWin.Timer(Var Msg : TMessage);
Const PrevNumTasks : Word = 0;
Begin
   If GetNumTasks <> PrevNumTasks Then
      Begin
         AllocSome;
         FreeUp;
         SetTitle;
      End;
End;

Destructor TMainWin.Done;
Begin
   KillTimer(hWindow, Integer(hWindow));
   While Sp > 0 Do
      Begin
         GlobalDOSFree(Stack[Sp]);
         Dec(Sp);
      End;
   Inherited Done;
End;


Procedure TMainApp.InitMainWindow;
Begin
   MainWindow := New(PMainWin, Init(Nil, 'Fix Mem'));
End;

Begin
   MainApp.Init('FixMemApp');
   MainApp.Run;
   MainApp.Done;
End.
