{*******************************************************
              FFindApp Program

 This program is a version of my unit development tool
 which is a simple Turbo Vision application used for unit
 development. This program is purely for demonstrating the
 file ffind.pas. See the filefind unit source code for
 further details of the component objects and how they work. 

              Paul Warren
     HomeGrown Software Development
   (c) 1992 Langley British Columbia.

********************************************************}

program FFindApp;

{$X+,S-}
{$M 8192,8192,655360}

uses
  Dos, Objects, Memory, Drivers, Views, Menus, Dialogs,
  Stddlg, App, MsgBox, Gadgets, FHeader, FileFind;

type
  PFFindApp = ^TFFindApp;
  TFFindApp = object(TApplication)
    Clock: PClockView;
    Heap: PHeapView;
    constructor Init;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

constructor TFFindApp.Init;
var
  R: TRect;
begin
  TApplication.Init;

  RegisterFileFind;

  GetExtent(R);
  R.A.X := R.B.X - 9; R.B.Y := R.A.Y + 1;
  Clock := New(PClockView, Init(R));
  Insert(Clock);

  GetExtent(R);
  Dec(R.B.X);
  R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
  Heap := New(PHeapView, Init(R));
  Insert(Heap);
end;

procedure TFFindApp.HandleEvent(var Event: TEvent);
var
  NewMode: Word;

procedure DosShell;
begin
  DoneSysError;
  DoneEvents;
  DoneVideo;
  DoneMemory;
  SetMemTop(HeapPtr);
  PrintStr('Type EXIT to return...');
  SwapVectors;
  Exec(GetEnv('COMSPEC'), '');
  SwapVectors;
  SetMemTop(HeapEnd);
  InitMemory;
  InitVideo;
  InitEvents;
  InitSysError;
  Redraw;
end;

procedure DoFindFile(WildCard: PathStr);
var
  D: PFileFindDialog;
  Control: word;
begin
  D := New(PFileFindDialog, Init(FExpand('.'), WildCard));
  Control := DeskTop^.ExecView(D);
  Dispose(D, Done);
end;

begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmDoFileFind  : DoFindFile('*.txt');
      cmDosShell    : DosShell;
      cmAbout: MessageBox(#3'HomeGrown Software Development'#13#3 +
        'Unit Development Tool'#13#3 +
        'by Paul Warren', nil, mfInformation + mfOkButton);
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TFFindApp.Idle;

begin
  TApplication.Idle;
  Clock^.Update;
  Heap^.Update;
end;

procedure TFFindApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~A~bout', hcNoContext, NewMenu(
      NewItem('~A~bout Development Tool...','', kbNoKey, cmAbout, hcNoContext,
      nil)),
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewItem('~F~ind File...', '', kbNoKey, cmDoFileFind, hcNoContext,
      NewItem('~D~OS shell','', kbNoKey, cmDosShell, hcNoContext,
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil)))),
  nil)))))
end;

procedure TFFindApp.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y-1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~F10~ Menu', kbF10, cmMenu,
    nil)),
  nil)));
end;

var
  FFind: TFFindApp;
begin
  FFind.Init;
  FFind.Run;
  FFind.Done;
end.
